/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import java.util.HashMap;
import java.util.Map;

public class JSObjectPropertiesCollector
extends JSTreeWalker {
    private Map<String, JSNode> properties = new HashMap<String, JSNode>();

    @Override
    public void visit(JSNameValuePairNode node) {
        IParseNode idNode = node.getFirstChild();
        IParseNode valueNode = node.getLastChild();
        if (idNode != null) {
            String propName = null;
            if (idNode instanceof JSIdentifierNode) {
                JSIdentifierNode identifierNode = (JSIdentifierNode)idNode;
                propName = identifierNode.getText();
            } else if (idNode instanceof JSStringNode) {
                JSStringNode strNode = (JSStringNode)idNode;
                propName = strNode.getString();
            }
            if (StringUtil.isEmpty(propName) || !StringUtil.isIdentifier((String)propName)) {
                return;
            }
            if (valueNode != null && valueNode instanceof JSNode) {
                this.properties.put(propName, (JSNode)valueNode);
            } else {
                this.properties.put(propName, null);
            }
        }
    }

    public Map<String, JSNode> getProperties() {
        return this.properties;
    }
}

