/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.inferencing.JSSymbolTypeInferrer;
import com.aptana.editor.js.parsing.ast.JSArrayNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSBinaryArithmeticOperatorNode;
import com.aptana.editor.js.parsing.ast.JSBinaryBooleanOperatorNode;
import com.aptana.editor.js.parsing.ast.JSConditionalNode;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSFalseNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetElementNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSGroupNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSNumberNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSPostUnaryOperatorNode;
import com.aptana.editor.js.parsing.ast.JSPreUnaryOperatorNode;
import com.aptana.editor.js.parsing.ast.JSRegexNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.editor.js.parsing.ast.JSTrueNode;
import com.aptana.editor.js.parsing.ast.JSXElementNode;
import com.aptana.editor.js.parsing.lexer.JSTokenType;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public abstract class JSNodeTypeInferrer<T>
extends JSTreeWalker {
    protected JSScope _scope;
    protected Index _index;
    protected URI _location;
    protected JSIndexQueryHelper _queryHelper;

    public JSNodeTypeInferrer(JSScope scope, Index projectIndex, URI location) {
        this(scope, projectIndex, location, new JSIndexQueryHelper());
    }

    public JSNodeTypeInferrer(JSScope scope, Index projectIndex, URI location, JSIndexQueryHelper queryHelper) {
        this._scope = scope;
        this._index = projectIndex;
        this._location = location;
        this._queryHelper = queryHelper;
    }

    protected abstract void addParameterTypes(JSIdentifierNode var1);

    protected abstract JSSymbolTypeInferrer<T> createSymbolTypeInferrer(JSScope var1, Index var2, URI var3);

    protected abstract void addType(T var1);

    protected void addTypes(IParseNode node) {
        if (node instanceof JSNode) {
            ((JSNode)node).accept(this);
        }
    }

    protected abstract void addTypes(List<String> var1);

    protected JSScope getActiveScope(int offset) {
        JSScope result = null;
        if (this._scope != null) {
            JSScope candidate;
            JSScope root = this._scope;
            while ((candidate = root.getParentScope()) != null) {
                root = candidate;
            }
            result = root.getScopeAtOffset(offset);
        }
        return result;
    }

    public abstract List<String> getTypeNames(IParseNode var1);

    public abstract List<String> getTypeNames();

    public abstract List<T> getTypes(IParseNode var1, JSScope var2);

    public List<T> getTypes(IParseNode node) {
        return this.getTypes(node, this._scope);
    }

    public abstract List<T> getTypes();

    protected abstract JSNodeTypeInferrer<T> createNodeTypeInferrer(JSScope var1, Index var2, URI var3, JSIndexQueryHelper var4);

    @Override
    public void visit(JSArrayNode node) {
        if (!node.hasChildren()) {
            this.addType(this.getGenericType("Array"));
        } else {
            for (T type : this.getTypes(node.getFirstChild())) {
                this.addType(this.getGenericArrayType(type));
            }
        }
    }

    public abstract T getGenericArrayType(T var1);

    @Override
    public void visit(JSAssignmentNode node) {
        switch (node.getNodeType()) {
            case 1: {
                this.addTypes(node.getRightHandSide());
                break;
            }
            case 2: {
                String type = "Number";
                ArrayList<String> lhsTypes = new ArrayList<String>(2);
                lhsTypes.addAll(this.getTypeNames(node.getLeftHandSide()));
                ArrayList<String> rhsTypes = new ArrayList<String>(2);
                rhsTypes.addAll(this.getTypeNames(node.getRightHandSide()));
                if (lhsTypes.contains("String") || rhsTypes.contains("String")) {
                    type = "String";
                }
                this.addType(this.getGenericType(type));
                break;
            }
            default: {
                this.addType(this.getGenericType("Number"));
            }
        }
    }

    @Override
    public void visit(JSBinaryArithmeticOperatorNode node) {
        String type = "Number";
        if (node.getNodeType() == 36) {
            IParseNode lhs = node.getLeftHandSide();
            IParseNode rhs = node.getRightHandSide();
            while (lhs.getNodeType() == 36) {
                rhs = lhs.getLastChild();
                lhs = lhs.getFirstChild();
                if (rhs instanceof JSStringNode) break;
            }
            if (lhs instanceof JSStringNode || rhs instanceof JSStringNode) {
                type = "String";
            } else {
                ArrayList<String> lhsTypes = new ArrayList<String>(2);
                lhsTypes.addAll(this.getTypeNames(lhs));
                ArrayList<String> rhsTypes = new ArrayList<String>(2);
                rhsTypes.addAll(this.getTypeNames(rhs));
                if (lhsTypes.contains("String") || rhsTypes.contains("String")) {
                    type = "String";
                }
            }
        }
        this.addType(this.getGenericType(type));
    }

    @Override
    public void visit(JSBinaryBooleanOperatorNode node) {
        JSTokenType token = JSTokenType.get((String)node.getOperator().value);
        switch (token) {
            case AMPERSAND_AMPERSAND: 
            case PIPE_PIPE: {
                this.addTypes(node.getLeftHandSide());
                this.addTypes(node.getRightHandSide());
                break;
            }
            default: {
                this.addType(this.getGenericType("Boolean"));
            }
        }
    }

    @Override
    public void visit(JSConditionalNode node) {
        this.addTypes(node.getTrueExpression());
        this.addTypes(node.getFalseExpression());
    }

    @Override
    public abstract void visit(JSConstructNode var1);

    @Override
    public void visit(JSFalseNode node) {
        this.addType(this.getGenericType("Boolean"));
    }

    @Override
    public abstract void visit(JSThisNode var1);

    @Override
    public abstract void visit(JSFunctionNode var1);

    @Override
    public abstract void visit(JSGetElementNode var1);

    @Override
    public abstract void visit(JSGetPropertyNode var1);

    @Override
    public void visit(JSGroupNode node) {
        IParseNode expression = node.getExpression();
        if (expression instanceof JSNode) {
            ((JSNode)expression).accept(this);
        }
    }

    @Override
    public void visit(JSXElementNode node) {
        this.addType(this.getGenericType("JSXElement"));
    }

    @Override
    public abstract void visit(JSIdentifierNode var1);

    protected String getFileName() {
        return com.aptana.core.util.URIUtil.getFileName((URI)this._location);
    }

    protected IProject getProject() {
        URI root = this._index.getRoot();
        IPath containerPath = URIUtil.toPath((URI)root);
        if (containerPath == null) {
            return null;
        }
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(containerPath);
        if (container == null) {
            return null;
        }
        return container.getProject();
    }

    @Override
    public abstract void visit(JSInvokeNode var1);

    @Override
    public void visit(JSNumberNode node) {
        this.addType(this.getGenericType("Number"));
    }

    protected abstract T getGenericType(String var1);

    protected abstract String getTypeName(T var1);

    @Override
    public abstract void visit(JSObjectNode var1);

    @Override
    public void visit(JSPostUnaryOperatorNode node) {
        this.addType(this.getGenericType("Number"));
    }

    @Override
    public void visit(JSPreUnaryOperatorNode node) {
        switch (node.getNodeType()) {
            case 49: 
            case 50: {
                this.addType(this.getGenericType("Boolean"));
                break;
            }
            case 56: {
                this.addType(this.getGenericType("String"));
                this.addType(this.getGenericType("TypeString"));
                break;
            }
            case 57: {
                break;
            }
            default: {
                this.addType(this.getGenericType("Number"));
            }
        }
    }

    @Override
    public void visit(JSRegexNode node) {
        this.addType(this.getGenericType("RegExp"));
    }

    @Override
    public void visit(JSStringNode node) {
        this.addType(this.getGenericType("String"));
    }

    @Override
    public void visit(JSTrueNode node) {
        this.addType(this.getGenericType("Boolean"));
    }

    public abstract List<T> getArgumentTypes(JSInvokeNode var1, int var2, JSScope var3);

    public abstract Collection<T> getFunctionTypes(JSInvokeNode var1, JSScope var2);
}

