/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.ParameterElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGeneratorMethodNode;
import com.aptana.editor.js.parsing.ast.JSGetMethodNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSMethodNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSSetMethodNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import java.util.ArrayList;
import java.util.List;

public class JSGetPropertyCollector
extends JSTreeWalker {
    private List<PropertyElement> properties = new ArrayList<PropertyElement>();

    @Override
    public void visit(JSNameValuePairNode node) {
        IParseNode lhs = node.getName();
        IParseNode rhs = node.getValue();
        String name = null;
        name = lhs instanceof JSStringNode ? ((JSStringNode)lhs).getString() : lhs.getText();
        if (StringUtil.isNotEmpty((String)name) && StringUtil.isIdentifier((String)name)) {
            this.addProperties(rhs, name);
        }
        super.visit(node);
    }

    @Override
    public void visit(JSGetPropertyNode node) {
        if (node.getParent() instanceof JSAssignmentNode) {
            JSAssignmentNode assignNode = (JSAssignmentNode)node.getParent();
            IParseNode rhs = assignNode.getRightHandSide();
            String name = node.getRightHandSide().getText();
            this.addProperties(rhs, name);
        }
        super.visit(node);
    }

    @Override
    public void visit(JSGeneratorMethodNode node) {
        this.addProperties((IParseNode)node, node.getMethodName());
        super.visit(node);
    }

    @Override
    public void visit(JSGetMethodNode node) {
        this.addProperties((IParseNode)node, node.getMethodName());
        super.visit(node);
    }

    @Override
    public void visit(JSMethodNode node) {
        this.addProperties((IParseNode)node, node.getMethodName());
        super.visit(node);
    }

    @Override
    public void visit(JSSetMethodNode node) {
        this.addProperties((IParseNode)node, node.getMethodName());
        super.visit(node);
    }

    private void addProperties(IParseNode rhs, String name) {
        if (rhs instanceof JSFunctionNode) {
            FunctionElement functionElement = new FunctionElement();
            functionElement.setName(name);
            JSFunctionNode funcNode = (JSFunctionNode)rhs;
            IParseNode params = funcNode.getParameters();
            for (IParseNode parseNode : params) {
                ParameterElement parameter = new ParameterElement();
                parameter.setName(parseNode.getText());
                functionElement.addParameter(parameter);
            }
            this.properties.add(functionElement);
        } else {
            PropertyElement propertyElement = new PropertyElement();
            propertyElement.setName(name);
            this.properties.add(propertyElement);
        }
    }

    public List<PropertyElement> getProperties() {
        return this.properties;
    }
}

