/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.inferencing.JSAssistNodeTypeInferrer;
import com.aptana.editor.js.contentassist.inferencing.JSAssistSymbolTypeInferrer;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.ParameterElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.ValueElement;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.inferencing.JSTypeMapper;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSWithNode;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSArgumentTypeInferrer
extends JSAssistNodeTypeInferrer {
    private int index = 0;
    private Map<String, List<ValueElement>> types = new HashMap<String, List<ValueElement>>();
    private List<String> parentTypes = new ArrayList<String>(2);

    public JSArgumentTypeInferrer(JSScope scope, Index projectIndex, URI location, JSIndexQueryHelper queryHelper, int index) {
        super(scope, projectIndex, location, queryHelper);
        this.index = index;
    }

    @Override
    public void visit(JSGetPropertyNode node) {
        block3: {
            List<String> typeNames;
            String memberName;
            block4: {
                IParseNode lhs = node.getLeftHandSide();
                if (!(lhs instanceof JSNode)) break block3;
                IParseNode rhs = node.getRightHandSide();
                memberName = rhs.getText();
                typeNames = this.getTypeNames(lhs);
                if (!CollectionsUtil.isEmpty(typeNames)) break block4;
                Collection<PropertyElement> properties = this._queryHelper.getTypeMembers(this._index, "", memberName);
                if (properties == null) break block3;
                for (PropertyElement property : properties) {
                    FunctionElement function;
                    List<ParameterElement> params;
                    if (!(property instanceof FunctionElement) || (params = (function = (FunctionElement)property).getParameters()) == null || params.size() <= this.index) continue;
                    ParameterElement paramEl = params.get(this.index);
                    this.addParameterType(paramEl);
                }
                break block3;
            }
            for (String typeName : typeNames) {
                typeName = JSTypeMapper.getInstance().getMappedType(typeName);
                this.parentTypes.add(typeName);
                Collection<PropertyElement> properties = this._queryHelper.getTypeMembers(this._index, typeName, memberName);
                if (properties == null) continue;
                for (PropertyElement property : properties) {
                    FunctionElement function;
                    List<ParameterElement> params;
                    if (!(property instanceof FunctionElement) || (params = (function = (FunctionElement)property).getParameters()) == null || params.size() <= this.index) continue;
                    ParameterElement paramEl = params.get(this.index);
                    this.addParameterType(paramEl);
                }
            }
        }
    }

    private void addParameterType(ParameterElement paramEl) {
        if (!CollectionsUtil.isEmpty(paramEl.getTypes())) {
            for (String type : paramEl.getTypes()) {
                this.types.put(type, paramEl.getValues());
            }
        }
    }

    @Override
    public void visit(JSIdentifierNode node) {
        String name = node.getText();
        Collection<PropertyElement> properties = null;
        if (this._scope != null && this._scope.hasSymbol(name)) {
            JSAssistSymbolTypeInferrer symbolInferrer = (JSAssistSymbolTypeInferrer)this.createSymbolTypeInferrer(this._scope, this._index, this._location);
            symbolInferrer.setWriteSubType(false);
            PropertyElement property = symbolInferrer.getSymbolPropertyElement(name);
            properties = property != null ? CollectionsUtil.newList((Object[])new PropertyElement[]{property}) : this._queryHelper.getGlobals(this._index, this.getProject(), this.getFileName(), name);
        } else {
            IParseNode exprnode;
            JSScope localScope;
            JSWithNode withnode = ParseUtil.getWithNode((IParseNode)node);
            if (withnode != null && (localScope = ParseUtil.getScopeAtOffset(exprnode = withnode.getExpression(), exprnode.getStartingOffset())) == ParseUtil.getScopeAtOffset((IParseNode)node, node.getStartingOffset())) {
                JSAssistNodeTypeInferrer typeInferrer = (JSAssistNodeTypeInferrer)this.createNodeTypeInferrer(localScope, this._index, this._location, this._queryHelper);
                typeInferrer.visit((JSNode)exprnode);
                List<String> typeNames = typeInferrer.getTypeNames();
                if (!CollectionsUtil.isEmpty(typeNames)) {
                    properties = new ArrayList<PropertyElement>();
                    for (String typeName : typeNames) {
                        properties.addAll(this._queryHelper.getTypeMembers(this._index, typeName, name));
                    }
                }
            }
            if (CollectionsUtil.isEmpty(properties)) {
                properties = this._queryHelper.getGlobals(this._index, this.getProject(), this.getFileName(), name);
            }
        }
        if (properties != null) {
            for (PropertyElement property : properties) {
                FunctionElement function;
                List<ParameterElement> params;
                if (!(property instanceof FunctionElement) || (params = (function = (FunctionElement)property).getParameters()) == null || params.size() <= this.index) continue;
                ParameterElement paramEl = params.get(this.index);
                this.addParameterType(paramEl);
            }
        }
    }

    @Override
    public void visit(JSInvokeNode invoke) {
        IParseNode expNode = invoke.getExpression();
        if (expNode instanceof JSGetPropertyNode) {
            JSGetPropertyNode getPropertyNode = (JSGetPropertyNode)expNode;
            getPropertyNode.accept(this);
        } else if (expNode instanceof JSIdentifierNode) {
            JSIdentifierNode idNode = (JSIdentifierNode)expNode;
            idNode.accept(this);
        }
    }

    public List<String> getParentTypes() {
        return this.parentTypes;
    }

    public Map<String, List<ValueElement>> getValueTypes() {
        return this.types;
    }
}

