/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.hyperlink;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.js.hyperlink.JSAbstractHyperlink;
import com.aptana.editor.js.hyperlink.JSIdentifierCollector;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.util.List;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IRegion;

public class JSSearchStringHyperlink
extends JSAbstractHyperlink {
    private String searchString;

    public JSSearchStringHyperlink(IRegion hyperlinkRegion, String typeLabel, String hyperlinkText, String targetFilePath, String searchString) {
        super(hyperlinkRegion, typeLabel, hyperlinkText, targetFilePath);
        this.searchString = searchString;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (result && obj instanceof JSSearchStringHyperlink) {
            result = ObjectUtil.areEqual((Object)this.getSearchString(), (Object)((JSSearchStringHyperlink)obj).getSearchString());
        }
        return result;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void open() {
        AbstractThemeableEditor editor = this.getEditor();
        if (editor != null) {
            IParseRootNode ast = editor.getAST();
            JSIdentifierNode targetIdentifier = null;
            if (ast instanceof JSParseRootNode) {
                JSIdentifierCollector collector = new JSIdentifierCollector(this.searchString);
                ((JSParseRootNode)ast).accept(collector);
                List<JSIdentifierNode> identifiers = collector.getIdentifiers();
                if ("invocation".equals(this.getTypeLabel())) {
                    for (JSIdentifierNode identifier : identifiers) {
                        if (identifier.getParent().getNodeType() != 70) continue;
                        targetIdentifier = identifier;
                        break;
                    }
                }
                if (targetIdentifier == null && !CollectionsUtil.isEmpty(identifiers)) {
                    targetIdentifier = identifiers.get(0);
                }
            }
            if (targetIdentifier != null) {
                editor.selectAndReveal(targetIdentifier.getStart(), targetIdentifier.getLength());
            } else {
                IFindReplaceTarget target = (IFindReplaceTarget)editor.getAdapter(IFindReplaceTarget.class);
                if (target != null && target.canPerformFind()) {
                    target.findAndSelect(0, this.searchString, true, true, true);
                } else {
                    editor.selectAndReveal(0, 0);
                }
            }
        }
    }
}

