/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.hyperlink;

import com.aptana.core.IFilter;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.index.IReferIndexQueryHelper;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.ThisAssignmentCollector;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.inferencing.JSObjectPropertiesCollector;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSConditionalNode;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetElementNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSParametersNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSReturnNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.index.core.Index;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.util.ParseUtil;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class JSNodeHyperlinkInferrer
extends JSTreeWalker {
    private Map<String, List<JSNode>> targets = new LinkedHashMap<String, List<JSNode>>();
    private JSScope globalScope = null;
    private IProject _project = null;
    private URI _location = null;
    private Index _index = null;
    private boolean singleIdentifier = false;

    public JSNodeHyperlinkInferrer(IProject project, URI location, Index index, JSScope globalScope) {
        this.globalScope = globalScope;
        this._index = index;
        this._location = location;
        this._project = project;
    }

    public boolean isSingleIdentifier() {
        return this.singleIdentifier;
    }

    public void setSingleIdentifier(boolean singleIdentifier) {
        this.singleIdentifier = singleIdentifier;
    }

    @Override
    public void visit(JSGetPropertyNode node) {
        JSPropertyCollection property;
        JSIdentifierNode leftNode;
        JSScope localScope;
        JSNodeHyperlinkInferrer hyperlinkInferrer = new JSNodeHyperlinkInferrer(this._project, this._location, this._index, this.globalScope);
        hyperlinkInferrer.setSingleIdentifier(this.isSingleIdentifier());
        hyperlinkInferrer.visit((JSNode)node.getLeftHandSide());
        Map<String, List<JSNode>> _targets = hyperlinkInferrer.getTargetNodes();
        String symbol = node.getRightHandSide().getText();
        if (!CollectionsUtil.isEmpty(_targets)) {
            for (Map.Entry<String, List<JSNode>> entry : _targets.entrySet()) {
                block5: for (JSNode target : entry.getValue()) {
                    switch (target.getNodeType()) {
                        case 77: {
                            JSObjectPropertiesCollector propertiesCollector = new JSObjectPropertiesCollector();
                            propertiesCollector.visit(target);
                            Map<String, JSNode> properties = propertiesCollector.getProperties();
                            this.addTargetNode(entry.getKey(), properties.get(symbol));
                            break;
                        }
                        case 70: {
                            JSFunctionNode funcNode = (JSFunctionNode)target;
                            ThisAssignmentCollector thisAssignmentCollector = new ThisAssignmentCollector();
                            thisAssignmentCollector.visit((JSNode)funcNode.getBody());
                            List<JSAssignmentNode> assginNodes = thisAssignmentCollector.getAssignments();
                            for (JSAssignmentNode assginNode : assginNodes) {
                                JSGetPropertyNode getNode = (JSGetPropertyNode)assginNode.getLeftHandSide();
                                if (!symbol.equals(getNode.getRightHandSide().getText())) continue;
                                this.addTargetNode(entry.getKey(), (JSNode)assginNode.getRightHandSide());
                            }
                            continue block5;
                        }
                    }
                }
            }
        }
        if (node.getLeftHandSide() instanceof JSIdentifierNode && (localScope = this.globalScope.getScopeAtOffset((leftNode = (JSIdentifierNode)node.getLeftHandSide()).getStartingOffset())) != null && (property = localScope.getSymbol(leftNode.getText())) != null && property.hasProperty(symbol)) {
            JSPropertyCollection child = property.getProperty(symbol);
            this.addTargetNodes(this._location.toString(), child.getValues());
        }
    }

    private void addTargetNodes(Map<String, List<JSNode>> _targets) {
        this.targets.putAll(_targets);
    }

    private void addTargetNodes(String location, List<JSNode> _targets) {
        if (!CollectionsUtil.isEmpty(_targets) && StringUtil.isNotEmpty((String)location)) {
            if (this.targets.containsKey(location)) {
                this.targets.get(location).addAll(_targets);
            } else {
                this.targets.put(location, _targets);
            }
        }
    }

    private void addTargetNode(String location, JSNode _target) {
        if (_target != null && StringUtil.isNotEmpty((String)location)) {
            if (this.targets.containsKey(location)) {
                this.targets.get(location).add(_target);
            } else {
                ArrayList<JSNode> _targets = new ArrayList<JSNode>();
                _targets.add(_target);
                this.targets.put(location, _targets);
            }
        }
    }

    @Override
    public void visit(JSConditionalNode node) {
        IParseNode falseNode;
        IParseNode trueNode = node.getTrueExpression();
        if (trueNode != null && trueNode instanceof JSNode) {
            JSNodeHyperlinkInferrer hyperlinkInferrer = new JSNodeHyperlinkInferrer(this._project, this._location, this._index, this.globalScope);
            hyperlinkInferrer.setSingleIdentifier(this.isSingleIdentifier());
            hyperlinkInferrer.visit((JSNode)trueNode);
            this.addTargetNodes(hyperlinkInferrer.getTargetNodes());
        }
        if ((falseNode = node.getFalseExpression()) != null && falseNode instanceof JSNode) {
            JSNodeHyperlinkInferrer hyperlinkInferrer = new JSNodeHyperlinkInferrer(this._project, this._location, this._index, this.globalScope);
            hyperlinkInferrer.setSingleIdentifier(this.isSingleIdentifier());
            hyperlinkInferrer.visit((JSNode)falseNode);
            this.addTargetNodes(hyperlinkInferrer.getTargetNodes());
        }
    }

    @Override
    public void visit(JSConstructNode node) {
        IParseNode exprNode = node.getExpression();
        if (exprNode instanceof JSNode) {
            JSNodeHyperlinkInferrer hyperlinkInferrer = new JSNodeHyperlinkInferrer(this._project, this._location, this._index, this.globalScope);
            hyperlinkInferrer.setSingleIdentifier(this.isSingleIdentifier());
            hyperlinkInferrer.visit((JSNode)exprNode);
            this.addTargetNodes(hyperlinkInferrer.getTargetNodes());
        }
    }

    @Override
    public void visit(JSFunctionNode node) {
        this.addTargetNode(this._location.toString(), node);
    }

    @Override
    public void visit(JSGetElementNode node) {
        super.visit(node);
    }

    @Override
    public void visit(JSInvokeNode node) {
        IParseNode ivkExprNode = node.getExpression();
        if (ivkExprNode instanceof JSNode) {
            JSNodeHyperlinkInferrer linkInferrer = new JSNodeHyperlinkInferrer(this._project, this._location, this._index, this.globalScope);
            linkInferrer.setSingleIdentifier(this.isSingleIdentifier());
            linkInferrer.visit((JSNode)ivkExprNode);
            Map<String, List<JSNode>> _targets = linkInferrer.getTargetNodes();
            if (!CollectionsUtil.isEmpty(_targets)) {
                for (Map.Entry<String, List<JSNode>> entry : _targets.entrySet()) {
                    for (JSNode target : entry.getValue()) {
                        JSFunctionNode targetFuncNode;
                        List<JSReturnNode> returnNodes;
                        if (!(target instanceof JSFunctionNode) || CollectionsUtil.isEmpty(returnNodes = (targetFuncNode = (JSFunctionNode)target).getReturnNodes())) continue;
                        for (JSReturnNode returnNode : returnNodes) {
                            JSNodeHyperlinkInferrer hyperlinkInferrer = new JSNodeHyperlinkInferrer(this._project, this._location, this._index, this.globalScope);
                            hyperlinkInferrer.setSingleIdentifier(this.isSingleIdentifier());
                            hyperlinkInferrer.visit((JSNode)returnNode.getExpression());
                            this.addTargetNodes(hyperlinkInferrer.getTargetNodes());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void visit(JSObjectNode node) {
        this.addTargetNode(this._location.toString(), node);
    }

    @Override
    public void visit(JSIdentifierNode node) {
        JSScope localScope = this.globalScope.getScopeAtOffset(node.getStartingOffset());
        if (localScope == null) {
            localScope = this.globalScope;
        }
        JSPropertyCollection properties = localScope.getSymbol(node.getText());
        if (this.isSingleIdentifier()) {
            if (properties != null && CollectionsUtil.isNotEmpty(properties.getValues())) {
                this.addTargetNodes(this._location.toString(), properties.getValues());
            } else {
                this.processReferences(node);
            }
        } else if (properties != null && CollectionsUtil.isNotEmpty(properties.getValues())) {
            if (properties.isVisited()) {
                return;
            }
            properties.setVisited(true);
            for (JSNode value : properties.getValues()) {
                if (value != null && value.getParent() instanceof JSParametersNode) continue;
                JSNodeHyperlinkInferrer hyperlinkInferrer = new JSNodeHyperlinkInferrer(this._project, this._location, this._index, this.globalScope);
                hyperlinkInferrer.setSingleIdentifier(this.isSingleIdentifier());
                hyperlinkInferrer.visit(value);
                this.addTargetNodes(hyperlinkInferrer.getTargetNodes());
            }
            if (properties.hasProperty("prototype")) {
                JSPropertyCollection protoProps = properties.getProperty("prototype");
                if (protoProps.isVisited()) {
                    return;
                }
                protoProps.setVisited(true);
                for (JSNode value : protoProps.getValues()) {
                    JSNodeHyperlinkInferrer hyperlinkInferrer = new JSNodeHyperlinkInferrer(this._project, this._location, this._index, this.globalScope);
                    hyperlinkInferrer.setSingleIdentifier(this.isSingleIdentifier());
                    hyperlinkInferrer.visit(value);
                    this.addTargetNodes(hyperlinkInferrer.getTargetNodes());
                }
            }
        } else {
            this.processReferences(node);
        }
    }

    protected void processReferences(JSIdentifierNode node) {
        final IProject currentProject = this._project;
        if (currentProject == null) {
            return;
        }
        IReferIndexQueryHelper referQueryHelper = CommonEditorPlugin.getDefault().getReferIndexQueryHelper();
        if (referQueryHelper == null) {
            return;
        }
        Map references = referQueryHelper.getJSReferences(this._index);
        if (CollectionsUtil.isEmpty((Map)references)) {
            return;
        }
        Set htmlFiles = (Set)references.get(this._location.toString());
        if (CollectionsUtil.isEmpty((Collection)htmlFiles)) {
            return;
        }
        final LinkedHashMap<String, Set<JSParseRootNode>> sRootNodes = new LinkedHashMap<String, Set<JSParseRootNode>>();
        currentProject.getLocationURI().relativize(this._location).toString();
        if (!(node.getRootNode() instanceof JSParseRootNode)) {
            return;
        }
        JSIndexQueryHelper queryHelper = new JSIndexQueryHelper();
        for (String string : htmlFiles) {
            final IFile file = currentProject.getFile(string);
            if (!file.exists()) continue;
            try {
                Set<String> sFiles;
                String symbolName = node.getText();
                Collection<PropertyElement> props = queryHelper.getFileGlobals(this._index, this._project, file.getLocationURI(), symbolName);
                if (CollectionsUtil.isNotEmpty(props)) {
                    ParseResult result = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (String)IOUtils.toString((InputStream)file.getContents(), (String)file.getCharset()));
                    IParseRootNode rootNode = result.getRootNode();
                    if (rootNode == null) continue;
                    ParseUtil.treeApply((IParseNode)rootNode, (IFilter)new IFilter<IParseNode>(){

                        public boolean include(IParseNode current) {
                            JSNodeHyperlinkInferrer.this.findJSParseRootNodes(current, currentProject, file, sRootNodes);
                            return true;
                        }
                    }, (boolean)false);
                }
                if (!CollectionsUtil.isNotEmpty(sFiles = this.getReferenceJavaScripts(string, references))) continue;
                sFiles.remove(this._location.toString());
                for (String sFileLocation : sFiles) {
                    try {
                        ParseResult result;
                        String relativePath;
                        IFile sFile;
                        URI location = URI.create(sFileLocation);
                        Collection<PropertyElement> sProps = queryHelper.getFileGlobals(this._index, this._project, location, symbolName);
                        if (!CollectionsUtil.isNotEmpty(sProps) || !(sFile = currentProject.getFile(relativePath = currentProject.getLocationURI().relativize(location).toString())).exists() || sRootNodes.containsKey(relativePath) || !((result = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (String)IOUtils.toString((InputStream)sFile.getContents(), (String)sFile.getCharset()))).getRootNode() instanceof JSParseRootNode)) continue;
                        this.addParseRootNode(sRootNodes, relativePath, (JSParseRootNode)result.getRootNode());
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {}
        }
        for (Map.Entry entry : sRootNodes.entrySet()) {
            String location = (String)entry.getKey();
            IFile file = currentProject.getFile(location);
            for (JSParseRootNode rootNode : (Set)entry.getValue()) {
                JSScope global = rootNode.getGlobals();
                if (global == null || !global.hasLocalSymbol(node.getText())) continue;
                JSPropertyCollection property = global.getLocalSymbol(node.getText());
                for (JSNode value : property.getValues()) {
                    if (this.isSingleIdentifier()) {
                        this.addTargetNode(file.getLocationURI().toString(), value);
                        continue;
                    }
                    JSNodeHyperlinkInferrer hyperlinkInferrer = new JSNodeHyperlinkInferrer(this._project, file.getLocationURI(), this._index, global);
                    hyperlinkInferrer.setSingleIdentifier(this.isSingleIdentifier());
                    hyperlinkInferrer.visit(value);
                    for (Map.Entry<String, List<JSNode>> target : hyperlinkInferrer.getTargetNodes().entrySet()) {
                        this.addTargetNodes(target.getKey(), target.getValue());
                    }
                }
            }
        }
    }

    private Set<String> getReferenceJavaScripts(String htmlFile, Map<String, Set<String>> references) {
        if (CollectionsUtil.isNotEmpty(references)) {
            HashSet<String> results = new HashSet<String>();
            for (Map.Entry<String, Set<String>> entry : references.entrySet()) {
                if (!entry.getValue().contains(htmlFile)) continue;
                results.add(entry.getKey());
            }
            return results;
        }
        return Collections.emptySet();
    }

    private void addParseRootNode(Map<String, Set<JSParseRootNode>> sRootNodes, String filePathKey, JSParseRootNode rootNode) {
        if (sRootNodes.containsKey(filePathKey)) {
            sRootNodes.get(filePathKey).add(rootNode);
        } else {
            HashSet<JSParseRootNode> rootNodeSet = new HashSet<JSParseRootNode>();
            rootNodeSet.add(rootNode);
            sRootNodes.put(filePathKey, rootNodeSet);
        }
    }

    protected void findJSParseRootNodes(IParseNode current, IProject currentProject, IFile htmlFile, Map<String, Set<JSParseRootNode>> sRootNodes) {
        if (current.getClass().getName().endsWith("HTMLSpecialNode")) {
            IParseNode child;
            String srcValue;
            IParseNodeAttribute[] attributes = current.getAttributes();
            HashMap<String, String> attrValues = new HashMap<String, String>(attributes.length);
            IParseNodeAttribute[] iParseNodeAttributeArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNodeAttribute attr = iParseNodeAttributeArray[n2];
                attrValues.put(attr.getName(), attr.getValue());
                ++n2;
            }
            if (this.isJavaScript(attrValues) && StringUtil.isEmpty((String)(srcValue = (String)attrValues.get("src"))) && (child = current.getChild(0)) != null && child instanceof JSParseRootNode) {
                String relativePath = htmlFile.getProjectRelativePath().toString();
                this.addParseRootNode(sRootNodes, relativePath, (JSParseRootNode)child);
            }
        }
    }

    protected boolean isJavaScript(Map<String, String> attrValues) {
        if (CollectionsUtil.isEmpty(attrValues) || !attrValues.containsKey("type")) {
            return true;
        }
        return "text/javascript".equals(attrValues.get("type").toLowerCase());
    }

    public Map<String, List<JSNode>> getTargetNodes() {
        return this.targets;
    }
}

