/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.hyperlink;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.js.hyperlink.JSHyperlinkCollector;
import com.aptana.editor.js.hyperlink.JSTargetRegionHyperlink;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class JSHyperlinkDetector
extends AbstractHyperlinkDetector {
    private List<IRange> ranges;

    public List<IRange> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<IRange> ranges) {
        this.ranges = ranges;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        return this.detectHyperlinks(this.getEditor(textViewer), region, canShowMultipleHyperlinks);
    }

    public IHyperlink[] detectHyperlinks(AbstractThemeableEditor editor, IRegion region, boolean canShowMultipleHyperlinks) {
        Object[] result = null;
        if (editor != null && region != null) {
            IParseRootNode ast = null;
            try {
                ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (String)editor.getDocument().get()).getRootNode();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ast instanceof JSParseRootNode) {
                result = this.processAST(editor, (JSParseRootNode)ast, region.getOffset());
                this.recomputeHyperlink(editor, (IHyperlink[])result);
            }
        }
        if (!canShowMultipleHyperlinks && !ArrayUtil.isEmpty((Object[])result)) {
            result = new IHyperlink[]{result[0]};
        }
        return result;
    }

    protected IHyperlink[] recomputeHyperlink(AbstractThemeableEditor editor, IHyperlink[] result) {
        if (result == null || result.length == 0) {
            return result;
        }
        IHyperlink[] iHyperlinkArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            JSTargetRegionHyperlink hyperlink;
            IHyperlink link = iHyperlinkArray[n2];
            if (link instanceof JSTargetRegionHyperlink && (hyperlink = (JSTargetRegionHyperlink)link).getHyperlinkText().startsWith("<") && hyperlink.getHyperlinkText().endsWith(">")) {
                String prefix = hyperlink.getTargetFilePath().replaceFirst(Platform.getLocation().toString(), "");
                if (prefix.startsWith("file:/")) {
                    prefix = prefix.replaceFirst("file:/", "");
                }
                hyperlink.setHyperlinkText(String.valueOf(prefix) + hyperlink.getHyperlinkText());
            }
            ++n2;
        }
        return null;
    }

    protected IHyperlink[] processAST(AbstractThemeableEditor editor, JSParseRootNode ast, int offset) {
        if (offset > ast.getEndingOffset()) {
            offset = ast.getLastChild().getStartingOffset();
        }
        JSHyperlinkCollector collector = new JSHyperlinkCollector(editor, ast, offset);
        collector.setRanges(this.getRanges());
        ast.accept(collector);
        Collection<IHyperlink> result = collector.getHyperlinks();
        ast.getGlobals().reset();
        return CollectionsUtil.isEmpty(result) ? null : result.toArray(new IHyperlink[result.size()]);
    }

    protected AbstractThemeableEditor getEditor(ITextViewer textViewer) {
        AbstractThemeableEditor result = null;
        if (textViewer instanceof IAdaptable) {
            result = (AbstractThemeableEditor)((IAdaptable)textViewer).getAdapter(AbstractThemeableEditor.class);
        }
        return result;
    }
}

