/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ObjectUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.hyperlink.IJSHyperlink;
import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;

public abstract class JSAbstractHyperlink
implements IJSHyperlink {
    public static final String INVOCATION_TYPE = "invocation";
    public static final String VARIABLE_TYPE = "variable";
    public static final String PARAMETER_TYPE = "parameter";
    public static final String LOCAL_DECLARTION_TYPE = "local declaration";
    public static final String LOCAL_ASSIGNMENT_TYPE = "local assignment";
    public static final String NAME_VALUE_TYPE = "name value";
    private IRegion hyperlinkRegion;
    private String typeLabel;
    private String hyperlinkText;
    private String targetFilePath;

    protected JSAbstractHyperlink(IRegion hyperlinkRegion, String typeLabel, String hyperlinkText, String targetFilePath) {
        this.hyperlinkRegion = hyperlinkRegion;
        this.typeLabel = typeLabel;
        this.hyperlinkText = "Open in " + hyperlinkText;
        this.targetFilePath = targetFilePath;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JSAbstractHyperlink) {
            JSAbstractHyperlink that = (JSAbstractHyperlink)obj;
            return ObjectUtil.areEqual((Object)this.getHyperlinkRegion(), (Object)that.getHyperlinkRegion()) && ObjectUtil.areEqual((Object)this.getHyperlinkText(), (Object)that.getHyperlinkText()) && ObjectUtil.areEqual((Object)this.getTargetFilePath(), (Object)that.getTargetFilePath());
        }
        return super.equals(obj);
    }

    protected AbstractThemeableEditor getEditor() {
        IEditorPart part = null;
        if (this.targetFilePath != null) {
            try {
                File file = new File(new URI(this.targetFilePath));
                if (file.exists()) {
                    part = EditorUtil.openInEditor((File)file);
                } else {
                    IResource findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(this.targetFilePath);
                    if (findMember instanceof IFile && findMember.exists()) {
                        part = EditorUtil.openInEditor((File)new File(((IFile)findMember).getLocationURI()));
                    }
                }
            }
            catch (Exception e) {
                String message = "An error occurred while trying to retrieve the current editor: " + e.getMessage();
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)message);
            }
        }
        return part instanceof AbstractThemeableEditor ? (AbstractThemeableEditor)part : null;
    }

    public IRegion getHyperlinkRegion() {
        return this.hyperlinkRegion;
    }

    public String getHyperlinkText() {
        return this.hyperlinkText;
    }

    public void setHyperlinkText(String hyperlinkText) {
        this.hyperlinkText = hyperlinkText;
    }

    @Override
    public String getTargetFilePath() {
        return this.targetFilePath;
    }

    public String getTypeLabel() {
        return this.typeLabel;
    }
}

