/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.model;

import com.aptana.core.IFilter;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.model.BaseElement;
import com.aptana.editor.js.contentassist.model.EventElement;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.Messages;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.ReturnTypeElement;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.index.core.IndexUtil;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TypeElement
extends BaseElement<Property> {
    private static final String FUNCTIONS_PROPERTY = "functions";
    private static final String PROPERTIES_PROPERTY = "properties";
    private static final String EVENTS_PROPERTY = "events";
    private static final String EXAMPLES_PROPERTY = "examples";
    private static final String REMARKS_PROPERTY = "remarks";
    private static final String DEPRECATED_PROPERTY = "deprecated";
    private static final String IS_INTERNAL_PROPERTY = "internal";
    private List<String> _parentTypes;
    private List<TypeElement> _parentTypeElements;
    private List<PropertyElement> _properties;
    private List<EventElement> _events;
    private List<String> _examples;
    private List<String> _remarks;
    private boolean _deprecated;
    private boolean _serializeProperties;
    private boolean _isInternal;
    private List<ReturnTypeElement> _returnTypes = null;

    public void addEvent(EventElement event) {
        if (event != null) {
            if (this._events == null) {
                this._events = new ArrayList<EventElement>();
            }
            this._events.add(event);
            event.setOwningType(this.getName());
        }
    }

    public void addExample(String example) {
        if (example != null && example.length() > 0) {
            if (this._examples == null) {
                this._examples = new ArrayList<String>();
            }
            this._examples.add(example);
        }
    }

    public void addParentType(String type) {
        if (type != null && type.length() > 0) {
            if (this._parentTypes == null) {
                this._parentTypes = new ArrayList<String>();
            }
            if (!this._parentTypes.contains(type)) {
                this._parentTypes.add(type);
            }
        }
    }

    public void addParentType(TypeElement type) {
        if (type != null) {
            if (this._parentTypeElements == null) {
                this._parentTypeElements = new ArrayList<TypeElement>();
            }
            if (!JSTypeUtil.hasType(this._parentTypeElements, type)) {
                this._parentTypeElements.add(type);
            }
        }
    }

    public void addProperty(PropertyElement property) {
        if (property != null) {
            if ("this".equals(property.getName())) {
                return;
            }
            if (this._properties == null) {
                this._properties = new ArrayList<PropertyElement>();
            }
            if (!this._properties.contains(property)) {
                this._properties.add(property);
            }
            if (StringUtil.isNotEmpty((String)this.getName())) {
                property.setOwningType(this.getName());
            }
        }
    }

    public void setAllPropertys(List<PropertyElement> list) {
        this._properties = list;
    }

    public void addRemark(String remark) {
        if (remark != null && remark.length() > 0) {
            if (this._remarks == null) {
                this._remarks = new ArrayList<String>();
            }
            this._remarks.add(remark);
        }
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        if (object.containsKey(PROPERTIES_PROPERTY)) {
            List properties = IndexUtil.createList(object.get(PROPERTIES_PROPERTY), PropertyElement.class);
            for (PropertyElement property : properties) {
                this.addProperty(property);
            }
        }
        if (object.containsKey(FUNCTIONS_PROPERTY)) {
            List functions = IndexUtil.createList(object.get(FUNCTIONS_PROPERTY), PropertyElement.class);
            for (PropertyElement function : functions) {
                this.addProperty(function);
            }
        }
        if (object.containsKey(EVENTS_PROPERTY)) {
            List events = IndexUtil.createList(object.get(EVENTS_PROPERTY), EventElement.class);
            for (EventElement event : events) {
                this.addEvent(event);
            }
        }
        if (object.containsKey(EXAMPLES_PROPERTY)) {
            List examples = IndexUtil.createList(object.get(EXAMPLES_PROPERTY));
            for (String example : examples) {
                this.addExample(example);
            }
        }
        if (object.containsKey(REMARKS_PROPERTY)) {
            List remarks = IndexUtil.createList(object.get(REMARKS_PROPERTY));
            for (String remark : remarks) {
                this.addRemark(remark);
            }
        }
        this.setIsDeprecated(Boolean.TRUE == object.get(DEPRECATED_PROPERTY));
        this.setIsInternal(Boolean.TRUE == object.get(IS_INTERNAL_PROPERTY));
    }

    public List<FunctionElement> getConstructors() {
        ArrayList<FunctionElement> result = new ArrayList<FunctionElement>();
        for (PropertyElement property : this.getProperties()) {
            FunctionElement function;
            if (!(property instanceof FunctionElement) || !(function = (FunctionElement)property).isConstructor()) continue;
            result.add(function);
        }
        return result;
    }

    public List<EventElement> getEvents() {
        return CollectionsUtil.getListValue(this._events);
    }

    public EventElement getEvent(final String eventName) {
        return (EventElement)CollectionsUtil.find(this.getEvents(), (IFilter)new IFilter<EventElement>(){

            public boolean include(EventElement item) {
                return item != null && ObjectUtil.areEqual((Object)eventName, (Object)item.getName());
            }
        });
    }

    public List<String> getExamples() {
        return CollectionsUtil.getListValue(this._examples);
    }

    public List<String> getParentTypes() {
        return CollectionsUtil.getListValue(this._parentTypes);
    }

    public List<TypeElement> getParentTypeElements() {
        return CollectionsUtil.getListValue(this._parentTypeElements);
    }

    public List<PropertyElement> getProperties() {
        return CollectionsUtil.getListValue(this._properties);
    }

    public PropertyElement getProperty(String name) {
        int index = this.getPropertyIndex(name);
        PropertyElement result = null;
        if (index != -1) {
            result = this._properties.get(index);
        }
        return result;
    }

    protected int getPropertyIndex(String name) {
        int result = -1;
        if (name != null && name.length() > 0 && this._properties != null) {
            int i = 0;
            while (i < this._properties.size()) {
                PropertyElement property = this._properties.get(i);
                if (name.equals(property.getName())) {
                    result = i;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public List<String> getRemarks() {
        return CollectionsUtil.getListValue(this._remarks);
    }

    public boolean getSerializeProperties() {
        return this._serializeProperties;
    }

    public boolean hasParentTypes() {
        return this._parentTypes != null && !this._parentTypes.isEmpty();
    }

    public boolean hasProperties() {
        return this._properties != null && !this._properties.isEmpty();
    }

    public void addReturnType(ReturnTypeElement returnType) {
        if (this._returnTypes == null) {
            this._returnTypes = new ArrayList<ReturnTypeElement>(2);
        }
        this._returnTypes.add(returnType);
    }

    public List<ReturnTypeElement> getReturnTypes() {
        return CollectionsUtil.getListValue(this._returnTypes);
    }

    public boolean isInternal() {
        return this._isInternal;
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public boolean removeProperty(PropertyElement property) {
        boolean result = false;
        if (this._properties != null) {
            result = this._properties.remove(property);
        }
        return result;
    }

    public void setIsDeprecated(boolean value) {
        this._deprecated = value;
    }

    public void setIsInternal(boolean isInternal) {
        this._isInternal = isInternal;
    }

    public void setSerializeProperties(boolean value) {
        this._serializeProperties = value;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        if (this._serializeProperties) {
            ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>(this.getProperties());
            ArrayList<FunctionElement> functions = new ArrayList<FunctionElement>();
            for (PropertyElement property : properties) {
                if (!(property instanceof FunctionElement)) continue;
                functions.add((FunctionElement)property);
            }
            properties.removeAll(functions);
            out.add(PROPERTIES_PROPERTY, properties);
            out.add(FUNCTIONS_PROPERTY, functions);
            out.add(EVENTS_PROPERTY, this.getEvents());
            out.add(EXAMPLES_PROPERTY, this.getExamples());
            out.add(REMARKS_PROPERTY, this.getRemarks());
            out.add(DEPRECATED_PROPERTY, this.isDeprecated());
            out.add(IS_INTERNAL_PROPERTY, this.isInternal());
        }
    }

    @Override
    public void toSource(SourcePrinter printer) {
        printer.print(this.getName());
        if (this.hasParentTypes()) {
            printer.print(" : ").print(StringUtil.join((String)", ", this.getParentTypes()));
        }
        printer.println().print('{').increaseIndent().println();
        for (PropertyElement property : this.getProperties()) {
            property.toSource(printer);
            printer.println(';');
        }
        for (EventElement event : this.getEvents()) {
            event.toSource(printer);
            printer.println(';');
        }
        printer.decreaseIndent().println('}');
    }

    public String toString() {
        SourcePrinter printer = new SourcePrinter();
        this.toSource(printer);
        return printer.toString();
    }

    static enum Property implements IPropertyInformation<TypeElement>
    {
        NAME(Messages.TypeElement_Name){

            public Object getPropertyValue(TypeElement node) {
                return node.getName();
            }
        }
        ,
        PARENT_TYPES(Messages.TypeElement_ParentTypes){

            public Object getPropertyValue(TypeElement node) {
                return StringUtil.join((String)",", node.getParentTypes());
            }
        }
        ,
        DESCRIPTION(Messages.TypeElement_Description){

            public Object getPropertyValue(TypeElement node) {
                return node.getDescription();
            }
        }
        ,
        DOCUMENTS(Messages.TypeElement_Documents){

            public Object getPropertyValue(TypeElement node) {
                return StringUtil.join((String)", ", node.getDocuments());
            }
        }
        ,
        EVENT_COUNT(Messages.TypeElement_EventCount){

            public Object getPropertyValue(TypeElement node) {
                return node.getEvents().size();
            }
        }
        ,
        PROPERTY_COUNT(Messages.TypeElement_PropertyCount){

            public Object getPropertyValue(TypeElement node) {
                return node.getProperties().size();
            }
        }
        ,
        DEPRECATED(Messages.TypeElement_Deprecated){

            public Object getPropertyValue(TypeElement node) {
                return node.isDeprecated();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

