/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.model;

import com.aptana.editor.js.contentassist.model.BaseElement;
import com.aptana.editor.js.contentassist.model.Messages;
import com.aptana.index.core.Index;
import com.aptana.index.core.ui.views.IPropertyInformation;
import java.util.EnumSet;
import java.util.Set;

public class JSElement
extends BaseElement<Property> {
    private Index index;

    public JSElement(Index index) {
        this.index = index;
        this.setName(Messages.JSElement_NodeLabel);
    }

    public Index getIndex() {
        return this.index;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    static enum Property implements IPropertyInformation<JSElement>
    {
        NAME(Messages.JSElement_Name){

            public Object getPropertyValue(JSElement node) {
                return node.getName();
            }
        }
        ,
        INDEX(Messages.JSElement_IndexLabel){

            public Object getPropertyValue(JSElement node) {
                return node.getIndex().toString();
            }
        }
        ,
        INDEX_FILE(Messages.JSElement_IndexFile){

            public Object getPropertyValue(JSElement node) {
                return node.getIndex().getIndexFile().getAbsolutePath();
            }
        }
        ,
        INDEX_FILE_SIZE(Messages.JSElement_IndexFileSizeLabel){

            public Object getPropertyValue(JSElement node) {
                return node.getIndex().getIndexFile().length();
            }
        }
        ,
        CHILD_COUNT(Messages.JSElement_ChildCount){

            public Object getPropertyValue(JSElement node) {
                return 2;
            }
        }
        ,
        VERSION(Messages.JSElement_Version){

            public Object getPropertyValue(JSElement node) {
                return 14.1212;
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

