/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.model;

import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.model.BaseElement;
import com.aptana.editor.js.contentassist.model.Messages;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public class EventPropertyElement
extends BaseElement<Property> {
    private static final String TYPE_PROPERTY = "type";
    private static final String DEPRECATED_PROPERTY = "deprecated";
    private String _type;
    private boolean _deprecated;

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this.setType(StringUtil.getStringValue(object.get(TYPE_PROPERTY)));
        this.setIsDeprecated(Boolean.TRUE == object.get(DEPRECATED_PROPERTY));
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public void setIsDeprecated(boolean value) {
        this._deprecated = value;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(TYPE_PROPERTY, (Object)this.getType());
        out.add(DEPRECATED_PROPERTY, this.isDeprecated());
    }

    @Override
    public void toSource(SourcePrinter printer) {
        printer.printIndent();
        printer.print(this.getName());
        printer.print(" : ");
        printer.print(this.getType());
    }

    static enum Property implements IPropertyInformation<EventPropertyElement>
    {
        NAME(Messages.EventPropertyElement_Name){

            public Object getPropertyValue(EventPropertyElement node) {
                return node.getName();
            }
        }
        ,
        TYPE(Messages.EventPropertyElement_Type){

            public Object getPropertyValue(EventPropertyElement node) {
                return node.getType();
            }
        }
        ,
        DEPRECATED(Messages.TypeElement_Deprecated){

            public Object getPropertyValue(EventPropertyElement node) {
                return node.isDeprecated();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

