/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.inferencing;

import com.aptana.build.util.AssistHelper;
import com.aptana.core.GetPropertor;
import com.aptana.core.IFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.JSTypeConstants;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.inferencing.JSAssistSymbolTypeInferrer;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.FunctionTypeElement;
import com.aptana.editor.js.contentassist.model.ParameterElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.ReturnTypeElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.contentassist.model.ValueElement;
import com.aptana.editor.js.convertor.ConvertorContext;
import com.aptana.editor.js.convertor.DOMTypeConvertor;
import com.aptana.editor.js.convertor.JQueryTypeConvertor;
import com.aptana.editor.js.inferencing.ITypeConvertor;
import com.aptana.editor.js.inferencing.JSNodeTypeInferrer;
import com.aptana.editor.js.inferencing.JSObjectPropertiesCollector;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.inferencing.JSSimpleNodeTypeInferrer;
import com.aptana.editor.js.inferencing.JSSymbolTypeInferrer;
import com.aptana.editor.js.inferencing.JSTypeMapper;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSArrowFunctionNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSClassNode;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSEmptyNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetElementNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSGroupNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSNumberNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSReturnNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.editor.js.parsing.ast.JSWithNode;
import com.aptana.editor.js.sdoc.model.ClassType;
import com.aptana.editor.js.sdoc.model.DocumentationBlock;
import com.aptana.editor.js.sdoc.model.ExtendsTag;
import com.aptana.editor.js.sdoc.model.FunctionType;
import com.aptana.editor.js.sdoc.model.ParamTag;
import com.aptana.editor.js.sdoc.model.Tag;
import com.aptana.editor.js.sdoc.model.TagType;
import com.aptana.editor.js.sdoc.model.Type;
import com.aptana.editor.js.sdoc.parsing.SDocParser;
import com.aptana.editor.js.utils.DOMAssistUtils;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class JSAssistNodeTypeInferrer
extends JSNodeTypeInferrer<TypeElement> {
    protected boolean _writeType;
    protected List<TypeElement> _typeElements = new ArrayList<TypeElement>(5);
    protected AbstractThemeableEditor _targetEditor = null;
    protected static JSNode _currentNode = null;
    private static List<ITypeConvertor> convertors = new ArrayList<ITypeConvertor>();
    private ConvertorContext context = null;
    private String contextType = null;

    static {
        convertors.add(new DOMTypeConvertor());
        convertors.add(new JQueryTypeConvertor());
    }

    public JSAssistNodeTypeInferrer(JSScope scope, Index projectIndex, URI location) {
        super(scope, projectIndex, location, new JSIndexQueryHelper());
    }

    public JSAssistNodeTypeInferrer(JSScope scope, Index projectIndex, URI location, JSNode currentNode) {
        this(scope, projectIndex, location);
        _currentNode = currentNode;
    }

    public JSAssistNodeTypeInferrer(JSScope scope, Index projectIndex, URI location, JSIndexQueryHelper queryHelper) {
        super(scope, projectIndex, location, queryHelper);
        this.context = new ConvertorContext(this.getEditor(), this._location, this._index);
    }

    public boolean isWriteType() {
        return this._writeType;
    }

    public void setWriteType(boolean writeType) {
        this._writeType = writeType;
    }

    @Override
    protected void addParameterTypes(JSIdentifierNode paramNode) {
        IParseNode grandparent;
        IParseNode parent = paramNode.getParent();
        IParseNode iParseNode = grandparent = parent != null ? parent.getParent() : null;
        if (grandparent == null || grandparent.getNodeType() != 70) {
            return;
        }
        DocumentationBlock docs = ((JSNode)grandparent).getDocumentation();
        if (docs != null) {
            String name = paramNode.getText();
            int index = paramNode.getIndex();
            List<Tag> params = docs.getTags(TagType.PARAM);
            if (params != null && params.size() > index) {
                for (Tag pTag : params) {
                    ParamTag param = (ParamTag)pTag;
                    if (!name.equals(param.getName())) continue;
                    for (Type parameterType : param.getTypes()) {
                        String type = parameterType.getName();
                        type = JSTypeMapper.getInstance().getMappedType(type);
                        this.addType(type);
                    }
                }
            }
        } else {
            JSFunctionNode fNode = (JSFunctionNode)grandparent;
            if (fNode.getName() != null && !(fNode.getName() instanceof JSEmptyNode)) {
                String funcName = fNode.getName().getText();
                JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)fNode, fNode.getStart());
                JSPropertyCollection property = scope.getSymbol(funcName);
                if (property != null && !property.getCalls().isEmpty()) {
                    List<TypeElement> types = ParseUtil.getCallExpressTypes(property.getCalls(), scope, this);
                    for (TypeElement type : types) {
                        if (type instanceof FunctionTypeElement) {
                            FunctionTypeElement funcType = (FunctionTypeElement)type;
                            FunctionElement fElement = funcType.toFunction();
                            List<ParameterElement> params = fElement.getParameters();
                            if (!CollectionsUtil.isNotEmpty(params) || paramNode.getIndex() >= params.size()) continue;
                            ParameterElement pElement = params.get(paramNode.getIndex());
                            this.addTypes(pElement.getTypes());
                            continue;
                        }
                        this.addParameterType(paramNode.getIndex(), type.getName());
                    }
                }
                return;
            }
            IParseNode grandGrandParent = fNode.getParent();
            if (grandGrandParent != null) {
                switch (grandGrandParent.getNodeType()) {
                    case 63: {
                        JSDeclarationNode declarNode = (JSDeclarationNode)grandGrandParent;
                        List<TypeElement> declarationTypes = ParseUtil.getDeclarationType(declarNode, this._index, this._location);
                        for (TypeElement type : declarationTypes) {
                            this.addParameterType(paramNode.getIndex(), type.getName());
                        }
                        break;
                    }
                    case 1: {
                        JSAssignmentNode assginNode = (JSAssignmentNode)grandGrandParent;
                        if (this._scope.getParentScope() == null) break;
                        List<TypeElement> types = this.getTypes(assginNode.getLeftHandSide(), this._scope.getParentScope());
                        for (TypeElement type : types) {
                            this.addParameterType(paramNode.getIndex(), type.getName());
                        }
                        break;
                    }
                    case 62: {
                        JSInvokeNode iNode = (JSInvokeNode)grandGrandParent;
                        int pIndex = paramNode.getIndex();
                        if (iNode.getParent() instanceof JSGroupNode && iNode.getArguments() != null && iNode.getArguments().getChildCount() > pIndex) {
                            IParseNode node = iNode.getArguments().getChild(pIndex);
                            this.addTypes(node);
                        }
                        break;
                    }
                    case 61: {
                        JSArgumentsNode arguNodes = (JSArgumentsNode)grandGrandParent;
                        if (!(arguNodes.getParent() instanceof JSInvokeNode)) break;
                        JSInvokeNode ivkNode = (JSInvokeNode)arguNodes.getParent();
                        if (this._scope.getParentScope() == null) break;
                        List<TypeElement> types = this.getTypes(ivkNode.getExpression(), this._scope.getParentScope());
                        for (TypeElement type : types) {
                            FunctionTypeElement funcType;
                            FunctionElement func;
                            if (!(type instanceof FunctionTypeElement) || (func = (funcType = (FunctionTypeElement)type).toFunction()) == null) continue;
                            int paramIndex = grandparent.getIndex();
                            List<ParameterElement> params = func.getParameters();
                            if (params.size() <= paramIndex) continue;
                            ParameterElement param = func.getParameters().get(paramIndex);
                            List<String> typeNames = param.getTypes();
                            for (String typeName : typeNames) {
                                this.addParameterType(paramNode.getIndex(), typeName);
                            }
                        }
                        break;
                    }
                    case 76: {
                        JSNameValuePairNode namePairNode = (JSNameValuePairNode)grandGrandParent;
                        Map<String, List<ValueElement>> typeValues = ParseUtil.infererCurrentNodeType(namePairNode.getValue(), namePairNode.getValue().getStartingOffset(), new ArrayList<String>(), this._index, this._location);
                        if (!CollectionsUtil.isNotEmpty(typeValues)) break;
                        for (String typeName : typeValues.keySet()) {
                            this.addParameterType(paramNode.getIndex(), typeName);
                        }
                        break;
                    }
                }
            }
        }
    }

    protected List<Type> addParameterType(int paramIndex, String typeName) {
        List<Type> resultTypes = Collections.emptyList();
        if (StringUtil.isEmpty((String)typeName)) {
            return resultTypes;
        }
        try {
            SDocParser parser = new SDocParser();
            resultTypes = parser.parseType(typeName);
            if (!CollectionsUtil.isEmpty(resultTypes)) {
                for (Type resultType : resultTypes) {
                    FunctionType functionType;
                    Type paramType;
                    if (!(resultType instanceof FunctionType) || (paramType = (functionType = (FunctionType)resultType).getParameterType(paramIndex)) == null) continue;
                    String typeEl = JSTypeMapper.getInstance().getMappedType(paramType.getName());
                    this.addType(typeEl);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultTypes;
    }

    @Override
    protected void addType(TypeElement type) {
        AssistHelper.checkState();
        if (type == null) {
            return;
        }
        if (!this._typeElements.contains(type)) {
            this._typeElements.add(type);
            if (!this._writeType) {
                this.addParentTypes(type);
            }
        }
    }

    protected void addParentTypes(TypeElement typeElement) {
        JSScope localScope = this._scope;
        String type = typeElement.getName();
        if (localScope == null || StringUtil.isEmpty((String)type)) {
            return;
        }
        String[] pkgs = type.split("\\.");
        String firstPkg = pkgs[0];
        if (StringUtil.isEmpty((String)firstPkg)) {
            return;
        }
        JSPropertyCollection symbolTable = localScope.getSymbol(firstPkg);
        int i = 1;
        while (i < pkgs.length) {
            if (symbolTable == null || !symbolTable.hasProperty(pkgs[i])) break;
            symbolTable = symbolTable.getProperty(pkgs[i]);
            ++i;
        }
        if (symbolTable != null) {
            JSAssistSymbolTypeInferrer symbolTypeInferrer = (JSAssistSymbolTypeInferrer)this.createSymbolTypeInferrer(localScope, this._index, this._location);
            symbolTypeInferrer.setWriteSubType(false);
            symbolTypeInferrer.getSymbolPropertyElement(symbolTable, "prototype");
            List<TypeElement> types = symbolTypeInferrer.getTypeElements();
            for (TypeElement typeEl : types) {
                this.addType(typeEl);
                typeElement.addParentType(typeEl);
            }
        }
    }

    @Override
    protected void addType(String type) {
        if (StringUtil.isNotEmpty((String)type)) {
            type = JSTypeUtil.validateTypeName(type);
            this.addType(JSTypeUtil.createEmptyType(type));
        }
    }

    @Override
    protected void addTypes(IParseNode node) {
        if (node instanceof JSNode) {
            ((JSNode)node).accept(this);
        }
    }

    @Override
    protected void addTypes(List<String> types) {
        if (types != null) {
            for (String type : types) {
                this.addType(type);
            }
        }
    }

    protected void addTypeElements(List<TypeElement> typeElements) {
        if (CollectionsUtil.isEmpty(typeElements)) {
            return;
        }
        for (TypeElement typeElement : typeElements) {
            this.addType(typeElement);
        }
    }

    @Override
    public List<TypeElement> getTypes() {
        return CollectionsUtil.getListValue(this._typeElements);
    }

    @Override
    public List<TypeElement> getTypes(IParseNode node) {
        return this.getTypes(node, this._scope);
    }

    @Override
    public List<String> getTypeNames(IParseNode node) {
        ArrayList<String> types = new ArrayList<String>(2);
        List<TypeElement> typeElements = this.getTypes(node);
        if (typeElements != null && !typeElements.isEmpty()) {
            for (TypeElement typeElement : typeElements) {
                if (!StringUtil.isNotEmpty((String)typeElement.getName())) continue;
                types.add(typeElement.getName());
            }
        }
        return types;
    }

    @Override
    public List<TypeElement> getTypes(IParseNode node, JSScope scope) {
        if (node instanceof JSNode) {
            JSAssistNodeTypeInferrer walker = (JSAssistNodeTypeInferrer)this.createNodeTypeInferrer(scope, this._index, this._location, this._queryHelper);
            walker.setWriteType(this._writeType);
            walker.setContextType(this.contextType);
            walker.visit((JSNode)node);
            return walker.getTypes();
        }
        return Collections.emptyList();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visit(JSConstructNode node) {
        AssistHelper.checkState();
        child = node.getExpression();
        if (child instanceof JSIdentifierNode) {
            name = child.getText();
            queueTypes = new LinkedList<String>();
            visitedTypes = new HashSet<String>();
            queueTypes.add(name);
            while (!queueTypes.isEmpty()) {
                typeName = (String)queueTypes.poll();
                if (visitedTypes.contains(typeName)) continue;
                visitedTypes.add(typeName);
                type = new TypeElement();
                type.setName(typeName);
                symbolTypeInferre = this.createSymbolTypeInferrer(this._scope, this._index, this._location);
                props = symbolTypeInferre.getSymbolProperty(this._scope.getObject(), typeName);
                if (props != null) {
                    for (JSNode value : CollectionsUtil.getListValue(props.getValues())) {
                        if (value instanceof JSFunctionNode) {
                            funcNode = (JSFunctionNode)value;
                            funcScope = ParseUtil.getScopeAtOffset(funcNode.getBody(), funcNode.getBody().getStartingOffset());
                            symbolInferrer = this.createSymbolTypeInferrer(funcScope, this._index, this._location);
                            thisProperties = symbolInferrer.getSymbolProperty(funcScope.getObject(), "this");
                            if (thisProperties != null && thisProperties.hasProperties()) {
                                propertyNames = thisProperties.getPropertyNames();
                                for (String propName : propertyNames) {
                                    prop = symbolInferrer.getSymbolPropertyElement(thisProperties, propName);
                                    type.addProperty(prop);
                                }
                            }
                            if (funcNode.getDocumentation() == null || !(block = funcNode.getDocumentation()).hasTag(TagType.EXTENDS)) continue;
                            tags = block.getTags(TagType.EXTENDS);
                            for (Tag tag : tags) {
                                extendsTag = (ExtendsTag)tag;
                                for (Type eType : extendsTag.getTypes()) {
                                    type.addParentType(eType.getName());
                                    queueTypes.add(eType.getName());
                                }
                            }
                            continue;
                        }
                        if (!(value instanceof JSClassNode)) continue;
                        type = symbolTypeInferre.getClassType(props, value);
                    }
                }
                this.addType(type);
            }
        } else if (child instanceof JSGetPropertyNode) {
            typeName = child.toString();
            if (this._scope.hasType(typeName)) {
                props = this._scope.getTypePropertyCollection(typeName);
                typeElement = new TypeElement();
                typeElement.setName(typeName);
                JSTypeUtil.applyPropertyCollection(typeElement, props, this._index, this._location);
                this.addType(typeElement);
            } else {
                typeEls = this.getTypes(child);
                if (!CollectionsUtil.isEmpty(typeEls)) {
                    for (TypeElement typeEl : typeEls) {
                        if (!CollectionsUtil.isEmpty(typeEl.getReturnTypes())) {
                            returnTypes = typeEl.getReturnTypes();
                            for (ReturnTypeElement returnType : returnTypes) {
                                this.addType(returnType.getTypeElement());
                            }
                        } else {
                            try {
                                functionTypes = JSTypeUtil.getFunction(typeEl.getName());
                                if (CollectionsUtil.isEmpty(functionTypes)) ** GOTO lbl84
                                for (Type fType : functionTypes) {
                                    if (fType instanceof FunctionType) {
                                        functionType = (FunctionType)fType;
                                        if (CollectionsUtil.isEmpty(functionType.getReturnTypes())) continue;
                                        returnTypes = functionType.getReturnTypes();
                                        for (Type returnType : returnTypes) {
                                            this.addType(returnType.getName());
                                        }
                                        continue;
                                    }
                                    if (!(fType instanceof ClassType) || (clazzType = (ClassType)fType).getType() == null) continue;
                                    this.addType(clazzType.getType().getName());
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
lbl84:
                        // 4 sources

                        this.addTypeElements(typeEls);
                    }
                } else {
                    this.addType(typeName);
                }
            }
        } else {
            typeElements = this.getTypes(child);
            this.addTypeElements(typeElements);
        }
    }

    @Override
    public void visit(JSThisNode node) {
        AssistHelper.checkState();
        JSFunctionNode funcNode = ParseUtil.getContainerFunction(node);
        if (funcNode != null) {
            IParseNode funcNameNode = funcNode.getName();
            if (funcNameNode == null || funcNameNode instanceof JSEmptyNode) {
                if (funcNode.getParent() instanceof JSNameValuePairNode) {
                    JSNameValuePairNode nameValueNode = (JSNameValuePairNode)funcNode.getParent();
                    if (nameValueNode.getParent() instanceof JSObjectNode) {
                        JSObjectNode objectNode = (JSObjectNode)nameValueNode.getParent();
                        TypeElement emptyType = new TypeElement();
                        JSObjectPropertiesCollector objCollector = new JSObjectPropertiesCollector();
                        objCollector.visit(objectNode);
                        Map<String, JSNode> properties = objCollector.getProperties();
                        for (Map.Entry<String, JSNode> prop : properties.entrySet()) {
                            PropertyElement propEl = null;
                            propEl = prop.getValue() instanceof JSFunctionNode ? new FunctionElement() : new PropertyElement();
                            JSSimpleNodeTypeInferrer simpleInferrer = new JSSimpleNodeTypeInferrer(this._scope, this._index, this._location);
                            List<String> typeNames = simpleInferrer.getTypeNames((IParseNode)prop.getValue());
                            for (String typeName : typeNames) {
                                JSTypeUtil.applySignature(propEl, typeName);
                            }
                            JSTypeUtil.applyDocumentation(propEl, Arrays.asList(prop.getValue()));
                            propEl.setName(prop.getKey());
                            emptyType.addProperty(propEl);
                        }
                        this.addType(emptyType);
                    }
                } else {
                    this.addType("Window");
                }
            } else {
                this.addType(funcNameNode.getText());
            }
        } else if (StringUtil.isNotEmpty((String)this.contextType)) {
            this.addType(this.contextType);
        } else {
            this.addType("Window");
        }
    }

    @Override
    public void visit(JSArrowFunctionNode node) {
        TypeElement typeElement = JSTypeUtil.createEmptyType("Function");
        this.addType(typeElement);
    }

    @Override
    public void visit(JSFunctionNode node) {
        AssistHelper.checkState();
        TypeElement typeElement = JSTypeUtil.createEmptyType("Function");
        this.addType(typeElement);
        JSScope scope = this.getActiveScope(node.getBody().getStartingOffset());
        for (JSReturnNode returnValue : node.getReturnNodes()) {
            List<TypeElement> typeElements;
            IParseNode expression = returnValue.getExpression();
            if (expression.isEmpty() || CollectionsUtil.isEmpty(typeElements = this.getTypes(expression, scope))) continue;
            for (TypeElement typeEl : typeElements) {
                ReturnTypeElement returnType = new ReturnTypeElement();
                returnType.setType(typeEl.getName());
                returnType.setTypeElement(typeEl);
                typeElement.addReturnType(returnType);
            }
        }
    }

    @Override
    public void visit(JSGetElementNode node) {
        AssistHelper.checkState();
        IParseNode lhs = node.getLeftHandSide();
        if (lhs instanceof JSNode) {
            for (TypeElement type : this.getTypes(lhs)) {
                if ("jQuery".equals(type.getName()) || "$".equals(type.getName())) {
                    JSNumberNode numNode;
                    String indexStr;
                    if (!(node.getRightHandSide() instanceof JSNumberNode) || !"0".equals(indexStr = (numNode = (JSNumberNode)node.getRightHandSide()).getText())) continue;
                    this.addType("HTMLElement");
                    continue;
                }
                String typeString = JSTypeUtil.getArrayElementType(type.getName());
                if (typeString != null) {
                    this.addType(typeString);
                    continue;
                }
                this.addType(type);
            }
        }
    }

    @Override
    public void visit(JSGetPropertyNode node) {
        AssistHelper.checkState();
        IParseNode lhs = node.getLeftHandSide();
        if (lhs instanceof JSNode) {
            Collection<PropertyElement> properties;
            IParseNode rhs = node.getRightHandSide();
            String memberName = rhs.getText();
            List<TypeElement> typeElements = this.getTypes(lhs);
            for (ITypeConvertor convertor : convertors) {
                try {
                    List<TypeElement> resultTypes = convertor.convert(this.context, node, typeElements);
                    if (CollectionsUtil.isEmpty(resultTypes)) continue;
                    this.addTypeElements(resultTypes);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
                }
            }
            if (!CollectionsUtil.isEmpty(typeElements)) {
                for (TypeElement typeElement : typeElements) {
                    ArrayList<PropertyElement> properties2 = new ArrayList<PropertyElement>(2);
                    if (typeElement != null) {
                        PropertyElement prop = typeElement.getProperty(memberName);
                        boolean findProperty = false;
                        if (prop != null) {
                            properties2.add(prop);
                            findProperty = true;
                        }
                        if (!findProperty && StringUtil.isNotEmpty((String)typeElement.getName())) {
                            String typeName = typeElement.getName();
                            typeName = JSTypeMapper.getInstance().getMappedType(typeName);
                            if (JSTypeConstants.FUNCTION_JQUERY.equals(typeName) && lhs instanceof JSIdentifierNode && ("$".equals(lhs.getText()) || "jQuery".equals(lhs.getText()))) {
                                typeName = JSTypeConstants.CLASS_JQUERY;
                            }
                            properties2.addAll(this._queryHelper.getTypeMembers(this._index, typeName, memberName));
                        }
                    }
                    this.processProperties(node, memberName, properties2);
                }
            }
            if (CollectionsUtil.isEmpty(this.getTypes()) && !CollectionsUtil.isEmpty(properties = this._queryHelper.getPossibleProperties(this._index, memberName)) && properties.size() <= 10) {
                this.processProperties(node, memberName, properties);
            }
        }
    }

    protected void processProperties(JSGetPropertyNode node, String memberName, Collection<PropertyElement> properties) {
        if (!CollectionsUtil.isEmpty(properties)) {
            for (PropertyElement property : properties) {
                if (property instanceof FunctionElement) {
                    FunctionElement function = (FunctionElement)property;
                    this.addType(new FunctionTypeElement(function));
                    continue;
                }
                List<ReturnTypeElement> types = property.getTypes();
                if (types.isEmpty()) {
                    this.addType(memberName);
                    continue;
                }
                this.addReturnType(types);
            }
        }
    }

    protected void addReturnType(List<ReturnTypeElement> types) {
        if (CollectionsUtil.isEmpty(types)) {
            return;
        }
        for (ReturnTypeElement type : types) {
            if (type.getTypeElement() != null) {
                this.addType(type.getTypeElement());
                continue;
            }
            if (!StringUtil.isNotEmpty((String)type.getType())) continue;
            this.addType(type.getType());
        }
    }

    @Override
    public void visit(JSIdentifierNode node) {
        AssistHelper.checkState();
        String name = node.getText();
        Collection<Object> properties = new ArrayList();
        this.processWithExpress(node);
        if (this._scope != null && this._scope.hasSymbol(name)) {
            IParseNode iParseNode = node.getParent();
            if (iParseNode != null && iParseNode.getNodeType() == 69) {
                this.addParameterTypes(node);
            } else {
                JSAssistSymbolTypeInferrer symbolInferrer = (JSAssistSymbolTypeInferrer)this.createSymbolTypeInferrer(this._scope, this._index, this._location);
                symbolInferrer.setContextType(this.contextType);
                symbolInferrer.setWriteSubType(this._writeType);
                PropertyElement property = symbolInferrer.getSymbolPropertyElement(name);
                if (property == null || CollectionsUtil.isEmpty(property.getTypeNames())) {
                    properties = this._queryHelper.getGlobals(this._index, this.getProject(), this.getFileName(), name);
                } else {
                    properties.add(property);
                }
                List<TypeElement> typeElements = symbolInferrer.getTypeElements();
                this.addTypeElements(typeElements);
            }
        } else if ("window".equals(name)) {
            this.addType("Window");
        } else {
            properties = this._queryHelper.getGlobals(this._index, this.getProject(), this.getFileName(), name);
        }
        if (properties != null) {
            for (PropertyElement propertyElement : properties) {
                if (propertyElement instanceof FunctionElement) {
                    FunctionElement function = (FunctionElement)propertyElement;
                    this.addType(new FunctionTypeElement(function));
                    continue;
                }
                this.addTypes(propertyElement.getTypeNames());
            }
        }
    }

    protected void guessPossibleTypes(final String name, Collection<PropertyElement> properties) {
        if (CollectionsUtil.isEmpty(properties)) {
            final HashSet propertiesNode = new HashSet();
            IParseNode body = (IParseNode)this._scope.getRange();
            com.aptana.parsing.util.ParseUtil.treeApply((IParseNode)body, (IFilter)new IFilter<IParseNode>(){

                public boolean include(IParseNode item) {
                    JSGetPropertyNode getNode;
                    if (item instanceof JSGetPropertyNode && name.equals((getNode = (JSGetPropertyNode)item).getLeftHandSide().toString())) {
                        propertiesNode.add(getNode);
                    }
                    return true;
                }
            }, (boolean)false);
            HashSet<String> memberNames = new HashSet<String>();
            for (JSGetPropertyNode propertyNode : propertiesNode) {
                String rhsText = propertyNode.getRightHandSide().getText();
                if (StringUtil.isEmpty((String)rhsText)) continue;
                memberNames.add(rhsText);
            }
            if (!CollectionsUtil.isEmpty(memberNames)) {
                String firstName = (String)memberNames.iterator().next();
                Collection<PropertyElement> props = this._queryHelper.getPossibleProperties(this._index, firstName);
                HashSet<String> possibleTypes = new HashSet<String>();
                for (PropertyElement prop : props) {
                    possibleTypes.add(prop.getOwningType());
                }
                memberNames.remove(firstName);
                for (String possibleType : possibleTypes) {
                    this.addType(possibleType);
                }
            }
        }
    }

    protected void processWithExpress(JSIdentifierNode node) {
        String name = node.getText();
        Queue<JSWithNode> withNodes = ParseUtil.getContainingWithNodes(node);
        while (!withNodes.isEmpty()) {
            List<TypeElement> typeElements;
            JSWithNode withNode = withNodes.poll();
            if (withNode == null || CollectionsUtil.isEmpty(typeElements = this.getTypes(withNode.getExpression(), ParseUtil.getScopeAtOffset(withNode.getExpression(), withNode.getExpression().getStartingOffset())))) continue;
            for (TypeElement typeElement : typeElements) {
                ArrayList<PropertyElement> props = new ArrayList<PropertyElement>(2);
                if (typeElement != null) {
                    PropertyElement prop = typeElement.getProperty(name);
                    boolean findProperty = false;
                    if (prop != null) {
                        props.add(prop);
                        findProperty = true;
                    }
                    if (!findProperty && StringUtil.isNotEmpty((String)typeElement.getName())) {
                        String typeName = typeElement.getName();
                        typeName = JSTypeMapper.getInstance().getMappedType(typeName);
                        props.addAll(this._queryHelper.getTypeMembers(this._index, typeName, name));
                    }
                }
                this.processProperties(null, name, props);
            }
        }
    }

    @Override
    public void visit(JSInvokeNode node) {
        AssistHelper.checkState();
        IParseNode child = node.getExpression();
        if (child instanceof JSNode) {
            ArrayList<String> types = new ArrayList<String>(2);
            List<TypeElement> typeElements = this.getTypes(child);
            for (ITypeConvertor convertor : convertors) {
                try {
                    List<TypeElement> resultTypes = convertor.convert(this.context, node, typeElements);
                    if (CollectionsUtil.isEmpty(resultTypes)) continue;
                    this.addTypeElements(resultTypes);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
                }
            }
            if (!CollectionsUtil.isEmpty(typeElements)) {
                for (TypeElement typeElement : typeElements) {
                    if (typeElement instanceof FunctionTypeElement) {
                        FunctionTypeElement funcType = (FunctionTypeElement)typeElement;
                        FunctionElement func = funcType.toFunction();
                        if (func == null) continue;
                        types.addAll(func.getReturnTypeNames());
                        continue;
                    }
                    if (!CollectionsUtil.isEmpty(typeElement.getReturnTypes())) {
                        this.addReturnType(typeElement.getReturnTypes());
                        continue;
                    }
                    if (!StringUtil.isNotEmpty((String)typeElement.getName())) continue;
                    try {
                        List<Type> functionTypes = JSTypeUtil.getFunction(typeElement.getName());
                        for (Type functionType : functionTypes) {
                            if (functionType instanceof FunctionType) {
                                FunctionType fType = (FunctionType)functionType;
                                if (!CollectionsUtil.isEmpty(fType.getReturnTypes())) {
                                    for (Type returnType : fType.getReturnTypes()) {
                                        types.add(returnType.getName());
                                    }
                                    continue;
                                }
                                types.add("void");
                                continue;
                            }
                            if (functionType instanceof ClassType) {
                                ClassType clazzType = (ClassType)functionType;
                                if (clazzType.getType() == null) continue;
                                types.add(clazzType.getType().getName());
                                continue;
                            }
                            types.add(functionType.toSource());
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
                    }
                }
                if (types.contains("HTMLElement") || types.contains("Node") || types.contains("NodeList")) {
                    this.addDomTypes(node, types);
                }
                for (String type : types) {
                    this.addType(type);
                }
            } else {
                IParseNode parent = node.getParent();
                if (parent != null) {
                    switch (parent.getNodeType()) {
                        case 1: {
                            if (node.getIndex() != 1) break;
                            this.addType("Object");
                            break;
                        }
                        case 48: {
                            this.addType("Object");
                            break;
                        }
                    }
                }
            }
        }
    }

    protected void addDomTypes(JSInvokeNode ivkNode, List<String> domTypes) {
        if (ivkNode.getExpression() instanceof JSGetPropertyNode) {
            JSGetPropertyNode propsNode = (JSGetPropertyNode)ivkNode.getExpression();
            IParseNode lhs = propsNode.getLeftHandSide();
            ArrayList<String> instanceTypes = new ArrayList<String>(2);
            instanceTypes.addAll(this.getTypeNames(lhs));
            if (instanceTypes != null && !instanceTypes.isEmpty() && (instanceTypes.contains("HTMLDocument") || instanceTypes.contains("Document"))) {
                DOMAssistUtils.inferrerHTMLDomTypes(this.getEditor(), ivkNode, _currentNode, domTypes);
            }
        }
    }

    protected AbstractThemeableEditor getEditor() {
        if (this._targetEditor == null) {
            IWorkbenchPage page;
            IEditorPart editor = null;
            final IWorkbenchWindow[] window = new IWorkbenchWindow[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    window[0] = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                }
            });
            if (window[0] != null && (page = window[0].getActivePage()) != null) {
                editor = page.getActiveEditor();
            }
            if (editor != null && editor instanceof AbstractThemeableEditor) {
                this._targetEditor = (AbstractThemeableEditor)editor;
            }
        }
        return this._targetEditor;
    }

    @Override
    public void visit(JSObjectNode node) {
        AssistHelper.checkState();
        TypeElement typeElement = new TypeElement();
        typeElement.setName("Object");
        JSTypeUtil.applyObjectPropertiesCollection(node, typeElement, this._index, this._location);
        this.addType(typeElement);
    }

    @Override
    public List<TypeElement> getArgumentTypes(JSInvokeNode ivkNode, int index, JSScope scope) {
        ArrayList<TypeElement> results = new ArrayList<TypeElement>();
        List<TypeElement> types = this.getTypes(ivkNode.getExpression(), scope);
        for (TypeElement type : types) {
            FunctionTypeElement fType;
            FunctionElement func;
            if (!(type instanceof FunctionTypeElement) || (func = (fType = (FunctionTypeElement)type).toFunction()).getParameters().size() <= index) continue;
            List<String> paramTypes = func.getParameters().get(index).getTypes();
            results.addAll(JSTypeUtil.createEmptyTypes(paramTypes));
        }
        return results;
    }

    public void setEditor(AbstractThemeableEditor editor) {
        this._targetEditor = editor;
    }

    public JSNode getCurrentNode(JSNode currentNode) {
        return _currentNode;
    }

    public void setCurrentNode(JSNode currentNode) {
        _currentNode = currentNode;
    }

    public void setContextType(String contextType) {
        this.contextType = contextType;
    }

    @Override
    protected JSNodeTypeInferrer<TypeElement> createNodeTypeInferrer(JSScope scope, Index index, URI location, JSIndexQueryHelper queryHelper) {
        return new JSAssistNodeTypeInferrer(scope, index, location, queryHelper);
    }

    @Override
    protected JSSymbolTypeInferrer<TypeElement> createSymbolTypeInferrer(JSScope localScope, Index index, URI location) {
        return new JSAssistSymbolTypeInferrer(localScope, index, location, this._writeType);
    }

    @Override
    public List<String> getTypeNames() {
        List<TypeElement> types = this.getTypes();
        if (CollectionsUtil.isEmpty(types)) {
            return Collections.emptyList();
        }
        Set typeNames = CollectionsUtil.getPropertyList(types, (GetPropertor)new GetPropertor<TypeElement, String>(){

            public String getProperty(TypeElement obj) {
                return obj.getName();
            }
        });
        return new ArrayList<String>(typeNames);
    }

    @Override
    public TypeElement getGenericArrayType(TypeElement type) {
        type.setName(JSTypeUtil.createGenericArrayType(type.getName()));
        return type;
    }

    @Override
    protected TypeElement getGenericType(String typeName) {
        return JSTypeUtil.createEmptyType(typeName);
    }

    @Override
    protected String getTypeName(TypeElement type) {
        if (type == null) {
            return "";
        }
        return type.getName();
    }

    @Override
    public Collection<TypeElement> getFunctionTypes(JSInvokeNode iNode, JSScope scope) {
        ArrayList<TypeElement> results = new ArrayList<TypeElement>();
        FunctionElement funcElement = new FunctionElement();
        funcElement.setName("Function");
        if (iNode.getArguments().hasChildren()) {
            for (IParseNode argNode : iNode.getArguments()) {
                List<String> typeNames = this.getTypeNames(argNode);
                ParameterElement pe = new ParameterElement();
                funcElement.addParameter(pe);
                if (CollectionsUtil.isEmpty(typeNames)) {
                    pe.addType("Object");
                    continue;
                }
                for (String typeName : typeNames) {
                    pe.addType(typeName);
                }
            }
        }
        results.add(new FunctionTypeElement(funcElement));
        return results;
    }
}

