/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.index.inferencing;

import com.aptana.build.util.BuildHelper;
import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.index.inferencing.JSIndexNodeTypeInferrer;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.inferencing.JSNodeTypeInferrer;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.inferencing.JSSymbolTypeInferrer;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.parsing.ast.JSCatchNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.sdoc.model.DocumentationBlock;
import com.aptana.index.core.Index;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class JSIndexSymbolTypeInferrer
extends JSSymbolTypeInferrer<String> {
    private static List<TypeElement> typeElements = null;
    protected boolean isFullBuild = false;

    public JSIndexSymbolTypeInferrer(JSScope activeScope, Index index, URI location) {
        super(activeScope, index, location);
    }

    public boolean isFullBuild() {
        return this.isFullBuild;
    }

    public void setFullBuild(boolean isFullBuild) {
        this.isFullBuild = isFullBuild;
    }

    @Override
    protected PropertyElement createPropertyElement(Set<String> types) {
        if (!CollectionsUtil.isEmpty(types) && types.contains("Function")) {
            return new FunctionElement();
        }
        return new PropertyElement();
    }

    @Override
    public List<PropertyElement> getScopeProperties() {
        List<String> symbolNames = this.activeScope.getLocalSymbolNames();
        symbolNames.remove("window");
        return CollectionsUtil.map(symbolNames, (IMap)new IMap<String, PropertyElement>(){

            public PropertyElement map(String symbol) {
                if (JSIndexSymbolTypeInferrer.this.isFullBuild) {
                    BuildHelper.sleep((String)"JS_SYMBOL_LOOP_TYPE");
                }
                JSIndexSymbolTypeInferrer symbolTypeInferrer = (JSIndexSymbolTypeInferrer)JSIndexSymbolTypeInferrer.this.createSymbolTypeInferrer();
                PropertyElement prop = symbolTypeInferrer.getSymbolPropertyElement(symbol);
                return prop;
            }
        });
    }

    @Override
    public JSPropertyCollection getSymbolProperty(JSPropertyCollection activeObject, String symbol) {
        JSPropertyCollection property = activeObject.getProperty(symbol);
        if (property == null) {
            property = this.activeScope.getSymbol(symbol);
        }
        return property;
    }

    @Override
    protected void useCachedTypes(Set<String> types, JSPropertyCollection property) {
        types.addAll(property.getTypeNames());
    }

    @Override
    protected void cachedTypes(Set<String> types, JSPropertyCollection property) {
        property.clearTypes();
        for (String type : types) {
            property.addType(type);
        }
    }

    @Override
    protected void applySignature(PropertyElement result, Set<String> types) {
        for (String typeName : types) {
            JSTypeUtil.applySignature(result, typeName);
        }
    }

    @Override
    public void processProperties(JSPropertyCollection property, Set<String> types) {
        if (property.hasProperties()) {
            List<String> additionalProperties = this.getAdditionalProperties(property, types);
            if (!additionalProperties.isEmpty()) {
                TypeElement subType = JSIndexSymbolTypeInferrer.generateType(property, types);
                ArrayList<String> returnTypes = new ArrayList<String>();
                for (String type : types) {
                    if (!JSTypeUtil.isFunctionPrefix(type)) continue;
                    returnTypes.addAll(JSTypeUtil.getFunctionSignatureReturnTypeNames(type));
                }
                String propertyType = subType.getName();
                if (!JSTypeUtil.isFunctionPrefix(propertyType) && !returnTypes.isEmpty()) {
                    propertyType = String.valueOf(propertyType) + JSTypeUtil.toFunctionType(returnTypes);
                }
                types.add(propertyType);
                JSIndexSymbolTypeInferrer inferrer = (JSIndexSymbolTypeInferrer)this.createSymbolTypeInferrer();
                for (String pname : additionalProperties) {
                    if ("prototype".equals(pname)) {
                        JSPropertyCollection prototype = inferrer.getSymbolProperty(property, "prototype");
                        if (prototype == null || !prototype.hasProperties()) continue;
                        for (String prototypeName : prototype.getPropertyNames()) {
                            PropertyElement pe = inferrer.getSymbolPropertyElement(prototype, prototypeName);
                            subType.addProperty(pe);
                        }
                        continue;
                    }
                    PropertyElement pe = inferrer.getSymbolPropertyElement(property, pname);
                    if (subType.getProperty(pname) != null) {
                        pe = subType.getProperty(pname);
                        continue;
                    }
                    subType.addProperty(pe);
                }
                this.writeType(subType);
            }
        } else {
            for (String typeName : types) {
                property.addType(typeName);
            }
        }
    }

    @Override
    protected void addExceptionType(JSPropertyCollection property, Set<String> types, JSCatchNode catchNode, JSNodeTypeInferrer<String> inferrer) {
    }

    @Override
    protected void addObjectType(JSPropertyCollection property, Set<String> types, JSNode value, JSNodeTypeInferrer<String> inferrer) {
        super.addObjectType(property, types, value, inferrer);
        types.add(JSTypeUtil.toClassType(property.getName()));
    }

    @Override
    protected void addWindowMemberTypes(JSPropertyCollection property, Set<String> types) {
        if ("window".equals(property.getName())) {
            types.add("Window");
        } else {
            JSIndexQueryHelper helper = new JSIndexQueryHelper();
            Collection<PropertyElement> props = helper.getTypeMembers(this.index, "Window", property.getName());
            if (!CollectionsUtil.isEmpty(props)) {
                for (PropertyElement prop : props) {
                    types.addAll(prop.getTypeNames());
                }
            }
        }
    }

    @Override
    protected JSNodeTypeInferrer<String> createNodeTypeInferrer(JSScope activeScope, Index index, URI location) {
        return new JSIndexNodeTypeInferrer(activeScope, index, location);
    }

    @Override
    protected void processDocumentationBlock(JSPropertyCollection property, Set<String> types, JSNode value, boolean isFunction, DocumentationBlock docs) {
        if (isFunction) {
            FunctionElement f = new FunctionElement();
            JSTypeUtil.applyDocumentation(f, value, docs);
            types.addAll(f.getSignatureTypes());
        } else {
            PropertyElement p = new PropertyElement();
            JSTypeUtil.applyDocumentation(p, value, docs);
            types.addAll(p.getTypeNames());
        }
    }

    public static List<TypeElement> getTypes() {
        if (typeElements == null) {
            return Collections.emptyList();
        }
        return typeElements;
    }

    public static void clearTypes() {
        if (!CollectionsUtil.isEmpty(typeElements)) {
            typeElements.clear();
            typeElements = null;
        }
    }

    @Override
    protected void writeType(TypeElement type) {
        if (type != null) {
            if (typeElements == null) {
                typeElements = new ArrayList<TypeElement>(3);
            }
            typeElements.add(type);
            super.writeType(type);
        }
    }

    @Override
    protected JSSymbolTypeInferrer<String> createSymbolTypeInferrer() {
        return new JSIndexSymbolTypeInferrer(this.activeScope, this.index, this.location);
    }

    @Override
    public String getClassType(JSPropertyCollection property, JSNode value) {
        return property.getName();
    }
}

