/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.index.inferencing;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.JSTypeConstants;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.index.inferencing.JSIndexSymbolTypeInferrer;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.inferencing.JSNodeTypeInferrer;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.inferencing.JSSymbolTypeInferrer;
import com.aptana.editor.js.inferencing.JSTypeMapper;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.parsing.ast.JSArrowFunctionNode;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSEmptyNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetElementNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSGroupNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSReturnNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.editor.js.sdoc.model.DocumentationBlock;
import com.aptana.editor.js.sdoc.model.FunctionType;
import com.aptana.editor.js.sdoc.model.ParamTag;
import com.aptana.editor.js.sdoc.model.Tag;
import com.aptana.editor.js.sdoc.model.TagType;
import com.aptana.editor.js.sdoc.model.Type;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class JSIndexNodeTypeInferrer
extends JSNodeTypeInferrer<String> {
    protected List<String> _types = new ArrayList<String>(5);

    public JSIndexNodeTypeInferrer(JSScope scope, Index projectIndex, URI location) {
        this(scope, projectIndex, location, new JSIndexQueryHelper());
    }

    public JSIndexNodeTypeInferrer(JSScope scope, Index projectIndex, URI location, JSNode currentNode) {
        this(scope, projectIndex, location);
    }

    public JSIndexNodeTypeInferrer(JSScope scope, Index projectIndex, URI location, JSIndexQueryHelper queryHelper) {
        super(scope, projectIndex, location, queryHelper);
    }

    @Override
    protected void addParameterTypes(JSIdentifierNode identifierNode) {
        IParseNode grandparent;
        IParseNode parent = identifierNode.getParent();
        IParseNode iParseNode = grandparent = parent != null ? parent.getParent() : null;
        if (grandparent != null && grandparent.getNodeType() == 70) {
            DocumentationBlock docs = ((JSNode)grandparent).getDocumentation();
            if (docs != null) {
                ParamTag param;
                String name = identifierNode.getText();
                int index = identifierNode.getIndex();
                List<Tag> params = docs.getTags(TagType.PARAM);
                if (params != null && index < params.size() && name.equals((param = (ParamTag)params.get(index)).getName())) {
                    for (Type parameterType : param.getTypes()) {
                        String type = parameterType.getName();
                        type = JSTypeMapper.getInstance().getMappedType(type);
                        this.addType(type);
                    }
                }
            } else {
                IParseNode grandGrandParent = grandparent.getParent();
                if (grandGrandParent != null && grandGrandParent.getNodeType() == 58) {
                    JSGroupNode groupNode = (JSGroupNode)grandGrandParent;
                    this.processClosureArgument(groupNode, identifierNode);
                }
            }
        }
    }

    protected void processClosureArgument(JSGroupNode groupNode, JSIdentifierNode paramNode) {
        if (groupNode == null) {
            return;
        }
        if (groupNode.getParent() instanceof JSInvokeNode) {
            IParseNode targetArgs;
            JSInvokeNode ivkNode = (JSInvokeNode)groupNode.getParent();
            IParseNode parseArgs = ivkNode.getArguments();
            int paramIndex = paramNode.getParent().getChildIndex((IParseNode)paramNode);
            if (parseArgs.getChildCount() > paramIndex && (targetArgs = parseArgs.getChild(paramIndex)) != null) {
                this.addTypes(targetArgs);
            }
        }
    }

    @Override
    protected void addType(String type) {
        if (StringUtil.isNotEmpty((String)type) && !this._types.contains(type)) {
            this._types.add(type);
        }
    }

    @Override
    protected void addTypes(IParseNode node) {
        if (node instanceof JSNode) {
            ((JSNode)node).accept(this);
        }
    }

    @Override
    protected void addTypes(List<String> types) {
        if (!CollectionsUtil.isEmpty(types)) {
            for (String type : types) {
                this.addType(type);
            }
        }
    }

    @Override
    public List<String> getTypes() {
        return this._types;
    }

    @Override
    public List<String> getTypeNames(IParseNode node) {
        return this.getTypeNames(node, this._scope);
    }

    public List<String> getTypeNames(IParseNode node, JSScope scope) {
        if (node instanceof JSNode) {
            JSNodeTypeInferrer<String> walker = this.createNodeTypeInferrer(scope, this._index, this._location, this._queryHelper);
            walker.visit((JSNode)node);
            return walker.getTypes();
        }
        return Collections.emptyList();
    }

    @Override
    public String getGenericArrayType(String type) {
        return JSTypeUtil.createGenericArrayType(type);
    }

    @Override
    public void visit(JSConstructNode node) {
        IParseNode exprNode = node.getExpression();
        switch (exprNode.getNodeType()) {
            case 19: 
            case 48: {
                this.addType(exprNode.getText());
                break;
            }
            default: {
                List<String> typeNames = this.getTypeNames(exprNode);
                for (String typeName : typeNames) {
                    if (typeName.startsWith("Class<")) {
                        this.addType(JSTypeUtil.getClassType(typeName));
                        continue;
                    }
                    if (!typeName.startsWith("Function<")) continue;
                    this.addTypes(JSTypeUtil.getFunctionSignatureReturnTypeNames(typeName));
                }
            }
        }
    }

    @Override
    public void visit(JSThisNode node) {
        JSFunctionNode funcNode = ParseUtil.getContainerFunction(node);
        if (funcNode != null) {
            IParseNode funcNameNode = funcNode.getName();
            if (funcNameNode == null || funcNameNode instanceof JSEmptyNode) {
                this.addType("Window");
            } else {
                this.addType(funcNameNode.getText());
            }
        } else {
            this.addType("Window");
        }
    }

    @Override
    public void visit(JSArrowFunctionNode node) {
        this.addType("Function");
    }

    @Override
    public void visit(JSFunctionNode node) {
        this.addType("Function");
        JSScope scope = this.getActiveScope(node.getBody().getStartingOffset());
        ArrayList<String> returnTypes = new ArrayList<String>();
        for (JSReturnNode returnValue : node.getReturnNodes()) {
            List<String> types;
            IParseNode expression = returnValue.getExpression();
            if (expression.isEmpty() || CollectionsUtil.isEmpty(types = this.getTypeNames(expression, scope))) continue;
            for (String type : types) {
                returnTypes.add(type);
            }
        }
        if (!CollectionsUtil.isEmpty(returnTypes)) {
            this.addType(JSTypeUtil.toFunctionType(returnTypes));
        }
    }

    @Override
    public void visit(JSGetElementNode node) {
        IParseNode lhs = node.getLeftHandSide();
        if (lhs instanceof JSNode) {
            for (String typeName : this.getTypeNames(lhs)) {
                String typeString = JSTypeUtil.getArrayElementType(typeName);
                if (typeString != null) {
                    this.addType(typeString);
                    continue;
                }
                this.addType("Object");
            }
        }
    }

    @Override
    public void visit(JSGetPropertyNode node) {
        IParseNode lhs = node.getLeftHandSide();
        if (lhs instanceof JSNode) {
            IParseNode rhs = node.getRightHandSide();
            String memberName = rhs.getText();
            List<String> types = this.getTypeNames(lhs);
            if (!CollectionsUtil.isEmpty(types)) {
                for (String type : types) {
                    ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>();
                    if (StringUtil.isNotEmpty((String)type)) {
                        String typeName = JSTypeMapper.getInstance().getMappedType(type);
                        if (JSTypeConstants.FUNCTION_JQUERY.equals(typeName) && lhs instanceof JSIdentifierNode && ("$".equals(lhs.getText()) || "jQuery".equals(lhs.getText()))) {
                            typeName = JSTypeConstants.CLASS_JQUERY;
                        }
                        properties.addAll(this._queryHelper.getTypeMembers(this._index, typeName, memberName));
                    }
                    this.processProperties(node, memberName, properties);
                }
            }
        }
    }

    protected void processProperties(JSGetPropertyNode node, String memberName, Collection<PropertyElement> properties) {
        if (!CollectionsUtil.isEmpty(properties)) {
            for (PropertyElement property : properties) {
                if (property instanceof FunctionElement) {
                    FunctionElement function = (FunctionElement)property;
                    if (CollectionsUtil.isEmpty(function.getReturnTypeNames())) {
                        this.addType("Function");
                        continue;
                    }
                    this.addType(JSTypeUtil.toFunctionType(function.getReturnTypeNames()));
                    continue;
                }
                this.addTypes(property.getTypeNames());
            }
        }
    }

    @Override
    public void visit(JSIdentifierNode node) {
        String name = node.getText();
        Collection<PropertyElement> properties = null;
        if (this._scope != null && this._scope.hasSymbol(name)) {
            IParseNode parent = node.getParent();
            if (parent != null && parent.getNodeType() == 69) {
                this.addParameterTypes(node);
            } else {
                JSIndexSymbolTypeInferrer symbolInferrer = (JSIndexSymbolTypeInferrer)this.createSymbolTypeInferrer(this._scope, this._index, this._location);
                PropertyElement property = symbolInferrer.getSymbolPropertyElement(name);
                if (property == null) {
                    properties = this._queryHelper.getGlobals(this._index, this.getProject(), this.getFileName(), name);
                } else {
                    properties = new ArrayList<PropertyElement>();
                    properties.add(property);
                }
            }
        } else if ("window".equals(name)) {
            this.addType("Window");
        } else {
            JSScope localScope = ParseUtil.getScopeAtOffset((IParseNode)node, node.getStartingOffset());
            if (localScope != null && !CollectionsUtil.isEmpty(localScope.getCachedProperty(name))) {
                properties = localScope.getCachedProperty(name);
            } else {
                properties = this._queryHelper.getGlobals(this._index, this.getProject(), this.getFileName(), name);
                if (localScope != null && !CollectionsUtil.isEmpty(properties)) {
                    localScope.addCachedProperty(name, properties);
                }
            }
        }
        if (properties != null) {
            for (PropertyElement property : properties) {
                if (property instanceof FunctionElement) {
                    this.addType("Function");
                    FunctionElement function = (FunctionElement)property;
                    for (String type : function.getSignatureTypes()) {
                        this.addType(type);
                    }
                    continue;
                }
                this.addTypes(property.getTypeNames());
            }
        }
    }

    @Override
    protected String getFileName() {
        return com.aptana.core.util.URIUtil.getFileName((URI)this._location);
    }

    @Override
    protected IProject getProject() {
        URI root = this._index.getRoot();
        IPath containerPath = URIUtil.toPath((URI)root);
        if (containerPath == null) {
            return null;
        }
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(containerPath);
        if (container == null) {
            return null;
        }
        return container.getProject();
    }

    @Override
    public void visit(JSInvokeNode node) {
        IParseNode child = node.getExpression();
        if (child instanceof JSNode) {
            List<String> types = this.getTypeNames(child);
            if (!CollectionsUtil.isEmpty(types)) {
                for (String typeName : types) {
                    try {
                        List<Type> rTypes = JSTypeUtil.getFunction(typeName);
                        for (Type rType : rTypes) {
                            FunctionType funcType;
                            if (!(rType instanceof FunctionType) || CollectionsUtil.isEmpty((funcType = (FunctionType)rType).getReturnTypes())) continue;
                            for (Type rtnType : funcType.getReturnTypes()) {
                                this.addType(rtnType.getName());
                            }
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
                    }
                }
            } else {
                IParseNode parent = node.getParent();
                if (parent != null) {
                    switch (parent.getNodeType()) {
                        case 1: {
                            if (node.getIndex() != 1) break;
                            this.addType("Object");
                            break;
                        }
                        case 48: {
                            this.addType("Object");
                            break;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void visit(JSObjectNode node) {
        this.addType("ObjectLiteral");
    }

    @Override
    public List<String> getArgumentTypes(JSInvokeNode ivkNode, int index, JSScope scope) {
        return Collections.emptyList();
    }

    @Override
    public List<String> getTypeNames() {
        return CollectionsUtil.getListValue(this._types);
    }

    @Override
    public List<String> getTypes(IParseNode node, JSScope scope) {
        if (node instanceof JSNode) {
            JSNodeTypeInferrer<String> walker = this.createNodeTypeInferrer(scope, this._index, this._location, this._queryHelper);
            walker.visit((JSNode)node);
            return walker.getTypes();
        }
        return Collections.emptyList();
    }

    @Override
    protected JSNodeTypeInferrer<String> createNodeTypeInferrer(JSScope scope, Index index, URI location, JSIndexQueryHelper queryHelper) {
        return new JSIndexNodeTypeInferrer(scope, index, location, queryHelper);
    }

    @Override
    protected String getGenericType(String typeName) {
        return typeName;
    }

    @Override
    protected String getTypeName(String type) {
        return type;
    }

    @Override
    protected JSSymbolTypeInferrer<String> createSymbolTypeInferrer(JSScope localScope, Index index, URI location) {
        return new JSIndexSymbolTypeInferrer(localScope, index, location);
    }

    @Override
    public Collection<String> getFunctionTypes(JSInvokeNode iNode, JSScope scope) {
        return Arrays.asList("Function");
    }
}

