/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.index.JSFileIndexingParticipant;
import com.aptana.editor.js.contentassist.index.JSIndexCacher;
import com.aptana.editor.js.contentassist.index.JSMetadataReader;
import com.aptana.editor.js.contentassist.model.AliasElement;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.index.core.AbstractRemoteFileIndexingParticipant;
import com.aptana.index.core.BuildContextType;
import com.aptana.index.core.Index;
import com.pandora.index.service.IndexRequest;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

public class SDocMLFileIndexingParticipant
extends AbstractRemoteFileIndexingParticipant {
    List<TypeElement> typeElementList;

    public boolean isEnableType(BuildContextType contextType) {
        return true;
    }

    public void requestIndex(IndexRequest request, IProgressMonitor monitor) {
        if (request == null) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                PropertyElement property3;
                String typeName;
                JSMetadataReader reader = new JSMetadataReader();
                FileInputStream stream = new FileInputStream(new File(request.getIndexURI()));
                reader.loadXML(stream, request.getIndexURI().toString());
                sub.worked(45);
                String globalTypeName = JSTypeUtil.getDefaultGlobalType();
                TypeElement window = JSTypeUtil.createGlobalType(globalTypeName);
                this.typeElementList = new ArrayList<TypeElement>();
                TypeElement[] types = reader.getTypes();
                AliasElement[] aliases = reader.getAliases();
                Object[] objectArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeElement type = objectArray[n2];
                    typeName = type.getName();
                    if (!typeName.contains(".") && !typeName.startsWith("Class<")) {
                        List<FunctionElement> constructors = type.getConstructors();
                        if (!constructors.isEmpty()) {
                            for (FunctionElement constructor : constructors) {
                                type.removeProperty(constructor);
                                window.addProperty(constructor);
                            }
                            String newName = JSTypeUtil.toFunctionType(typeName);
                            for (PropertyElement property2 : type.getProperties()) {
                                property2.setOwningType(newName);
                            }
                        } else {
                            property3 = window.getProperty(typeName);
                            if (property3 == null) {
                                property3 = new PropertyElement();
                                property3.setName(typeName);
                                property3.addType(typeName);
                                property3.setHasAllUserAgents();
                                property3.setIsInternal(type.isInternal());
                                window.addProperty(property3);
                            }
                        }
                    }
                    this.typeElementList.add(type);
                    ++n2;
                }
                objectArray = aliases;
                n = aliases.length;
                n2 = 0;
                while (n2 < n) {
                    Object alias = objectArray[n2];
                    typeName = ((AliasElement)alias).getType();
                    ArrayList<PropertyElement> aliasProperties = new ArrayList<PropertyElement>();
                    for (PropertyElement property3 : window.getProperties()) {
                        if (!typeName.equals(property3.getName()) || property3 == null) continue;
                        property3 = property3 instanceof FunctionElement ? new FunctionElement((FunctionElement)property3) : new PropertyElement(property3);
                        property3.setName(((AliasElement)alias).getName());
                        aliasProperties.add(property3);
                    }
                    for (PropertyElement property3 : aliasProperties) {
                        window.addProperty(property3);
                    }
                    property3 = new PropertyElement();
                    property3.setName(((AliasElement)alias).getName());
                    property3.addType(JSTypeUtil.toClassType(typeName));
                    window.addProperty(property3);
                    ++n2;
                }
                this.typeElementList.add(window);
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
            }
        }
        finally {
            sub.done();
        }
    }

    public void saveIndex(IndexRequest request, Index index) {
        JSIndexCacher.getInstance().addIndexCache(this.getIndex(request), request.getIndexURI().toString(), this.typeElementList);
        JSIndexCacher.getInstance().flushProposal(this.getIndex(request), request.getIndexURI());
    }

    public void submitIndex(IndexRequest request) {
        JSIndexCacher.getInstance().addIndexCache(this.getIndex(request), request.getIndexURI().toString(), this.typeElementList);
        JSFileIndexingParticipant.submitTypeElements(request, this.typeElementList);
    }
}

