/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.index;

import com.aptana.build.util.BuildHelper;
import com.aptana.core.build.BuildTerminateException;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.TimeLogUtils;
import com.aptana.editor.js.JSMetadataLoader;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.index.JSIndexCacher;
import com.aptana.editor.js.contentassist.index.JSIndexWriter;
import com.aptana.editor.js.contentassist.index.inferencing.JSIndexNodeTypeInferrer;
import com.aptana.editor.js.contentassist.index.inferencing.JSIndexSymbolTypeInferrer;
import com.aptana.editor.js.contentassist.inferencing.JSAssistSymbolTypeInferrer;
import com.aptana.editor.js.contentassist.model.AliasFunctionElement;
import com.aptana.editor.js.contentassist.model.AliasPropertyElement;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.inferencing.JSGetPropertyCollector;
import com.aptana.editor.js.inferencing.JSObjectPropertiesCollector;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.inferencing.JSTypeCollection;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSArrayNode;
import com.aptana.editor.js.parsing.ast.JSClassNode;
import com.aptana.editor.js.parsing.ast.JSCommentNode;
import com.aptana.editor.js.parsing.ast.JSElementsNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSParametersNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.sdoc.model.DocumentationBlock;
import com.aptana.editor.js.sdoc.model.ExtendsTag;
import com.aptana.editor.js.sdoc.model.Tag;
import com.aptana.editor.js.sdoc.model.TagType;
import com.aptana.editor.js.sdoc.model.Type;
import com.aptana.editor.js.sdoc.parsing.SDocParser;
import com.aptana.index.core.AbstractRemoteFileIndexingParticipant;
import com.aptana.index.core.BuildContextType;
import com.aptana.index.core.Index;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.xpath.ParseNodeXPath;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.pandora.core.stats.Stats;
import com.pandora.index.service.ILocalIndexService;
import com.pandora.index.service.IndexRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.jaxen.JaxenException;
import org.jaxen.XPath;

public class JSFileIndexingParticipant
extends AbstractRemoteFileIndexingParticipant {
    private static XPath LAMBDAS_IN_SCOPE;
    private JSIndexWriter indexWriter = new JSIndexWriter();
    private List<TypeElement> typeElementList = new ArrayList<TypeElement>();
    private boolean isNeedReflush = true;
    private static Kryo kryo;

    static {
        try {
            LAMBDAS_IN_SCOPE = new ParseNodeXPath("invoke/group/function|invoke[position() = 1]/function");
        }
        catch (JaxenException e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
        }
        kryo = new Kryo();
        kryo.setClassLoader(JSFileIndexingParticipant.class.getClassLoader());
        kryo.setAutoReset(true);
    }

    public boolean isNeedReflush() {
        return this.isNeedReflush;
    }

    public void setNeedReflush(boolean isNeedReflush) {
        this.isNeedReflush = isNeedReflush;
    }

    protected JSScope getGlobals(IParseNode root, boolean needSleep, boolean init) {
        JSScope result = null;
        if (root instanceof JSParseRootNode) {
            JSParseRootNode rootNode = (JSParseRootNode)root;
            rootNode.setDelay(needSleep);
            result = rootNode.getGlobals();
            if (needSleep) {
                BuildHelper.resetTimeGap();
            }
        }
        if (init && result != null) {
            result.reset();
        }
        return result;
    }

    private List<PropertyElement> processLambdas(Index index, JSScope globals, IParseNode node, URI location) {
        List<PropertyElement> result = Collections.emptyList();
        try {
            List functions;
            Object queryResult;
            Object object = queryResult = LAMBDAS_IN_SCOPE != null ? LAMBDAS_IN_SCOPE.evaluate((Object)node) : null;
            if (queryResult != null && !(functions = (List)queryResult).isEmpty()) {
                result = new ArrayList<PropertyElement>();
                for (JSFunctionNode function : functions) {
                    JSScope scope = globals.getScopeAtOffset(function.getBody().getStartingOffset());
                    result.addAll(this.processWindowAssignments(index, scope, location));
                    result.addAll(this.processSDocs(index, scope, location));
                    result.addAll(this.processLambdasArgs(index, scope, function, location));
                    result.addAll(this.processLambdas(index, globals, function.getBody(), location));
                }
            }
        }
        catch (JaxenException e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
        }
        return result;
    }

    protected Collection<? extends PropertyElement> processSDocs(Index index, JSScope scope, URI location) {
        IRange range = scope.getRange();
        if (range instanceof IParseNode) {
            IParseNode parseNode = (IParseNode)range;
            for (IParseNode child : parseNode) {
                JSNode node;
                DocumentationBlock block;
                if (!(child instanceof JSNode) || (block = (node = (JSNode)child).getDocumentation()) == null) continue;
                block.hasTag(TagType.ALIAS);
                block.hasTag(TagType.CONSTRUCTOR);
            }
        }
        return Collections.emptyList();
    }

    protected Collection<PropertyElement> processLambdasArgs(Index index, JSScope scope, JSFunctionNode function, URI location) {
        if (function == null) {
            return null;
        }
        ArrayList<PropertyElement> results = new ArrayList<PropertyElement>();
        try {
            JSParametersNode paramsNode = (JSParametersNode)function.getParameters();
            JSInvokeNode ivkNode = (JSInvokeNode)function.getParent().getParent();
            JSArgumentsNode argsNode = (JSArgumentsNode)ivkNode.getArguments();
            IParseNode[] iParseNodeArray = paramsNode.getChildren();
            int n = iParseNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNode child = iParseNodeArray[n2];
                int paramIndex = paramsNode.getChildIndex(child);
                String propertyName = child.getText();
                IParseNode argNode = argsNode.getChild(paramIndex);
                if (argNode != null && scope.getParentScope() != null) {
                    JSIndexNodeTypeInferrer typeInferrer = new JSIndexNodeTypeInferrer(scope.getParentScope(), index, location);
                    typeInferrer.visit(argsNode);
                    List<String> types = typeInferrer.getTypes();
                    if (types != null && types.contains("ObjectLiteral")) {
                        types.remove("ObjectLiteral");
                    }
                    JSIndexSymbolTypeInferrer inferrer = new JSIndexSymbolTypeInferrer(scope, index, location);
                    ArrayList<PropertyElement> propertys = new ArrayList<PropertyElement>();
                    JSPropertyCollection propertyCollect = inferrer.getSymbolProperty(scope.getObject(), propertyName);
                    for (String type : types) {
                        propertyCollect.addType(type);
                    }
                    for (String prop : propertyCollect.getPropertyNames()) {
                        PropertyElement propEl = inferrer.getSymbolPropertyElement(propertyCollect, prop);
                        if (propEl == null) continue;
                        propertys.add(propEl);
                    }
                    if (!propertys.isEmpty()) {
                        for (String type : types) {
                            TypeElement typeEl = new TypeElement();
                            typeEl.setName(type);
                            for (PropertyElement prop : propertys) {
                                typeEl.addProperty(prop);
                            }
                            this.writeIndex(index, location, typeEl);
                            this.typeElementList.add(typeEl);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Stats.addExceptionInfo((Throwable)e);
        }
        return results;
    }

    public void processParseResults(IndexRequest request, IParseNode ast, IProgressMonitor monitor) {
        this.checkMetadataIndex(request);
        this.checkProjectIndex(request);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)80);
        URI location = request.getIndexURI();
        TimeLogUtils log = TimeLogUtils.getTimeLog();
        if (this.isNeedReflush()) {
            this.typeElementList.clear();
        }
        if (IdeLog.isTraceEnabled((Plugin)JSPlugin.getDefault(), (String)"com.aptana.editor.js/debug/show_indexing_steps")) {
            String message = MessageFormat.format("Building symbol tables for file ''{0}'' for index ''{1}''", location.toString(), request.toString());
            IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)message, (String)"com.aptana.editor.js/debug/show_indexing_steps");
        }
        JSScope globals = this.getGlobals(ast, request.isNeedSleep(), true);
        log.logTaskCostTime("\u5efa\u7acb\u7d22\u5f15\u7b26\u53f7\u8868", true);
        if (globals != null) {
            block20: {
                try {
                    try {
                        String message;
                        this.processTypeTable(globals, request, location);
                        log.logTaskCostTime("\u5904\u7406\u7d22\u5f15\u7c7b\u578b\u8868", true);
                        this.processClassNode(globals, request, location);
                        TypeElement type = JSTypeUtil.createGlobalType(JSTypeUtil.getDefaultGlobalType());
                        if (IdeLog.isTraceEnabled((Plugin)JSPlugin.getDefault(), (String)"com.aptana.editor.js/debug/show_indexing_steps")) {
                            String message2 = MessageFormat.format("Processing globally declared variables and functions in file ''{0}'' for index ''{1}''", location.toString(), request.toString());
                            IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)message2, (String)"com.aptana.editor.js/debug/show_indexing_steps");
                        }
                        JSIndexSymbolTypeInferrer symbolInferrer = new JSIndexSymbolTypeInferrer(globals, this.getIndex(request), location);
                        symbolInferrer.setFullBuild(request.isNeedSleep());
                        List<PropertyElement> props = symbolInferrer.getScopeProperties();
                        log.logTaskCostTime("\u83b7\u53d6\u5168\u5c40\u5c5e\u6027 ", true);
                        int i = 0;
                        for (PropertyElement property : props) {
                            i = this.sleep(request, i);
                            this.processAliasPropertyElement(type, property);
                            type.addProperty(property);
                        }
                        if (IdeLog.isTraceEnabled((Plugin)JSPlugin.getDefault(), (String)"com.aptana.editor.js/debug/show_indexing_steps")) {
                            message = MessageFormat.format("Processing assignments to ''window'' in file ''{0}'' for index ''{1}''", location.toString(), request.toString());
                            IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)message, (String)"com.aptana.editor.js/debug/show_indexing_steps");
                        }
                        i = 0;
                        for (PropertyElement property : this.processWindowAssignments(this.getIndex(request), globals, location)) {
                            i = this.sleep(request, i);
                            this.processAliasPropertyElement(type, property);
                            type.addProperty(property);
                        }
                        log.logTaskCostTime("\u5904\u7406Window\u8d4b\u503c", true);
                        if (IdeLog.isTraceEnabled((Plugin)JSPlugin.getDefault(), (String)"com.aptana.editor.js/debug/show_indexing_steps")) {
                            message = MessageFormat.format("Processing assignments to ''window'' within self-invoking function literals in file ''{0}'' for index ''{1}''", location.toString(), request.toString());
                            IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)message, (String)"com.aptana.editor.js/debug/show_indexing_steps");
                        }
                        i = 0;
                        for (PropertyElement property : this.processLambdas(this.getIndex(request), globals, ast, location)) {
                            i = this.sleep(request, i);
                            this.processAliasPropertyElement(type, property);
                            type.addProperty(property);
                        }
                        log.logTaskCostTime("\u5904\u7406\u95ed\u5305", true);
                        this.processWebViewIDString(this.getIndex(request), ast, location);
                        log.logTaskCostTime("\u5904\u7406WebViewID", true);
                        this.processVueComponentDefine(this.getIndex(request), ast, location);
                        if (IdeLog.isTraceEnabled((Plugin)JSPlugin.getDefault(), (String)"com.aptana.editor.js/debug/show_indexing_steps")) {
                            message = MessageFormat.format("Assigning user agents to properties in file ''{0}'' for index ''{1}''", location.toString(), request.toString());
                            IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)message, (String)"com.aptana.editor.js/debug/show_indexing_steps");
                        }
                        String relativizeLocation = null;
                        try {
                            URI projectURI = request.getProjectURI();
                            URI fileURI = request.getIndexURI();
                            relativizeLocation = projectURI.relativize(fileURI).toString();
                        }
                        catch (Exception exception) {}
                        i = 0;
                        for (PropertyElement property : type.getProperties()) {
                            i = this.sleep(request, i);
                            property.setHasAllUserAgents();
                            property.setSource(relativizeLocation);
                        }
                        log.logTaskCostTime("\u8bbe\u7f6e\u6d4f\u89c8\u5668\u517c\u5bb9\u6027", true);
                        if (IdeLog.isTraceEnabled((Plugin)JSPlugin.getDefault(), (String)"com.aptana.editor.js/debug/show_indexing_steps")) {
                            String message3 = MessageFormat.format("Writing indexing results to index ''{0}'' for file ''{1}''", request.toString(), location.toString());
                            IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)message3, (String)"com.aptana.editor.js/debug/show_indexing_steps");
                        }
                        this.writeIndex(this.getIndex(request), location, type);
                        log.logTaskCostTime("\u5199\u5165\u7d22\u5f15", true);
                        this.typeElementList.add(type);
                        this.typeElementList.addAll(JSIndexSymbolTypeInferrer.getTypes());
                        JSIndexSymbolTypeInferrer.clearTypes();
                    }
                    catch (BuildTerminateException buildTerminateException) {
                        this.processNonrecognitionType(this.getIndex(request), location, ast, request.isNeedSleep());
                        log.logTaskCostTime("\u8ba1\u7b97\u5168\u63d0\u793a", true);
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    this.processNonrecognitionType(this.getIndex(request), location, ast, request.isNeedSleep());
                    log.logTaskCostTime("\u8ba1\u7b97\u5168\u63d0\u793a", true);
                    throw throwable;
                }
                this.processNonrecognitionType(this.getIndex(request), location, ast, request.isNeedSleep());
                log.logTaskCostTime("\u8ba1\u7b97\u5168\u63d0\u793a", true);
            }
            if (this.isNeedReflush()) {
                this.flushJSIndexCacher(this.getIndex(request), location, request.isNeedSleep());
            }
            log.logTaskCostTime("\u5237\u65b0\u5185\u5b58\u4e2d\u7684\u8bed\u6cd5\u5e93", true);
        }
        sub.done();
    }

    private void processClassNode(JSScope globals, IndexRequest request, URI location) {
        JSAssistSymbolTypeInferrer symbolInferrer = new JSAssistSymbolTypeInferrer(globals, this.getIndex(request), location, false);
        for (String localName : globals.getLocalSymbolNames()) {
            JSPropertyCollection property = globals.getLocalSymbol(localName);
            for (JSNode value : property.getValues()) {
                if (!(value instanceof JSClassNode)) continue;
                this.typeElementList.add(symbolInferrer.getClassType(property, value));
            }
        }
    }

    protected void checkProjectIndex(IndexRequest request) {
        if (!JSIndexCacher.getInstance().getCacher().containsKey(request.getProjectURI().toString()) && !request.isHBuilder()) {
            try {
                ILocalIndexService local = JSFileIndexingParticipant.getLocalIndexService();
                byte[] contents = local.loadJavaScriptIndex(request.getProjectURI());
                if (contents != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(contents);
                    Input input = new Input((InputStream)bais);
                    Object obj = kryo.readClassAndObject(input);
                    if (obj instanceof Map) {
                        Map map = (Map)obj;
                        JSIndexCacher.getInstance().getCacher().put(request.getProjectURI().toString(), map);
                    }
                    input.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void checkMetadataIndex(IndexRequest request) {
        if (!JSIndexCacher.getInstance().isExistCache("metadata:/js")) {
            if (!request.isHBuilder()) {
                try {
                    URI key = URI.create("metadata:/js");
                    ILocalIndexService local = JSFileIndexingParticipant.getLocalIndexService();
                    byte[] contents = local.loadJavaScriptIndex(key);
                    if (contents != null) {
                        ByteArrayInputStream bais = new ByteArrayInputStream(contents);
                        Input input = new Input((InputStream)bais);
                        Object obj = kryo.readClassAndObject(input);
                        if (obj instanceof Map) {
                            Map map = (Map)obj;
                            JSIndexCacher.getInstance().getCacher().put(key.toString(), map);
                        }
                        input.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                JSPlugin.getDefault().waitingForJavascriptMetadata();
            }
        }
    }

    private void processVueComponentDefine(Index index, IParseNode ast, URI location) {
        ArrayList<JSInvokeNode> invocations = new ArrayList<JSInvokeNode>();
        this.findInvokeNode(ast, invocations, CollectionsUtil.newSet((Object[])new String[]{"Vue.component"}));
        HashSet<String> components = new HashSet<String>();
        for (JSInvokeNode ivkNode : invocations) {
            IParseNode args = ivkNode.getArguments();
            if (args.isEmpty() || !(args.getFirstChild() instanceof JSStringNode)) continue;
            JSStringNode compStr = (JSStringNode)args.getFirstChild();
            components.add(compStr.getString());
        }
        String value = StringUtil.join((String)",", components);
        this.addIndex("js.vue.component", value);
    }

    private void processWebViewIDString(Index index, IParseNode ast, URI location) {
        ArrayList<JSInvokeNode> invocations = new ArrayList<JSInvokeNode>();
        this.findInvokeNode(ast, invocations, CollectionsUtil.newSet((Object[])new String[]{"plus.webview.create", "plus.webview.open", "mui.openWindow", "mui.preload", "$.openWindow", "$.preload", "mui.init", "$.init"}));
        HashSet<String> ids = new HashSet<String>();
        for (JSInvokeNode ivkNode : invocations) {
            IParseNode idNode;
            JSNode jsnode;
            IParseNode args = ivkNode.getArguments();
            if (args.isEmpty()) continue;
            if (args.getChild(0) instanceof JSObjectNode) {
                String exprString = ivkNode.getExpression().toString();
                if ("mui.init".equals(exprString) || "$.init".equals(exprString)) {
                    JSObjectPropertiesCollector objColl = new JSObjectPropertiesCollector();
                    objColl.visit((JSNode)args.getChild(0));
                    Map<String, JSNode> props = objColl.getProperties();
                    JSNode pageNodes = props.get("subpages");
                    JSNode valueNode = ParseUtil.getEqualsExpressNode((IParseNode)pageNodes);
                    if (valueNode == null || !(valueNode instanceof JSArrayNode)) continue;
                    JSArrayNode arrNode = (JSArrayNode)valueNode;
                    Iterator iterator = arrNode.iterator();
                    while (iterator.hasNext()) {
                        IParseNode elements = (IParseNode)iterator.next();
                        if (!(elements instanceof JSElementsNode)) continue;
                        for (IParseNode child : elements) {
                            if (!(child instanceof JSObjectNode)) continue;
                            this.processWebviewOptions(ids, (JSObjectNode)child);
                        }
                    }
                    continue;
                }
                this.processWebviewOptions(ids, (JSObjectNode)args.getChild(0));
                continue;
            }
            if (args.getChildCount() <= 1 || !((jsnode = ParseUtil.getEqualsExpressNode(idNode = args.getChild(1))) instanceof JSStringNode)) continue;
            JSStringNode idString = (JSStringNode)jsnode;
            ids.add(idString.getString());
        }
        String value = StringUtil.join((String)",", ids);
        this.addIndex("js.webview.id", value);
    }

    protected void processWebviewOptions(Collection<String> ids, JSObjectNode options) {
        JSObjectPropertiesCollector objCollector = new JSObjectPropertiesCollector();
        objCollector.visit(options);
        Map<String, JSNode> optionProperties = objCollector.getProperties();
        JSNode idNode = optionProperties.get("id");
        if (idNode != null) {
            JSNode valueNode = ParseUtil.getEqualsExpressNode((IParseNode)idNode);
            if (valueNode instanceof JSStringNode) {
                JSStringNode idString = (JSStringNode)valueNode;
                ids.add(idString.getString());
            }
        } else {
            JSNode valueNode;
            JSNode urlNode = optionProperties.get("url");
            if (urlNode != null && (valueNode = ParseUtil.getEqualsExpressNode((IParseNode)urlNode)) instanceof JSStringNode) {
                JSStringNode idString = (JSStringNode)valueNode;
                ids.add(idString.getString());
            }
        }
    }

    protected void processTypeTable(JSScope scope, IndexRequest request, URI location) {
        JSTypeCollection typeTable = scope.getTypes();
        if (typeTable != null) {
            for (String typeName : typeTable.getTypeNames()) {
                JSIndexSymbolTypeInferrer symbolInferrer = new JSIndexSymbolTypeInferrer(scope, this.getIndex(request), location);
                TypeElement type = JSTypeUtil.createEmptyType(typeName);
                JSPropertyCollection property = typeTable.getPropertyCollection(typeName);
                if (property != null && property.hasProperties()) {
                    JSPropertyCollection typeProp;
                    for (String propName : property.getPropertyNames()) {
                        PropertyElement prop = symbolInferrer.getSymbolPropertyElement(property, propName);
                        if (prop == null) continue;
                        type.addProperty(prop);
                    }
                    if ("this".equals(property.getName()) && (typeProp = scope.getLocalSymbol(typeName)) != null && typeProp.hasProperty("prototype")) {
                        JSPropertyCollection props = typeProp.getProperty("prototype");
                        for (String propName : props.getPropertyNames()) {
                            PropertyElement prop = symbolInferrer.getSymbolPropertyElement(props, propName);
                            if (prop == null) continue;
                            type.addProperty(prop);
                        }
                    }
                }
                if (property == null || !typeName.equals(property.getName())) {
                    JSPropertyCollection typeProperty = scope.getLocalSymbol(typeName);
                    if (typeProperty != null) {
                        this.processFuncTypeValues(type, typeProperty);
                    }
                    if (typeProperty != null && typeProperty.hasProperties()) {
                        JSIndexNodeTypeInferrer typeInferrer = new JSIndexNodeTypeInferrer(scope, this.getIndex(request), location);
                        this.processFuncTypeProperties(type, typeProperty, symbolInferrer, typeInferrer);
                    }
                }
                this.typeElementList.add(type);
            }
        }
    }

    protected void processFuncTypeProperties(TypeElement type, JSPropertyCollection typeProperty, JSIndexSymbolTypeInferrer symbolInferrer, JSIndexNodeTypeInferrer typeInferrer) {
        for (String staticPropName : typeProperty.getPropertyNames()) {
            JSPropertyCollection staticProperty = typeProperty.getProperty(staticPropName);
            if (staticProperty == null) continue;
            for (JSNode value : staticProperty.getValues()) {
                if ("prototype".equals(staticPropName)) {
                    List<String> propTypeNames = typeInferrer.getTypeNames((IParseNode)value);
                    if (!CollectionsUtil.isNotEmpty(propTypeNames)) continue;
                    for (String parentTypeName : propTypeNames) {
                        type.addParentType(parentTypeName);
                    }
                    continue;
                }
                PropertyElement prop = symbolInferrer.getSymbolPropertyElement(typeProperty, staticPropName);
                if (prop == null) continue;
                prop.setIsClassProperty(true);
                type.addProperty(prop);
            }
        }
    }

    protected void processFuncTypeValues(TypeElement type, JSPropertyCollection typeProperty) {
        for (JSNode value : typeProperty.getValues()) {
            DocumentationBlock block = value.getDocumentation();
            if (block == null || !block.hasTag(TagType.EXTENDS)) continue;
            List<Tag> tags = block.getTags(TagType.EXTENDS);
            for (Tag tag : tags) {
                ExtendsTag extendsTag = (ExtendsTag)tag;
                for (Type eType : extendsTag.getTypes()) {
                    type.addParentType(eType.getName());
                }
            }
        }
    }

    protected void processAliasPropertyElement(TypeElement type, PropertyElement property) {
        if (property instanceof AliasPropertyElement) {
            AliasPropertyElement aliasProperty = (AliasPropertyElement)property;
            PropertyElement alias = new PropertyElement(aliasProperty);
            alias.setName(aliasProperty.getAliasName());
            type.addProperty(alias);
        } else if (property instanceof AliasFunctionElement) {
            AliasFunctionElement aliasFunction = (AliasFunctionElement)property;
            FunctionElement alias = new FunctionElement(aliasFunction);
            alias.setName(aliasFunction.getAliasName());
            type.addProperty(alias);
        }
    }

    private int sleep(IndexRequest request, int i) {
        boolean isFullBuild = request.isNeedSleep();
        return this.sleep(i, isFullBuild);
    }

    private int sleep(int i, boolean isFullBuild) {
        if (isFullBuild) {
            BuildHelper.sleepLoop((String)"JS_INDEX_TYPE", (int)(++i));
        }
        return i;
    }

    private void writeIndex(Index index, URI location, TypeElement type) {
        if (this.isNeedReflush()) {
            this.indexWriter.writeType(index, type, location);
        }
    }

    public void flushJSIndexCacher(Index index, URI location, boolean isFullBuild) {
        if (CollectionsUtil.isEmpty(this.typeElementList)) {
            return;
        }
        HashMap<String, TypeElement> map = new HashMap<String, TypeElement>();
        String key = "";
        int i = 0;
        for (TypeElement typeElement : this.typeElementList) {
            if (typeElement == null) continue;
            i = this.sleep(i, isFullBuild);
            key = typeElement.getName();
            if (!map.containsKey(key)) {
                map.put(key, typeElement);
                continue;
            }
            TypeElement te = (TypeElement)map.get(key);
            List<PropertyElement> propertyElements = typeElement.getProperties();
            for (PropertyElement propertyElement : propertyElements) {
                if (propertyElement == null) continue;
                te.addProperty(propertyElement);
            }
        }
        Collection col = map.values();
        this.typeElementList = Arrays.asList(col.toArray(new TypeElement[col.size()]));
    }

    private void processNonrecognitionType(Index index, URI location, IParseNode ast, boolean isFullBuild) {
        if (!(ast instanceof JSParseRootNode)) {
            return;
        }
        String relativeLocation = null;
        try {
            relativeLocation = index.getRoot().relativize(location).toString();
        }
        catch (Exception exception) {
            relativeLocation = location.toString();
        }
        TypeElement type = JSTypeUtil.createEmptyType(relativeLocation);
        type.setIsInternal(true);
        JSParseRootNode root = (JSParseRootNode)ast;
        JSGetPropertyCollector collector = new JSGetPropertyCollector();
        root.accept(collector);
        List<PropertyElement> properties = collector.getProperties();
        HashSet<PropertyElement> propertyElementSet = new HashSet<PropertyElement>();
        propertyElementSet.addAll(properties);
        type.setAllPropertys(new ArrayList<PropertyElement>(propertyElementSet));
        for (PropertyElement property : properties) {
            property.setSource(relativeLocation);
        }
        this.writeIndex(index, location, type);
        this.typeElementList.add(type);
    }

    private void findInvokeNode(IParseNode ast, List<JSInvokeNode> invocations, Set<String> expresses) {
        JSInvokeNode ivkNode;
        IParseNode childast;
        if (ast instanceof JSInvokeNode && (childast = (ivkNode = (JSInvokeNode)ast).getExpression()) != null && expresses.contains(childast.toString())) {
            invocations.add((JSInvokeNode)ast);
        }
        IParseNode[] iParseNodeArray = ast.getChildren();
        int n = iParseNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode childnode = iParseNodeArray[n2];
            this.findInvokeNode(childnode, invocations, expresses);
            ++n2;
        }
    }

    protected void processRequires(Index index, IParseNode ast, URI location) {
        ArrayList<JSInvokeNode> invocations = new ArrayList<JSInvokeNode>();
        this.findInvokeNode(ast, invocations, CollectionsUtil.newSet((Object[])new String[]{"require", "seajs.use"}));
        HashSet<String> paths = new HashSet<String>();
        for (JSInvokeNode invocation : invocations) {
            String text;
            IParseNode arguments = invocation.getArguments();
            IParseNode firstArgument = arguments != null ? arguments.getFirstChild() : null;
            String string = text = firstArgument instanceof JSStringNode ? firstArgument.getText() : null;
            if (text == null || text.length() < 2) continue;
            paths.add(text.substring(1, text.length() - 1));
        }
        if (!paths.isEmpty()) {
            this.indexWriter.writeRequires(index, paths, location);
        }
    }

    protected void processModule(BuildContext context, Index index, IParseNode ast, URI location) {
        JSScope globals = this.getGlobals(ast, context.isNeedSleep(), false);
        if (globals == null) {
            return;
        }
        String moduleId = this.getModuleId(context, index, ast, location);
        TypeElement moduleType = new TypeElement();
        moduleType.setHasAllUserAgents();
        moduleType.setName(moduleId);
        TypeElement moduleExportsType = new TypeElement();
        moduleExportsType.setHasAllUserAgents();
        moduleExportsType.setName(String.valueOf(moduleType.getName()) + ".exports");
        JSPropertyCollection module = globals.getSymbol("module");
        if (module != null) {
            JSIndexSymbolTypeInferrer infer = new JSIndexSymbolTypeInferrer(globals, index, location);
            PropertyElement exports = infer.getSymbolPropertyElement(module, "exports");
            moduleType.addProperty(exports);
            for (String type : exports.getTypeNames()) {
                if (type.startsWith("Array<")) {
                    type = "Array";
                }
                moduleExportsType.addParentType(type);
            }
        } else {
            JSPropertyCollection exports = globals.getSymbol("exports");
            if (exports == null) {
                return;
            }
            JSIndexSymbolTypeInferrer infer = new JSIndexSymbolTypeInferrer(globals, index, location);
            List<String> properties = exports.getPropertyNames();
            for (String property : properties) {
                PropertyElement propElement = infer.getSymbolPropertyElement(exports, property);
                moduleExportsType.addProperty(propElement);
            }
        }
        PropertyElement idElement = new PropertyElement();
        idElement.setIsInstanceProperty(true);
        idElement.setHasAllUserAgents();
        idElement.setName("id");
        idElement.addType("String");
        idElement.setDescription(moduleId);
        moduleExportsType.addProperty(idElement);
        PropertyElement uriElement = new PropertyElement();
        uriElement.setIsInstanceProperty(true);
        uriElement.setHasAllUserAgents();
        uriElement.setName("uri");
        uriElement.addType("String");
        uriElement.setDescription(location.toString());
        moduleExportsType.addProperty(uriElement);
        this.writeIndex(index, location, moduleExportsType);
        this.typeElementList.add(moduleExportsType);
        this.writeIndex(index, location, moduleType);
        this.typeElementList.add(moduleType);
    }

    private String getModuleId(BuildContext context, Index index, IParseNode ast, URI location) {
        IParseRootNode root = (IParseRootNode)ast;
        Object[] comments = root.getCommentNodes();
        if (!ArrayUtil.isEmpty((Object[])comments)) {
            Object[] objectArray = comments;
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                JSCommentNode commentNode;
                Object comment = objectArray[n2];
                if (comment instanceof JSCommentNode && (commentNode = (JSCommentNode)((Object)comment)).getNodeType() == 90) {
                    SDocParser parser = new SDocParser();
                    try {
                        String source = context.getContents().substring(commentNode.getStart(), commentNode.getEnd() + 1);
                        DocumentationBlock result = (DocumentationBlock)((Object)parser.parse(source));
                        List<Tag> moduleTags = result.getTags(TagType.MODULE);
                        if (!CollectionsUtil.isEmpty(moduleTags)) {
                            return moduleTags.get(0).getText();
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        URI relativeToRoot = index.getRelativeDocumentPath(location);
        return Path.fromPortableString((String)relativeToRoot.getPath()).removeFileExtension().toPortableString();
    }

    private Collection<PropertyElement> processWindowAssignments(Index index, JSScope symbols, URI location) {
        List<String> typeNames;
        JSIndexSymbolTypeInferrer symbolInferrer;
        PropertyElement property;
        Collection<PropertyElement> result = Collections.emptyList();
        if (symbols != null && symbols.hasLocalSymbol("window") && (property = (symbolInferrer = new JSIndexSymbolTypeInferrer(symbols, index, location)).getSymbolPropertyElement(symbols.getObject(), "window")) != null && (typeNames = property.getTypeNames()) != null && !typeNames.isEmpty()) {
            JSIndexQueryHelper queryHelper = new JSIndexQueryHelper();
            result = queryHelper.getTypeMembers(index, typeNames, location);
        }
        return result;
    }

    public void removeIndex(Index index, String string) {
        JSIndexCacher.getInstance().removeCache(index, string);
    }

    public boolean isEnableType(BuildContextType contextType) {
        return contextType == BuildContextType.JS || contextType == BuildContextType.ALL;
    }

    public void requestIndex(IndexRequest request, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                sub.subTask(this.getIndexingMessage(request.getProjectURI(), request.getIndexURI()));
                TimeLogUtils log = TimeLogUtils.getTimeLog();
                IParseRootNode rootNode = this.getAST(new JSParseState(request.readContents()), "com.aptana.contenttype.js");
                log.logTaskCostTime("===============\u5efa\u7acb\u8bed\u6cd5\u6811", true);
                this.processParseResults(request, (IParseNode)rootNode, (IProgressMonitor)sub.newChild(20));
            }
            catch (CoreException coreException) {
                sub.done();
            }
        }
        finally {
            sub.done();
        }
    }

    private boolean isExistCache() {
        if (!this.indexWriter.getJSIndexCacher().isExistCache("metadata:/js")) {
            JSMetadataLoader job = new JSMetadataLoader();
            if (!job.existsSameJobs()) {
                job.setAutoLoad(false);
                job.schedule();
            }
            return false;
        }
        return true;
    }

    public void saveIndex(IndexRequest request, Index index) {
        super.saveIndex(request, index);
        JSIndexCacher.getInstance().addIndexCache(index, request.getIndexURI().toString(), this.typeElementList);
        JSIndexCacher.getInstance().flushProposal(index, request.getIndexURI());
    }

    public void submitIndex(IndexRequest request) {
        super.submitIndex(request);
        JSIndexCacher.getInstance().addIndexCache(this.getIndex(request), request.getIndexURI().toString(), this.typeElementList);
        JSFileIndexingParticipant.submitTypeElements(request, this.typeElementList);
    }

    public static void submitTypeElements(IndexRequest request, List<TypeElement> typeElementList) {
        try {
            ILocalIndexService local = JSFileIndexingParticipant.getLocalIndexService();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Output out = new Output((OutputStream)baos);
            kryo.writeClassAndObject(out, new ArrayList<TypeElement>(typeElementList));
            out.close();
            local.submitJavaScript(request, baos.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

