/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ObjectPool;
import com.aptana.editor.js.JSPlugin;
import com.aptana.json.IContextHandler;
import com.aptana.json.Schema;
import com.aptana.json.SchemaBuilder;
import com.aptana.json.SchemaContext;
import com.aptana.json.SchemaHandler;
import com.aptana.json.SchemaReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class JSCAReader
extends SchemaReader {
    private static SchemaPool SCHEMA_POOL;

    protected static synchronized SchemaPool getSchemaPool() {
        if (SCHEMA_POOL == null) {
            SCHEMA_POOL = new SchemaPool();
        }
        return SCHEMA_POOL;
    }

    public void read(Reader input, SchemaContext context) {
        SchemaPool schemaPool = JSCAReader.getSchemaPool();
        Schema schema = (Schema)schemaPool.checkOut();
        this.setSchema(schema);
        super.read(input, context);
        schemaPool.checkIn(schema);
    }

    private static class SchemaPool
    extends ObjectPool<Schema> {
        private static final String JSCA_METADATA_SCHEMA = "/metadata/JSMetadataSchema.json";

        SchemaPool() {
            super(-1);
        }

        public Schema create() {
            Schema result;
            block14: {
                InputStreamReader isr = null;
                result = null;
                try {
                    try {
                        Bundle bundle = JSPlugin.getDefault().getBundle();
                        Path path = new Path(JSCA_METADATA_SCHEMA);
                        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
                        InputStream is = url.openStream();
                        isr = new InputStreamReader(is);
                        SchemaContext context = new SchemaContext();
                        SchemaHandler handler = new SchemaHandler();
                        context.setHandler((IContextHandler)handler);
                        SchemaBuilder reader = new SchemaBuilder();
                        reader.read((Reader)isr, context);
                        result = handler.getSchema();
                    }
                    catch (Throwable t) {
                        IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)t);
                        if (isr != null) {
                            try {
                                isr.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return result;
        }

        public void expire(Schema o) {
        }

        public boolean validate(Schema o) {
            return o != null;
        }
    }
}

