/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import java.util.Iterator;

public class JSRangeFinder
extends JSTreeWalker {
    private int _offset;
    private IRange _range;

    public JSRangeFinder(int offset) {
        this._offset = offset - 1;
        this._range = new Range(offset, offset - 1);
    }

    public IRange getRange() {
        return this._range;
    }

    public void setRange(int startingOffset, int endingOffset) {
        this._range = new Range(startingOffset, endingOffset);
    }

    public void setRange(IParseNode node) {
        if (node instanceof JSNode) {
            ((JSNode)node).accept(this);
        }
    }

    @Override
    public void visit(JSIdentifierNode node) {
        if (node.contains(this._offset)) {
            this.setRange(node.getStart(), node.getEnd());
        }
    }

    @Override
    public void visit(JSNameValuePairNode node) {
        if (node.contains(this._offset)) {
            IParseNode name = node.getName();
            IParseNode value = node.getValue();
            if (name.contains(this._offset) || name.getEndingOffset() == this._offset) {
                this.setRange(name);
            } else if (value.contains(this._offset)) {
                this.setRange(value);
            }
        }
    }

    @Override
    public void visit(JSParseRootNode node) {
        if (node.contains(this._offset)) {
            Iterator iterator = node.iterator();
            while (iterator.hasNext()) {
                IParseNode child = (IParseNode)iterator.next();
                if (!child.contains(this._offset)) continue;
                this.setRange(child);
                break;
            }
        }
    }

    @Override
    public void visit(JSStringNode node) {
        if (node.contains(this._offset)) {
            this.setRange(node.getStart() + 1, this._offset - 1);
        }
    }

    @Override
    protected void visitChildren(JSNode node) {
        if (node.contains(this._offset)) {
            Iterator iterator = node.iterator();
            while (iterator.hasNext()) {
                IParseNode child = (IParseNode)iterator.next();
                if (!child.contains(this._offset)) continue;
                this.setRange(child);
                break;
            }
        }
    }
}

