/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.hover.TagStripperAndTypeBolder;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.Messages;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.ParameterElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.SinceElement;
import com.aptana.editor.js.contentassist.model.UserAgentElement;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;

public class JSModelFormatter {
    private static final String COLON_SPACE = ": ";
    private static final String COMMA_SPACE = ", ";
    private static final String HTML_NEWLINE = "<br>";
    private static final Map<String, Image> TYPE_IMAGE_MAP;
    private static final Map<String, Image> ASSISTANT_IMAGE_MAP;
    private static final Image PROPERTY;
    private static final Image ASSISTANT_PROPERTY;
    private static final String PROTOTYPE_PROPERTY = ".prototype";
    private static final ImageDescriptor STATIC_OVERLAY;
    private static final ImageDescriptor DEPRECATED_OVERLAY;
    public static final JSModelFormatter LABEL;
    public static final JSModelFormatter ADDITIONAL_INFO;
    public static final JSModelFormatter TEXT_HOVER;
    public static final JSModelFormatter LOCATION_HOVER;
    public static final JSModelFormatter DYNAMIC_HELP;
    public static final JSModelFormatter CONTEXT_INFO;
    private List<Section> fSections;
    private boolean useHTML;

    static {
        PROPERTY = JSPlugin.getImage("/icons/js_property.png");
        ASSISTANT_PROPERTY = JSPlugin.getImage("/icons/assistant/js_property.png");
        STATIC_OVERLAY = JSPlugin.getImageDescriptor("icons/overlays/static.png");
        DEPRECATED_OVERLAY = JSPlugin.getImageDescriptor("icons/overlays/deprecated.gif");
        TYPE_IMAGE_MAP = new HashMap<String, Image>();
        TYPE_IMAGE_MAP.put("Array", JSPlugin.getImage("/icons/array-literal.png"));
        TYPE_IMAGE_MAP.put("Boolean", JSPlugin.getImage("/icons/boolean.png"));
        TYPE_IMAGE_MAP.put("Function", JSPlugin.getImage("/icons/js_function.png"));
        TYPE_IMAGE_MAP.put("null", JSPlugin.getImage("/icons/null.png"));
        TYPE_IMAGE_MAP.put("Number", JSPlugin.getImage("/icons/number.png"));
        TYPE_IMAGE_MAP.put("Object", JSPlugin.getImage("/icons/object-literal.png"));
        TYPE_IMAGE_MAP.put("RegExp", JSPlugin.getImage("/icons/regex.png"));
        TYPE_IMAGE_MAP.put("String", JSPlugin.getImage("/icons/string.png"));
        ASSISTANT_IMAGE_MAP = new HashMap<String, Image>();
        ASSISTANT_IMAGE_MAP.put("Array", JSPlugin.getImage("/icons/assistant/array-literal.png"));
        ASSISTANT_IMAGE_MAP.put("Boolean", JSPlugin.getImage("/icons/assistant/boolean.png"));
        ASSISTANT_IMAGE_MAP.put("Function", JSPlugin.getImage("/icons/assistant/js_function.png"));
        ASSISTANT_IMAGE_MAP.put("null", JSPlugin.getImage("/icons/assistant/null.png"));
        ASSISTANT_IMAGE_MAP.put("Number", JSPlugin.getImage("/icons/assistant/number.png"));
        ASSISTANT_IMAGE_MAP.put("Object", JSPlugin.getImage("/icons/assistant/object-literal.png"));
        ASSISTANT_IMAGE_MAP.put("RegExp", JSPlugin.getImage("/icons/assistant/regex.png"));
        ASSISTANT_IMAGE_MAP.put("String", JSPlugin.getImage("/icons/assistant/string.png"));
        LABEL = new JSModelFormatter(false, Section.SIGNATURE);
        ADDITIONAL_INFO = new JSModelFormatter(true, Section.SIGNATURE, Section.DESCRIPTION, Section.EXAMPLE);
        TEXT_HOVER = new JSModelFormatter(true, Section.SPECIFICATIONS, Section.SIGNATURE, Section.DESCRIPTION, Section.EXAMPLE);
        LOCATION_HOVER = new JSModelFormatter(true, Section.LOCATIONS);
        DYNAMIC_HELP = new JSModelFormatter(true, Section.DESCRIPTION, Section.PARAMETERS, Section.RETURNS, Section.EXAMPLES, Section.PLATFORMS, Section.SPECIFICATIONS);
        CONTEXT_INFO = new JSModelFormatter(false, new Section[]{Section.SIGNATURE}){
            private static final String BULLET = "\u2022";
            private TagStripperAndTypeBolder stripAndBold = new TagStripperAndTypeBolder();

            @Override
            public String getDocumentation(Collection<PropertyElement> properties) {
                if (CollectionsUtil.isEmpty(properties)) {
                    return null;
                }
                PropertyElement prop = properties.iterator().next();
                if (prop instanceof FunctionElement) {
                    FunctionElement function = (FunctionElement)prop;
                    ArrayList<String> result = new ArrayList<String>();
                    result.add(this.getHeader(function, null));
                    ArrayList buffer = new ArrayList();
                    for (ParameterElement parameter : function.getParameters()) {
                        buffer.clear();
                        CollectionsUtil.addToList(buffer, (Object[])new String[]{" ", BULLET, "\t", parameter.getName()});
                        String description = parameter.getDescription();
                        if (!StringUtil.isEmpty((String)description)) {
                            description = this.stripAndBold.searchAndReplace(description);
                            CollectionsUtil.addToList(buffer, (Object[])new String[]{":", FileUtil.NEW_LINE, " \t", description});
                        }
                        result.add(StringUtil.concat(buffer));
                    }
                    return StringUtil.join((String)(String.valueOf(FileUtil.NEW_LINE) + "\ufeff"), result);
                }
                return null;
            }
        };
    }

    private JSModelFormatter(boolean useHTML, Section ... sectionsToDisplay) {
        this.fSections = Arrays.asList(sectionsToDisplay);
        this.useHTML = useHTML;
        for (Section s : this.fSections) {
            s.useHTML = useHTML;
        }
    }

    public String getDescription(PropertyElement property, URI projectURI) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getHeader(property, projectURI));
        String docs = this.getDocumentation(property);
        if (!StringUtil.isEmpty((String)docs)) {
            buffer.append(this.newline());
            buffer.append(docs);
        }
        return buffer.toString();
    }

    public String getHeader(PropertyElement property, URI root) {
        return this.getHeader(CollectionsUtil.newList((Object[])new PropertyElement[]{property}), root);
    }

    public String getHeader(final Collection<PropertyElement> properties, URI root) {
        String headers;
        int index;
        if (CollectionsUtil.isEmpty(properties)) {
            return "";
        }
        ArrayList<String> stringParts = new ArrayList<String>();
        if (this.useHTML) {
            stringParts.add("<b>");
        }
        List headerSections = CollectionsUtil.filter(this.fSections, (IFilter)new IFilter<Section>(){

            public boolean include(Section item) {
                return item.isHeader();
            }
        });
        stringParts.addAll(CollectionsUtil.map((Collection)headerSections, (IMap)new IMap<Section, String>(){

            public String map(Section s) {
                return s.generate(properties, null);
            }
        }));
        if (this.useHTML) {
            stringParts.add("</b>");
        }
        if ((index = (headers = StringUtil.concat(stringParts)).indexOf("-")) == 3) {
            headers = headers.replaceFirst("-", "");
        }
        return headers;
    }

    public String getDocumentation(PropertyElement property) {
        return this.getDocumentation(CollectionsUtil.newList((Object[])new PropertyElement[]{property}));
    }

    public String getDocumentation(final Collection<PropertyElement> properties) {
        List docSections = CollectionsUtil.filter(this.fSections, (IFilter)new IFilter<Section>(){

            public boolean include(Section s) {
                return !s.isHeader();
            }
        });
        List sectionStrings = CollectionsUtil.map((Collection)docSections, (IMap)new IMap<Section, String>(){

            public String map(Section s) {
                return s.generate(properties, null);
            }
        });
        return StringUtil.concat((Collection)sectionStrings);
    }

    public Image getImage(PropertyElement property) {
        String key = "property";
        Image result = PROPERTY;
        if (property instanceof FunctionElement) {
            key = "function";
            result = TYPE_IMAGE_MAP.get("Function");
        }
        if (property != null) {
            List<String> types = property.getTypeNames();
            if (types != null && types.size() == 1) {
                String type = types.get(0);
                if (TYPE_IMAGE_MAP.containsKey(type)) {
                    result = TYPE_IMAGE_MAP.get(type);
                    key = type;
                } else if (type.startsWith("-dynamic-type-")) {
                    result = TYPE_IMAGE_MAP.get("Object");
                    key = "object";
                } else if (type.startsWith("Function")) {
                    result = TYPE_IMAGE_MAP.get("Function");
                    key = "function";
                } else if (type.endsWith("[]")) {
                    result = TYPE_IMAGE_MAP.get("Array");
                    key = "array";
                }
            }
            if (property.isClassProperty()) {
                key = String.valueOf(key) + ".static";
                result = this.addOverlay(result, STATIC_OVERLAY, 1, key);
            }
            if (property.isDeprecated()) {
                key = String.valueOf(key) + ".deprecated";
                result = this.addOverlay(result, DEPRECATED_OVERLAY, 0, key);
            }
        }
        return result;
    }

    public Image getAssistanTImage(PropertyElement property) {
        String key = "property";
        Image result = ASSISTANT_PROPERTY;
        if (property instanceof FunctionElement) {
            key = "function";
            result = ASSISTANT_IMAGE_MAP.get("Function");
        }
        if (property != null) {
            List<String> types = property.getTypeNames();
            if (types != null && types.size() == 1) {
                String type = types.get(0);
                if (ASSISTANT_IMAGE_MAP.containsKey(type)) {
                    result = ASSISTANT_IMAGE_MAP.get(type);
                    key = type;
                } else if (type.startsWith("-dynamic-type-")) {
                    result = ASSISTANT_IMAGE_MAP.get("Object");
                    key = "object";
                } else if (type.startsWith("Function")) {
                    result = ASSISTANT_IMAGE_MAP.get("Function");
                    key = "function";
                } else if (type.endsWith("[]")) {
                    result = ASSISTANT_IMAGE_MAP.get("Array");
                    key = "array";
                }
            }
            if (property.isClassProperty()) {
                key = String.valueOf(key) + ".static";
                result = this.addOverlay(result, STATIC_OVERLAY, 1, key);
            }
            if (property.isDeprecated()) {
                key = String.valueOf(key) + ".deprecated";
                result = this.addOverlay(result, DEPRECATED_OVERLAY, 0, key);
            }
        }
        return result;
    }

    private Image addOverlay(Image base, ImageDescriptor overlay, int location, String key) {
        ImageRegistry reg = this.getImageRegistry();
        Image cached = reg.get(key);
        if (cached != null) {
            return cached;
        }
        DecorationOverlayIcon decorator = new DecorationOverlayIcon(base, overlay, location);
        Image result = decorator.createImage();
        try {
            reg.put(key, result);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    protected ImageRegistry getImageRegistry() {
        return JSPlugin.getDefault().getImageRegistry();
    }

    public static String getTypeDisplayName(String type) {
        String result = null;
        if (type != null) {
            result = type.startsWith("Class<") && type.endsWith(">") ? type.substring("Class<".length(), type.length() - 1) : (type.startsWith("-dynamic-type-") ? "UserType" : (type.startsWith("Function<") && type.endsWith(">") ? type.substring("Function<".length(), type.length() - 1) : (type.endsWith(PROTOTYPE_PROPERTY) ? type.substring(0, type.length() - PROTOTYPE_PROPERTY.length()) : type)));
        }
        return result;
    }

    protected String newline() {
        return this.useHTML ? HTML_NEWLINE : FileUtil.NEW_LINE;
    }

    /* synthetic */ JSModelFormatter(boolean bl, Section[] sectionArray, JSModelFormatter jSModelFormatter) {
        this(bl, sectionArray);
    }

    private static abstract class Section {
        protected boolean useHTML;
        static final Section SIGNATURE = new Section(){

            @Override
            public boolean isHeader() {
                return true;
            }

            @Override
            public String generate(Collection<PropertyElement> properties, URI root) {
                PropertyElement prop = properties.iterator().next();
                if (prop == null) {
                    return "";
                }
                ArrayList<String> builder = new ArrayList<String>();
                builder.add("-");
                builder.add(prop.getName());
                List<String> typeNames = prop.getTypeNames();
                if (prop instanceof FunctionElement) {
                    FunctionElement fe = (FunctionElement)prop;
                    builder.add("(");
                    builder.add(this.formatParameters(fe.getParameters()));
                    builder.add(")");
                    typeNames = fe.getReturnTypeNames();
                }
                builder.add(JSModelFormatter.COLON_SPACE);
                builder.add(this.formatTypes(typeNames));
                return StringUtil.concat(builder);
            }

            private String formatParameters(Collection<ParameterElement> parameters) {
                List strings = CollectionsUtil.map(parameters, (IMap)new IMap<ParameterElement, String>(){

                    public String map(ParameterElement item) {
                        StringBuilder b = new StringBuilder();
                        b.append(item.getName());
                        List<String> types = item.getTypes();
                        if (!CollectionsUtil.isEmpty(types)) {
                            b.append(JSModelFormatter.COLON_SPACE).append(JSModelFormatter.getTypeDisplayName(types.get(0)));
                        }
                        return b.toString();
                    }
                });
                return StringUtil.join((String)JSModelFormatter.COMMA_SPACE, (Collection)strings);
            }
        };
        static final Section LOCATIONS = new Section(){

            @Override
            public String generate(Collection<PropertyElement> properties, URI root) {
                LinkedHashSet<String> documents = new LinkedHashSet<String>();
                for (PropertyElement pe : properties) {
                    documents.addAll(pe.getDocuments());
                }
                if (!documents.isEmpty()) {
                    ArrayList<String> parts = new ArrayList<String>(3);
                    String first = (String)documents.iterator().next();
                    if (root != null) {
                        try {
                            first = root.relativize(new URI(first)).getPath();
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                    }
                    parts.add(first);
                    if (documents.size() > 1) {
                        parts.add(", ...");
                    }
                    return StringUtil.concat(parts);
                }
                return "";
            }
        };
        static final Section EXAMPLE = new Section(){

            @Override
            public String generate(Collection<PropertyElement> properties, URI root) {
                String example = this.getFirstExample(properties);
                return this.addSection(Messages.JSTextHover_Example, example);
            }

            private String getFirstExample(Collection<PropertyElement> properties) {
                for (PropertyElement prop : properties) {
                    List<String> examples = prop.getExamples();
                    for (String example : examples) {
                        if (StringUtil.isEmpty((String)example)) continue;
                        return example;
                    }
                }
                return "";
            }
        };
        static final Section EXAMPLES = new Section(){

            @Override
            public String generate(Collection<PropertyElement> properties, URI root) {
                List examples = new ArrayList<String>();
                for (PropertyElement prop : properties) {
                    examples.addAll(prop.getExamples());
                }
                if ((examples = CollectionsUtil.filter(examples, (IFilter)new IFilter<String>(){

                    public boolean include(String item) {
                        return !StringUtil.isEmpty((String)item);
                    }
                })).size() == 1) {
                    return this.addSection(Messages.JSTextHover_Example, (String)examples.get(0));
                }
                ArrayList<String> builder = new ArrayList<String>();
                int i = 0;
                while (i < examples.size()) {
                    builder.add(this.addSection(String.valueOf(Messages.JSTextHover_Example) + " " + (i + 1), (String)examples.get(i)));
                    ++i;
                }
                return StringUtil.concat(builder);
            }
        };
        static final Section SPECIFICATIONS = new Section(){

            @Override
            public boolean isHeader() {
                return true;
            }

            @Override
            public String generate(Collection<PropertyElement> properties, URI root) {
                HashSet<SinceElement> sinceElements = new HashSet<SinceElement>();
                for (PropertyElement property : properties) {
                    sinceElements.addAll(property.getSinceList());
                }
                return this.getSpecificationsString(sinceElements);
            }

            private String getSpecificationsString(Collection<SinceElement> sinceElements) {
                List strings = CollectionsUtil.map(sinceElements, (IMap)new IMap<SinceElement, String>(){

                    public String map(SinceElement item) {
                        StringBuilder b = new StringBuilder();
                        b.append(item.getName());
                        String version = item.getVersion();
                        if (!StringUtil.isEmpty((String)version)) {
                            b.append(" ").append(version);
                        }
                        return b.toString();
                    }
                });
                return StringUtil.join((String)"|", (Collection)strings);
            }
        };
        static final Section DESCRIPTION = new Section(){
            private TagStripperAndTypeBolder stripAndBold = new TagStripperAndTypeBolder();

            @Override
            public String generate(Collection<PropertyElement> properties, URI root) {
                HashSet<String> descriptions = new HashSet<String>();
                for (PropertyElement property : properties) {
                    this.stripAndBold.setUseHTML(this.useHTML);
                    String desc = property.getDescription();
                    if (property.isDeprecated()) {
                        desc = "<b>Deprecated</b><br>" + desc;
                    }
                    if (StringUtil.isEmpty((String)(desc = this.stripAndBold.searchAndReplace(desc)))) continue;
                    descriptions.add(desc);
                }
                if (CollectionsUtil.isEmpty(descriptions)) {
                    return Messages.JSTextHover_NoDescription;
                }
                return StringUtil.join((String)JSModelFormatter.COMMA_SPACE, descriptions);
            }
        };
        static final Section PLATFORMS = new Section(){

            @Override
            public String generate(Collection<PropertyElement> properties, URI root) {
                HashSet<UserAgentElement> userAgents = new HashSet<UserAgentElement>();
                for (PropertyElement property : properties) {
                    userAgents.addAll(property.getUserAgents());
                }
                return this.addSection(Messages.JSTextHover_SupportedPlatforms, this.getPlatforms(userAgents));
            }

            private String getPlatforms(Collection<UserAgentElement> userAgents) {
                List strings = CollectionsUtil.map(userAgents, (IMap)new IMap<UserAgentElement, String>(){

                    public String map(UserAgentElement item) {
                        StringBuilder b = new StringBuilder();
                        b.append(item.getPlatform());
                        String version = item.getVersion();
                        if (!StringUtil.isEmpty((String)version)) {
                            b.append(JSModelFormatter.COLON_SPACE).append(version);
                        }
                        return b.toString();
                    }
                });
                return StringUtil.join((String)JSModelFormatter.COMMA_SPACE, (Collection)strings);
            }
        };
        static final Section RETURNS = new Section(){

            @Override
            public String generate(Collection<PropertyElement> properties, URI root) {
                List<String> returnTypeNames = new ArrayList<String>();
                for (PropertyElement property : properties) {
                    if (!(property instanceof FunctionElement)) continue;
                    FunctionElement function = (FunctionElement)property;
                    returnTypeNames = function.getReturnTypeNames();
                }
                return this.addSection(Messages.JSModelFormatter_Returns, this.formatTypes(returnTypeNames));
            }
        };
        static final Section PARAMETERS = new Section(){

            @Override
            public String generate(Collection<PropertyElement> properties, URI root) {
                List<ParameterElement> parameters = new ArrayList<ParameterElement>();
                for (PropertyElement property : properties) {
                    if (!(property instanceof FunctionElement)) continue;
                    FunctionElement function = (FunctionElement)property;
                    parameters = function.getParameters();
                }
                return this.addSection(Messages.JSModelFormatter_Parameters, this.getLongformParameters(parameters));
            }

            private String getLongformParameters(List<ParameterElement> parameters) {
                List strings = CollectionsUtil.map(parameters, (IMap)new IMap<ParameterElement, String>(){

                    public String map(ParameterElement item) {
                        String desc;
                        ArrayList<String> b = new ArrayList<String>();
                        b.add(item.getName());
                        List<String> types = item.getTypes();
                        if (!CollectionsUtil.isEmpty(types)) {
                            b.add(" (");
                            b.add(JSModelFormatter.getTypeDisplayName(types.get(0)));
                            b.add(")");
                        }
                        if (!StringUtil.isEmpty((String)(desc = item.getDescription()))) {
                            b.add(JSModelFormatter.COLON_SPACE);
                            b.add(desc);
                        }
                        return StringUtil.concat(b);
                    }
                });
                return StringUtil.join((String)JSModelFormatter.COMMA_SPACE, (Collection)strings);
            }
        };

        private Section() {
        }

        public boolean isHeader() {
            return false;
        }

        private String newline() {
            return this.useHTML ? JSModelFormatter.HTML_NEWLINE : FileUtil.NEW_LINE;
        }

        protected String addSection(String title, String value) {
            StringBuilder builder = new StringBuilder();
            if (!StringUtil.isEmpty((String)value)) {
                builder.append(this.newline()).append(this.newline());
                if (this.useHTML) {
                    builder.append("<b>");
                }
                builder.append(title);
                if (this.useHTML) {
                    builder.append("</b>");
                }
                if (Messages.JSTextHover_Example.equals(title)) {
                    value = value.replaceAll("(\n|\r)\\s*", "<br/>");
                }
                builder.append(this.newline());
                builder.append(value.trim());
            }
            return builder.toString();
        }

        public abstract String generate(Collection<PropertyElement> var1, URI var2);

        protected String formatTypes(List<String> typeNames) {
            if (CollectionsUtil.isEmpty(typeNames)) {
                return "none";
            }
            List typeDisplayNames = CollectionsUtil.map(typeNames, (IMap)new IMap<String, String>(){

                public String map(String type) {
                    return JSModelFormatter.getTypeDisplayName(type);
                }
            });
            return StringUtil.join((String)JSModelFormatter.COMMA_SPACE, (Collection)typeDisplayNames);
        }
    }
}

