/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.sdoc.model2.SDocDocument;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;

public class SDocMetadataLoader
extends Job {
    private static final String SDOC_METADATA_FILE = "/metadata/jsdoc3.json";
    private static SDocDocument document = null;

    public SDocMetadataLoader(String name) {
        super(name);
    }

    protected IStatus run(IProgressMonitor monitor) {
        SDocMetadataLoader.loadSDocMetadata();
        return Status.OK_STATUS;
    }

    protected static void loadSDocMetadata() {
        URL url = null;
        try {
            Bundle bundle = JSPlugin.getDefault().getBundle();
            url = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path(SDOC_METADATA_FILE), null));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (url != null) {
            try {
                Gson gson = new Gson();
                String json = FileUtils.readFileToString((File)new File(url.toURI()));
                document = (SDocDocument)gson.fromJson(json, SDocDocument.class);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    public static SDocDocument getSDocDocument() {
        if (document == null) {
            SDocMetadataLoader.loadSDocMetadata();
        }
        return document;
    }
}

