/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.index.JSIndexCacher;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;

public class PandoraDeleteParticipant
extends DeleteParticipant {
    private static IFile mFile;
    private static IFolder mFolder;
    private static IProject mProject;
    private static boolean isProject;
    private static boolean isFile;
    private JSIndexCacher jsCacher = JSIndexCacher.getInstance();
    private IndexManager indexManager = IndexPlugin.getDefault().getIndexManager();

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            mFile = (IFile)element;
            isProject = false;
            isFile = true;
        }
        if (element instanceof IFolder) {
            mFolder = (IFolder)element;
            isProject = false;
            isFile = false;
        }
        if (element instanceof IProject) {
            mProject = (IProject)element;
            isProject = true;
            isFile = false;
        }
        return true;
    }

    public String getName() {
        return "PandoraDeleteParticipant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            if (isProject) {
                Index index = this.indexManager.getIndex(mProject.getLocationURI());
                this.jsCacher.removeProjectCache(index);
                this.indexManager.removeIndex(mProject.getLocationURI());
            } else if (isFile) {
                this.removeFileCache(mFile);
            } else {
                List<IFile> files = this.getFile(mFolder);
                for (IFile file : files) {
                    this.removeFileCache(file);
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"\u5220\u9664\u8d44\u6e90\u65f6\uff0c\u5220\u9664\u7d22\u5f15\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        CompositeChange result = new CompositeChange(this.getName());
        return result;
    }

    private void removeFileCache(IFile file) {
        String fileUri = file.getLocationURI().toString();
        Index index = this.indexManager.getIndex(file.getProject().getLocationURI());
        this.jsCacher.removeCache(index, fileUri);
    }

    private List<IFile> getFile(IFolder iFolder) {
        List<IFile> fileList = new ArrayList<IFile>();
        try {
            IFileStore fileStore = EFS.getStore((URI)iFolder.getLocationURI());
            fileList = this.getFiles(fileList, fileStore);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return fileList;
    }

    private List<IFile> getFiles(List<IFile> fileList, IFileStore fileStore) {
        try {
            IFileStore[] fileStores = fileStore.childStores(0, (IProgressMonitor)new NullProgressMonitor());
            if (fileStores != null && fileStores.length > 0) {
                IFileStore[] iFileStoreArray = fileStores;
                int n = fileStores.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileStore file = iFileStoreArray[n2];
                    File _file = file.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                    if (_file.isFile()) {
                        fileList.add(PandoraDeleteParticipant.getIFile(file));
                    } else {
                        this.getFiles(fileList, file);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return fileList;
    }

    private static IFile getIFile(IFileStore fileStore) {
        IPath path = Path.fromOSString((String)fileStore.toURI().getPath());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        return file;
    }
}

