/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.js.JSIndexCacheWriter;
import com.aptana.editor.js.JSMetadataLoader;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.SDocMetadataLoader;
import com.aptana.editor.js.contentassist.index.JSIndexCacher;
import com.aptana.editor.js.contentassist.index.RemoveBuildPathContributorAction;
import com.aptana.index.core.IRemoveBuildPathContributor;
import com.aptana.index.core.IndexPlugin;
import com.pandora.core.auth.IDEExitListener;
import com.pandora.core.utils.IDEExitUtils;
import java.net.URI;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class JSStartup
implements IStartup {
    private static String CONTENT_TYPE_HTML = "com.aptana.contenttype.html";
    private static JSMetadataLoader jsMetadataLoader;
    private static final IPartListener jsPartListener;

    static {
        jsPartListener = new IPartListener(){
            private final Object loadProjectJSCacheLocker = new Object();

            public void partActivated(IWorkbenchPart part) {
                IEditorInput editorInput;
                String partType;
                if (part instanceof AbstractThemeableEditor && ((partType = ((AbstractThemeableEditor)part).getContentType()) != null && CONTENT_TYPE_HTML.equals(partType) || "com.aptana.contenttype.js".equals(partType)) && (editorInput = ((AbstractThemeableEditor)part).getEditorInput()) instanceof IFileEditorInput) {
                    final IFile file = ((IFileEditorInput)editorInput).getFile();
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = loadProjectJSCacheLocker;
                            synchronized (object) {
                                jsMetadataLoader.loadProjectJSCache(file);
                            }
                        }
                    }.start();
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void partClosed(IWorkbenchPart part) {
                try {
                    if (!JSIndexCacher.getInstance().hasProjectProposals()) {
                        return;
                    }
                    if (!(part instanceof AbstractThemeableEditor)) {
                        return;
                    }
                    IEditorReference[] editorReferences = part.getSite().getPage().getEditorReferences();
                    HashSet<String> indexs = new HashSet<String>();
                    IEditorReference[] iEditorReferenceArray = editorReferences;
                    int n = editorReferences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        URI puri;
                        IProject project;
                        IFile file;
                        IEditorInput editorInput;
                        String partType;
                        IEditorReference editorReference = iEditorReferenceArray[n2];
                        IEditorPart eidtorPart = editorReference.getEditor(false);
                        if (eidtorPart instanceof AbstractThemeableEditor && ((partType = ((AbstractThemeableEditor)eidtorPart).getContentType()) != null && CONTENT_TYPE_HTML.equals(partType) || "com.aptana.contenttype.js".equals(partType)) && (editorInput = ((AbstractThemeableEditor)eidtorPart).getEditorInput()) instanceof IFileEditorInput && (file = ((IFileEditorInput)editorInput).getFile()) != null && (project = file.getProject()) != null && (puri = project.getLocationURI()) != null) {
                            indexs.add(puri.toString());
                        }
                        ++n2;
                    }
                    Object object = this.loadProjectJSCacheLocker;
                    synchronized (object) {
                        if (indexs.isEmpty()) {
                            JSIndexCacher.getInstance().removeAllProjectProposals();
                        } else {
                            JSIndexCacher.getInstance().retainProposals(indexs);
                        }
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
    }

    public void earlyStartup() {
        jsMetadataLoader = new JSMetadataLoader();
        if (!jsMetadataLoader.existsSameJobs()) {
            jsMetadataLoader.schedule();
        }
        this.loadSDocMetadata();
        this.addJsPartListener();
        JSIndexCacheWriter jsIndexCacheWriteJob = new JSIndexCacheWriter("");
        jsIndexCacheWriteJob.setSystem(true);
        jsIndexCacheWriteJob.schedule(600000L);
        if (jsIndexCacheWriteJob instanceof IDEExitListener) {
            IDEExitUtils.addIDEExitListener((IDEExitListener)jsIndexCacheWriteJob);
        }
        IndexPlugin.getDefault().getIndexManager().addRemoveBuildPathContributor((IRemoveBuildPathContributor)new RemoveBuildPathContributorAction());
    }

    protected void loadSDocMetadata() {
        try {
            SDocMetadataLoader sdocMetadataLoader = new SDocMetadataLoader("");
            EclipseUtil.setSystemForJob((Job)sdocMetadataLoader);
            sdocMetadataLoader.schedule();
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
        }
    }

    private void addJsPartListener() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IPartService partService = window.getPartService();
                    if (partService != null) {
                        partService.addPartListener(jsPartListener);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {}
    }

    public static void removePartListener() {
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {}
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IPartService partService = window.getPartService();
                if (partService != null) {
                    partService.removePartListener(jsPartListener);
                }
                ++n2;
            }
        }
    }
}

