/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.rules.CommentScanner;
import com.aptana.editor.common.text.rules.EmptyCommentRule;
import com.aptana.editor.common.text.rules.ExtendedToken;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.ResumableSingleLineRule;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.js.JSCodeScanner;
import com.aptana.editor.js.JSDocScanner;
import com.aptana.editor.js.JSEscapeSequenceScanner;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.JSTemplateContentAssistProcessor;
import com.aptana.editor.js.JSTemplateScanner;
import com.aptana.editor.js.contentassist.JSContentAssistProcessor;
import com.aptana.editor.js.sdoc.SDocContentAssistProcessor;
import com.aptana.editor.js.text.rules.JSRegExpRule;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IFileEditorInput;

public class JSSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__js_";
    public static final String DEFAULT = "__js__dftl_partition_content_type";
    public static final String JS_MULTILINE_COMMENT = "__js_multiline_comment";
    public static final String JS_SINGLELINE_COMMENT = "__js_singleline_comment";
    public static final String JS_DOC = "__js_sdoc_comment";
    public static final String STRING_DOUBLE = "__js_string_double";
    public static final String STRING_SINGLE = "__js_string_single";
    public static final String JS_REGEXP = "__js_regexp";
    public static final String JS_TEMPLATE = "__js_template";
    public static final String[] CONTENT_TYPES = new String[]{"__js__dftl_partition_content_type", "__js_multiline_comment", "__js_singleline_comment", "__js_sdoc_comment", "__js_string_double", "__js_string_single", "__js_regexp", "__js_template"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.js"}};
    private IPredicateRule[] partitioningRules = new IPredicateRule[]{new EndOfLineRule("//", this.getToken("__js_singleline_comment")), new ResumableSingleLineRule("\"", "\"", (IToken)new ExtendedToken(this.getToken("__js_string_double")), '\\', true), new ResumableSingleLineRule("'", "'", (IToken)new ExtendedToken(this.getToken("__js_string_single")), '\\', true), new EmptyCommentRule(this.getToken("__js_multiline_comment")), new MultiLineRule("/**", "*/", this.getToken("__js_sdoc_comment"), '\u0000', true), new MultiLineRule("/*", "*/", this.getToken("__js_multiline_comment"), '\u0000', true), new JSRegExpRule(this.getToken("__js_regexp"))};
    private static JSSourceConfiguration INSTANCE;

    static {
        CommonEditorPlugin plugin = CommonEditorPlugin.getDefault();
        if (plugin != null) {
            IContentTypeTranslator c = plugin.getContentTypeTranslator();
            c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.js"}), new QualifiedContentType(new String[]{"source.js"}));
            c.addTranslation(new QualifiedContentType(new String[]{STRING_DOUBLE}), new QualifiedContentType(new String[]{"string.quoted.double.js"}));
            c.addTranslation(new QualifiedContentType(new String[]{JS_TEMPLATE}), new QualifiedContentType(new String[]{"string.quoted.double.js"}));
            c.addTranslation(new QualifiedContentType(new String[]{STRING_SINGLE}), new QualifiedContentType(new String[]{"string.quoted.single.js"}));
            c.addTranslation(new QualifiedContentType(new String[]{JS_REGEXP}), new QualifiedContentType(new String[]{"string.regexp.js"}));
            c.addTranslation(new QualifiedContentType(new String[]{JS_SINGLELINE_COMMENT}), new QualifiedContentType(new String[]{"comment.line.double-slash.js"}));
            c.addTranslation(new QualifiedContentType(new String[]{JS_MULTILINE_COMMENT}), new QualifiedContentType(new String[]{"comment.block.js"}));
            c.addTranslation(new QualifiedContentType(new String[]{JS_DOC}), new QualifiedContentType(new String[]{"comment.block.documentation.js"}));
        }
    }

    private JSSourceConfiguration() {
    }

    public static JSSourceConfiguration getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new JSSourceConfiguration();
        }
        return INSTANCE;
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.partitioningRules, CONTENT_TYPES, this.getToken(DEFAULT));
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.js";
        }
        return null;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        dr = new ThemeingDamagerRepairer(this.getJSDocScanner());
        reconciler.setDamager((IPresentationDamager)dr, JS_DOC);
        reconciler.setRepairer((IPresentationRepairer)dr, JS_DOC);
        dr = new ThemeingDamagerRepairer(this.getMultiLineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, JS_MULTILINE_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, JS_MULTILINE_COMMENT);
        dr = new ThemeingDamagerRepairer(this.getSingleQuotedStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_SINGLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_SINGLE);
        dr = new ThemeingDamagerRepairer(this.getDoubleQuotedStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_DOUBLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_DOUBLE);
        dr = new ThemeingDamagerRepairer(this.getSingleLineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, JS_SINGLELINE_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, JS_SINGLELINE_COMMENT);
        dr = new ThemeingDamagerRepairer(this.getRegexpScanner());
        reconciler.setDamager((IPresentationDamager)dr, JS_REGEXP);
        reconciler.setRepairer((IPresentationRepairer)dr, JS_REGEXP);
        dr = new ThemeingDamagerRepairer(this.getTemplateScanner());
        reconciler.setDamager((IPresentationDamager)dr, JS_TEMPLATE);
        reconciler.setRepairer((IPresentationRepairer)dr, JS_TEMPLATE);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        try {
            if ("__dftl_partition_content_type".equals(contentType) || DEFAULT.equals(contentType) || STRING_DOUBLE.equals(contentType) || STRING_SINGLE.equals(contentType)) {
                JSContentAssistProcessor processor = new JSContentAssistProcessor(editor);
                if (editor != null && editor.getEditorInput() instanceof IFileEditorInput) {
                    IFileEditorInput fileInput = (IFileEditorInput)editor.getEditorInput();
                    String fileExt = fileInput.getFile().getFileExtension();
                    processor.setFileType(fileExt);
                }
                return processor;
            }
            if (JS_DOC.equals(contentType)) {
                return new SDocContentAssistProcessor(editor);
            }
            if (JS_TEMPLATE.equals(contentType)) {
                return new JSTemplateContentAssistProcessor(editor);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    private ITokenScanner getMultiLineCommentScanner() {
        return new CommentScanner(this.getToken("comment.block.js"));
    }

    private ITokenScanner getSingleLineCommentScanner() {
        return new CommentScanner(this.getToken("comment.line.double-slash.js"));
    }

    private ITokenScanner getRegexpScanner() {
        return new JSEscapeSequenceScanner("string.regexp.js");
    }

    private ITokenScanner getDoubleQuotedStringScanner() {
        return new JSEscapeSequenceScanner("string.quoted.double.js");
    }

    private ITokenScanner getSingleQuotedStringScanner() {
        return new JSEscapeSequenceScanner("string.quoted.single.js");
    }

    private ITokenScanner getJSDocScanner() {
        return new JSDocScanner();
    }

    private ITokenScanner getCodeScanner() {
        return new JSCodeScanner();
    }

    private ITokenScanner getTemplateScanner() {
        return new JSTemplateScanner(this.getToken("string.quoted.double.js"));
    }

    private IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }
}

