/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js;

import com.aptana.editor.common.ICommentHandler;
import com.aptana.editor.common.util.CommentHandlerUtil;
import com.aptana.editor.js.JSDocumentProvider;
import com.aptana.editor.js.JSMetadataLoader;
import com.aptana.editor.js.JSStartup;
import com.pandora.core.JavaScriptVersion;
import com.pandora.core.utils.ProjectUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.BundleContext;

public class JSPlugin
extends AbstractUIPlugin
implements ICommentHandler {
    public static final String PLUGIN_ID = "com.aptana.editor.js";
    public static final String IS_UPDATE = "is_update";
    private static JSPlugin PLUGIN;
    private IDocumentProvider jsDocumentProvider;

    public static JSPlugin getDefault() {
        return PLUGIN;
    }

    public static Image getImage(String path) {
        ImageRegistry registry = PLUGIN.getImageRegistry();
        Image image = registry.get(path);
        if (image == null) {
            ImageDescriptor id = JSPlugin.getImageDescriptor(path);
            if (id == null) {
                return null;
            }
            registry.put(path, id);
            image = registry.get(path);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PLUGIN = this;
        CommentHandlerUtil.setCommentHandler((ICommentHandler)this);
    }

    public void stop(BundleContext context) throws Exception {
        PLUGIN = null;
        JSStartup.removePartListener();
        super.stop(context);
    }

    public synchronized IDocumentProvider getJSDocumentProvider() {
        if (this.jsDocumentProvider == null) {
            this.jsDocumentProvider = new JSDocumentProvider();
        }
        return this.jsDocumentProvider;
    }

    public void waitingForJavascriptMetadata() {
        Job[] jobs = Job.getJobManager().find((Object)"JSMetadataLoader");
        Object loader = null;
        if (jobs != null && jobs.length == 1) {
            loader = jobs[0];
        } else {
            JSMetadataLoader job = new JSMetadataLoader();
            job.schedule();
            loader = job;
        }
        try {
            loader.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isStarted() {
        return JSPlugin.getDefault().getPreferenceStore().getBoolean("js_comments");
    }

    public boolean isEnableES6(IProject project) {
        return ProjectUtils.getJavaScriptVersion((IProject)project) == JavaScriptVersion.ECMASCRIPT6;
    }
}

