/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class JSDocScanner
extends RuleBasedScanner {
    private static String[] KEYWORDS = new String[]{"@author", "@class", "@constructor", "@deprecated", "@exception", "@extends", "@final", "@member", "@param", "@private", "@requires", "@return", "@returns", "@see", "@serial", "@serialData", "@serialField", "@since", "@throws", "@type", "@version"};

    public JSDocScanner() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new SingleLineRule("<", ">", this.getToken("text.html.basic")));
        list.add(new SingleLineRule("{", "}", this.getToken("entity.other.inherited-class")));
        IToken keyword = this.getToken("meta.tag.documentation.js");
        WordRule wordRule = new WordRule((IWordDetector)new JSDocWordDetector());
        String[] stringArray = KEYWORDS;
        int n = KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            wordRule.addWord(word, keyword);
            ++n2;
        }
        list.add(wordRule);
        this.setDefaultReturnToken(this.getToken("comment.block.documentation.js"));
        this.setRules(list.toArray(new IRule[list.size()]));
    }

    protected IToken getToken(String tokenName) {
        return new Token((Object)tokenName);
    }

    static class JSDocWordDetector
    implements IWordDetector {
        JSDocWordDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@';
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c);
        }
    }
}

