/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.parsing.AbstractFlexTokenScanner;
import com.aptana.editor.js.JSLanguageConstants;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.parsing.JSFlexScanner;
import com.aptana.editor.js.parsing.lexer.JSScopeType;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class JSCodeScanner
extends AbstractFlexTokenScanner {
    private static final Token UNDEFINED_TOKEN = new Token((Object)JSScopeType.UNDEFINED.getScope());
    private static final Token NUMBER_TOKEN = new Token((Object)JSScopeType.NUMBER.getScope());
    private static final Token IDENTIFIER_TOKEN = new Token((Object)JSScopeType.SOURCE.getScope());
    private static final Token SEMICOLON_TOKEN = new Token((Object)JSScopeType.SEMICOLON.getScope());
    private static final Token OPERATOR_TOKEN = new Token((Object)JSScopeType.OPERATOR.getScope());
    private static final Token STORAGE_TOKEN = new Token((Object)JSScopeType.STORAGE_TYPE.getScope());
    private static final Token STORAGE_MODIFIER_TOKEN = new Token((Object)JSScopeType.STORAGE_MODIFIER.getScope());
    private static final Token TRUE_TOKEN = new Token((Object)JSScopeType.TRUE.getScope());
    private static final Token FALSE_TOKEN = new Token((Object)JSScopeType.FALSE.getScope());
    private static final Token NULL_TOKEN = new Token((Object)JSScopeType.NULL.getScope());
    private static final Token CONSTANT_TOKEN = new Token((Object)JSScopeType.CONSTANT.getScope());
    private static final Token VARIABLE_TOKEN = new Token((Object)JSScopeType.VARIABLE.getScope());
    private static final Token OTHER_KEYWORD_TOKEN = new Token((Object)JSScopeType.OTHER_KEYWORD.getScope());
    private static final Token PARENTHESIS_TOKEN = new Token((Object)JSScopeType.PARENTHESIS.getScope());
    private static final Token BRACKET_TOKEN = new Token((Object)JSScopeType.BRACKET.getScope());
    private static final Token CURLY_BRACE_TOKEN = new Token((Object)JSScopeType.CURLY_BRACE.getScope());
    private static final Token COMMA_TOKEN = new Token((Object)JSScopeType.COMMA.getScope());
    private static final Token CONTROL_KEYWORD_TOKEN = new Token((Object)JSScopeType.CONTROL_KEYWORD.getScope());
    private static final Token SUPPORT_CLASS_TOKEN = new Token((Object)JSScopeType.SUPPORT_CLASS.getScope());
    private static final Token SUPPORT_DOM_CONSTANT_TOKEN = new Token((Object)JSScopeType.SUPPORT_DOM_CONSTANT.getScope());
    private static final Token PERIOD_TOKEN = new Token((Object)JSScopeType.PERIOD.getScope());
    private static final Token KEYWORD_OPERATOR_TOKEN = new Token((Object)JSScopeType.KEYWORD.getScope());
    private static final Token FIREBUG_FUNCTION_TOKEN = new Token((Object)JSScopeType.FIREBUG_FUNCTION.getScope());
    private static final Token FUNCTION_TOKEN = new Token((Object)JSScopeType.FUNCTION_KEYWORD.getScope());
    private static final Token FUNCTION_NAME_TOKEN = new Token((Object)JSScopeType.FUNCTION_NAME.getScope());
    private static final Token FUNCTION_PARAMETER_TOKEN = new Token((Object)JSScopeType.FUNCTION_PARAMETER.getScope());
    private static final Token FUNCTION_LPAREN_TOKEN = new Token((Object)JSScopeType.LEFT_PAREN.getScope());
    private static final Token FUNCTION_RPAREN_TOKEN = new Token((Object)JSScopeType.RIGHT_PAREN.getScope());
    private static final Token COLON_TOKEN = new Token(null);
    private static final Set<String> CONSTANTS = CollectionsUtil.newSet((Object[])new String[]{"Infinity", "NaN", "undefined"});
    private static final Set<String> VARIABLES = CollectionsUtil.newSet((Object[])new String[]{"super", "this"});
    private static final Set<String> OTHER_KEYWORDS = CollectionsUtil.newSet((Object[])new String[]{"debugger"});
    private static final Set<String> SUPPORT_CLASSES = CollectionsUtil.newSet((Object[])new String[0]);
    private static final Set<String> FIREBUG_FUNCTONS = CollectionsUtil.newSet((Object[])new String[0]);
    private static final Set<String> KEYWORD_CONTROL_FUTURE = CollectionsUtil.newSet((Object[])JSLanguageConstants.KEYWORD_CONTROL_FUTURE);
    private static final Set<String> STORAGE_TYPES = CollectionsUtil.newSet((Object[])JSLanguageConstants.STORAGE_TYPES);
    private static final Set<String> STORAGE_MODIFEERS = CollectionsUtil.newSet((Object[])JSLanguageConstants.STORAGE_MODIFIERS);
    private static final Set<String> SUPPORT_DOM_CONSTANT = CollectionsUtil.newSet((Object[])new String[0]);
    private State fCurrentState = State.DEFAULT;
    public static final String TOKEN_NAME_JSCLASS = "jsClass";
    public static final String TOKEN_NAME_JSDOMCONSTANT = "jsDomConstant";

    static {
        try {
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
            map.put(TOKEN_NAME_JSCLASS, SUPPORT_CLASSES);
            map.put(TOKEN_NAME_JSDOMCONSTANT, SUPPORT_DOM_CONSTANT);
            JSCodeScanner.getTokenDefaultNames(map, (boolean)true);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
        }
    }

    public JSCodeScanner() {
        super((Scanner)new JSFlexScanner());
    }

    protected void setSource(String string) {
        ((JSFlexScanner)this.fScanner).setCollectComments(false);
        ((JSFlexScanner)this.fScanner).setSource(string);
        ((JSFlexScanner)this.fScanner).setEnablejsx(true);
    }

    protected void setSource(char[] source, int offset, int length, int skipStart, int skipEnd) {
        ((JSFlexScanner)this.fScanner).setCollectComments(false);
        ((JSFlexScanner)this.fScanner).setSource(source, offset, length, skipStart, skipEnd);
        ((JSFlexScanner)this.fScanner).setEnablejsx(true);
    }

    protected IToken getUndefinedToken() {
        return UNDEFINED_TOKEN;
    }

    protected IToken mapToken(Symbol token) throws IOException, Scanner.Exception {
        switch (token.getId()) {
            case 17: {
                return NULL_TOKEN;
            }
            case 18: {
                return TRUE_TOKEN;
            }
            case 19: {
                return FALSE_TOKEN;
            }
            case 55: {
                return PERIOD_TOKEN;
            }
            case 25: 
            case 33: 
            case 103: {
                return STORAGE_TOKEN;
            }
            case 50: {
                this.fCurrentState = State.CLASS_DECLARATION;
                return STORAGE_TOKEN;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 20: 
            case 22: 
            case 23: 
            case 51: 
            case 52: 
            case 58: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 96: 
            case 97: 
            case 99: 
            case 100: {
                return OPERATOR_TOKEN;
            }
            case 14: 
            case 21: 
            case 24: 
            case 42: 
            case 56: 
            case 69: 
            case 91: {
                return KEYWORD_OPERATOR_TOKEN;
            }
            case 26: {
                this.fCurrentState = State.FUNCTION_DECLARATION;
                return FUNCTION_TOKEN;
            }
            case 4: {
                if (this.fCurrentState == State.FUNCTION_DECLARATION) {
                    this.fCurrentState = State.FUNCTION_DECLARATION_INSIDE_PARENS;
                    return FUNCTION_LPAREN_TOKEN;
                }
            }
            case 34: {
                if (this.fCurrentState == State.FUNCTION_DECLARATION || this.fCurrentState == State.FUNCTION_DECLARATION_INSIDE_PARENS) {
                    this.fCurrentState = State.DEFAULT;
                    return FUNCTION_RPAREN_TOKEN;
                }
                return PARENTHESIS_TOKEN;
            }
            case 3: 
            case 49: {
                return BRACKET_TOKEN;
            }
            case 2: 
            case 48: {
                return CURLY_BRACE_TOKEN;
            }
            case 29: {
                return SEMICOLON_TOKEN;
            }
            case 16: {
                return STORAGE_TOKEN;
            }
            case 32: {
                return COMMA_TOKEN;
            }
            case 53: {
                return COLON_TOKEN;
            }
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 57: 
            case 61: 
            case 93: 
            case 94: 
            case 95: 
            case 104: 
            case 105: 
            case 109: {
                return CONTROL_KEYWORD_TOKEN;
            }
            case 1: {
                LinkedList tempQueue;
                if (this.fCurrentState == State.FUNCTION_DECLARATION) {
                    return FUNCTION_NAME_TOKEN;
                }
                if (this.fCurrentState == State.FUNCTION_DECLARATION_INSIDE_PARENS) {
                    return FUNCTION_PARAMETER_TOKEN;
                }
                if (this.fCurrentState == State.CLASS_DECLARATION) {
                    this.fCurrentState = State.DEFAULT;
                    return SUPPORT_CLASS_TOKEN;
                }
                if (this.fCurrentState == State.JSX_TAG) {
                    this.fCurrentState = State.DEFAULT;
                    return FUNCTION_NAME_TOKEN;
                }
                LinkedList linkedList = tempQueue = this.fLookAheadQueue.peek() != null ? new LinkedList(this.fLookAheadQueue) : null;
                block27: while (true) {
                    Symbol nextToken;
                    if ((nextToken = this.lookAhead(tempQueue)).getId() == 51) {
                        nextToken = this.lookAhead(tempQueue);
                        if (nextToken.getId() == 26) {
                            return FUNCTION_NAME_TOKEN;
                        }
                        if (nextToken.getId() != 1) break;
                        continue;
                    }
                    if (!this.enableES6() || nextToken.getId() != 4) break;
                    int limit = 20;
                    do {
                        if (limit < 0) continue block27;
                        --limit;
                        nextToken = this.lookAhead(tempQueue);
                        if (nextToken.getId() != 34) continue;
                        nextToken = this.lookAhead(tempQueue);
                        if (nextToken.getId() != 2) continue block27;
                        return FUNCTION_NAME_TOKEN;
                    } while (nextToken.getId() != 0);
                }
                if (CONSTANTS.contains(token.value)) {
                    return CONSTANT_TOKEN;
                }
                if (VARIABLES.contains(token.value)) {
                    return VARIABLE_TOKEN;
                }
                if (OTHER_KEYWORDS.contains(token.value)) {
                    return OTHER_KEYWORD_TOKEN;
                }
                if (this.fLastSymbol.getId() == 55 && FIREBUG_FUNCTONS.contains(token.value)) {
                    return FIREBUG_FUNCTION_TOKEN;
                }
                if (SUPPORT_CLASSES.contains(token.value)) {
                    return SUPPORT_CLASS_TOKEN;
                }
                if (KEYWORD_CONTROL_FUTURE.contains(token.value)) {
                    return CONTROL_KEYWORD_TOKEN;
                }
                if (STORAGE_MODIFEERS.contains(token.value)) {
                    return STORAGE_MODIFIER_TOKEN;
                }
                if (STORAGE_TYPES.contains(token.value)) {
                    return STORAGE_TOKEN;
                }
                if (SUPPORT_DOM_CONSTANT.contains(token.value)) {
                    return SUPPORT_DOM_CONSTANT_TOKEN;
                }
                String tokenVal = token.value.toString();
                if (StringUtil.isNotBlank((String)tokenVal)) {
                    char[] cArray = tokenVal.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char ch = cArray[n2];
                        if (!Character.isUpperCase(ch) && ch != '_') {
                            return IDENTIFIER_TOKEN;
                        }
                        ++n2;
                    }
                    return CONSTANT_TOKEN;
                }
                return IDENTIFIER_TOKEN;
            }
            case 6: {
                return NUMBER_TOKEN;
            }
            case 59: {
                return new Token((Object)"entity.name.tag.block.any.jsx");
            }
            case 60: {
                return new Token((Object)"entity.other.attribute-name.jsx");
            }
            case 11: 
            case 98: 
            case 101: 
            case 102: {
                return new Token((Object)"punctuation.definition.tag.jsx");
            }
            case 5: {
                return new Token((Object)"string.quoted.jsx");
            }
            case 0: {
                return Token.EOF;
            }
        }
        String msg = "JSCodeScanner: Token not mapped: " + token.getId() + ">>" + token.value + "<<";
        IdeLog.logWarning((Plugin)JSPlugin.getDefault(), (String)msg);
        return UNDEFINED_TOKEN;
    }

    private boolean enableES6() {
        return true;
    }

    private static enum State {
        DEFAULT,
        FUNCTION_DECLARATION,
        FUNCTION_DECLARATION_INSIDE_PARENS,
        CLASS_DECLARATION,
        JSX_TAG;

    }
}

