/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.proxy;

import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.HttpProxySocket;
import com.enterprisedt.util.proxy.PlainSocket;
import com.enterprisedt.util.proxy.ProxySettings;
import com.enterprisedt.util.proxy.ProxyType;
import com.enterprisedt.util.proxy.Socks4ProxySocket;
import com.enterprisedt.util.proxy.Socks5ProxySocket;
import com.enterprisedt.util.proxy.StreamSocket;
import java.io.IOException;
import java.net.Socket;

public class StreamSocketFactory {
    private static Logger a = Logger.getLogger("StreamSocketFactory");

    public static StreamSocket getConnectedSocket(String host, int port, int socketTimeout, ProxySettings settings) throws IOException {
        Socket socket = null;
        String string = "Connecting to " + host + ":" + port;
        if (settings.getProxyType().equals(ProxyType.HTTP)) {
            a.debug(string + " via HTTP proxy");
            socket = HttpProxySocket.connectViaProxy(host, port, settings.getProxyAddress(), settings.getProxyPort(), settings.getProxyUserName(), settings.getProxyPassword(), socketTimeout, "edtFTPj/PRO");
        } else if (settings.getProxyType().equals(ProxyType.SOCKS4)) {
            a.debug(string + " via SOCKS4 proxy");
            socket = Socks4ProxySocket.connectViaSocks4Proxy(host, port, settings.getProxyAddress(), settings.getProxyPort(), socketTimeout, settings.getProxyUserName());
        } else if (settings.getProxyType().equals(ProxyType.SOCKS5)) {
            a.debug(string + " via SOCKS5 proxy");
            socket = Socks5ProxySocket.connectViaSocks5Proxy(host, port, settings.getProxyAddress(), settings.getProxyPort(), socketTimeout, settings.getProxyUserName(), settings.getProxyPassword());
        } else {
            a.debug(string + " via standard socket");
            PlainSocket plainSocket = PlainSocket.createPlainSocket(host, port, socketTimeout);
            plainSocket.setSendBufferSize(32768);
            plainSocket.setReceiveBufferSize(32768);
            plainSocket.setTcpNoDelay(true);
            socket = plainSocket;
        }
        if (socket != null) {
            socket.setSoTimeout(socketTimeout);
        }
        return socket;
    }
}

