/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.license;

import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.license.EDTProduct;
import com.enterprisedt.util.license.LicensePropertiesBase;
import com.enterprisedt.util.license.LicenseReader;
import java.io.FileNotFoundException;
import java.util.Properties;

public class LicenseProperties
extends LicensePropertiesBase {
    public static final String cvsId = "@(#)$Id: LicenseProperties.java,v 1.10 2007-07-05 05:21:29 bruceb Exp $";
    private static Logger c = Logger.getLogger("LicenseProperties");
    private LicenseReader d = new LicenseReader();

    public LicenseProperties() {
        try {
            this.a(LicenseProperties.a());
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to read license file. Is license.jar in the CLASSPATH?");
        }
    }

    public LicenseProperties(String licenseFile) throws FileNotFoundException {
        this.a(LicenseProperties.a(licenseFile));
    }

    public LicenseProperties(String owner, String key, String productStr) {
        this.owner = owner;
        this.key = key;
        this.productStr = productStr;
        this.product = EDTProduct.getProduct(productStr);
        this.flags = this.d.calcRegFlags(owner + productStr, key);
        this.isTrial = this.flags[0];
        this.expiryDate = this.d.calcRegExpiryDate(owner + productStr, key);
    }

    private void a(Properties properties) {
        if (properties == null) {
            throw new RuntimeException("Could not find license. Is license.jar in the CLASSPATH?");
        }
        this.key = LicenseProperties.a(properties, "license.key");
        this.owner = LicenseProperties.a(properties, "license.owner");
        this.productStr = LicenseProperties.a(properties, "license.product");
        this.product = EDTProduct.getProduct(this.productStr);
        this.flags = this.d.calcRegFlags(this.owner + this.productStr, this.key);
        this.isTrial = this.flags[0];
        this.expiryDate = this.d.calcRegExpiryDate(this.owner + this.productStr, this.key);
    }

    public static void main(String[] args) {
        try {
            LicenseProperties licenseProperties = null;
            if (args.length == 0) {
                licenseProperties = new LicenseProperties();
            } else if (args.length >= 1) {
                licenseProperties = new LicenseProperties(args[0]);
            }
            System.out.println("Trial: " + licenseProperties.isTrial());
            System.out.println("Expiry: " + licenseProperties.a.format(licenseProperties.getExpiryDate()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

