/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.license;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.util.license.LicensePaddingScheme;

public class LicensePKCS7
extends LicensePaddingScheme {
    public LicensePKCS7() {
        super("PKCS#7");
    }

    protected int enginePad(byte[] in, int offset, int length) {
        int n2 = this.padLength(length);
        byte by = (byte)n2;
        int n3 = offset + length;
        for (int i2 = 0; i2 < n2; ++i2) {
            in[n3++] = by;
        }
        return n2;
    }

    protected int engineUnpad(byte[] in, int offset, int length) {
        int n2 = offset + length - 1;
        if (n2 >= 0) {
            if (in[n2] > this.blockSize) {
                throw new CryptixException(this.getAlgorithm() + ": Invalid number of padding bytes");
            }
            return offset + length - (in[offset + length - 1] & 0xFF);
        }
        return 0;
    }

    protected boolean engineIsValidBlockSize(int size) {
        return size > 0 && size < 256;
    }
}

