/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util;

public class PathUtils {
    public static String DEFAULT_SEPARATOR = "/";

    public static String getDirectoryName(String path, String separator) {
        int n2 = (path = path.trim()).lastIndexOf(separator);
        if (n2 > 0) {
            return path.substring(0, n2);
        }
        if (n2 == 0) {
            return separator;
        }
        return null;
    }

    public static String getDirectoryName(String path) {
        return PathUtils.getDirectoryName(path, DEFAULT_SEPARATOR);
    }

    public static String getFileName(String path, String separator) {
        int n2 = (path = path.trim()).lastIndexOf(separator);
        if (n2 >= 0 && n2 + 1 < path.length()) {
            return path.substring(n2 + 1);
        }
        return path;
    }

    public static String getFileName(String path) {
        return PathUtils.getFileName(path, DEFAULT_SEPARATOR);
    }

    public static String getExtension(String path) {
        if ((path = path.trim()) == null) {
            return null;
        }
        int n2 = path.lastIndexOf(46);
        if (n2 < 0) {
            return null;
        }
        if (n2 == path.length() - 1) {
            return "";
        }
        return path.substring(n2 + 1);
    }

    public static String combine(String path1, String path2, String separator) {
        path1 = path1.trim();
        path2 = path2.trim();
        return path1 + (!path1.endsWith(separator) ? separator : "") + path2;
    }

    public static String combine(String path1, String path2) {
        return PathUtils.combine(path1, path2, DEFAULT_SEPARATOR);
    }

    public static boolean isAbsolutePath(String path, String separator) {
        return path.startsWith(separator);
    }

    public static boolean isAbsolutePath(String path) {
        return PathUtils.isAbsolutePath(DEFAULT_SEPARATOR);
    }
}

