/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import com.enterprisedt.cryptix.util.mime.Base64OutputStream;
import com.enterprisedt.net.puretls.LoadProviders;
import com.enterprisedt.net.puretls.cert.DERUtils;
import com.enterprisedt.net.puretls.cert.EAYDSAPrivateKey;
import com.enterprisedt.net.puretls.cert.X509DSAPublicKey;
import com.enterprisedt.net.puretls.cert.X509Name;
import com.enterprisedt.net.puretls.cert.d;
import com.enterprisedt.net.puretls.cert.e;
import com.enterprisedt.net.puretls.crypto.EAYEncryptedPrivateKey;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.DSAKeyPairGenerator;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.Vector;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;

public class CertRequest {
    public static KeyPair generateKey(String type, int size, String password, BufferedWriter keyfile, boolean newParams) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        Object object;
        KeyPairGenerator keyPairGenerator;
        if (type.equals("DSA")) {
            keyPairGenerator = KeyPairGenerator.getInstance(type);
            object = (DSAKeyPairGenerator)((Object)keyPairGenerator);
            object.initialize(size, newParams, new SecureRandom());
        } else {
            keyPairGenerator = KeyPairGenerator.getInstance(type, "CryptixEDT");
            keyPairGenerator.initialize(size);
        }
        object = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = type.equals("DSA") ? new EAYDSAPrivateKey((DSAPrivateKey)((KeyPair)object).getPrivate()) : new d((CryptixRSAPrivateKey)((KeyPair)object).getPrivate());
        EAYEncryptedPrivateKey.writePrivateKey(privateKey, password.getBytes(), keyfile);
        return object;
    }

    public static byte[] makeSPKACRequest(KeyPair p2) throws IOException {
        byte[] byArray;
        Object object;
        String string;
        byte[] byArray2;
        PrivateKey privateKey = p2.getPrivate();
        PublicKey publicKey = p2.getPublic();
        String string2 = privateKey.getAlgorithm();
        byte[] byArray3 = new byte[]{48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0};
        byte[] byArray4 = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0};
        if (string2.equals("DSA")) {
            byArray2 = byArray3;
            string = "DSA";
            publicKey = new X509DSAPublicKey((DSAPublicKey)publicKey);
        } else if (string2.equals("RSA")) {
            byArray2 = byArray4;
            string = "SHA-1/RSA/PKCS#1";
            publicKey = new e((CryptixRSAPublicKey)publicKey);
        } else {
            throw new InternalError("Unknown algorithm " + string2);
        }
        byte[] byArray5 = publicKey.getEncoded();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray5);
        DERUtils.encodeIA5String("Challenge", byteArrayOutputStream);
        byte[] byArray6 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray6, (OutputStream)byteArrayOutputStream);
        byte[] byArray7 = byteArrayOutputStream.toByteArray();
        try {
            object = Signature.getInstance(string, "CryptixEDT");
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray7);
            byArray = ((Signature)object).sign();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray7);
        byteArrayOutputStream.write(byArray2);
        if (string2.equals("RSA")) {
            byArray = CertRequest.fitSignature(byArray, publicKey);
        }
        DERUtils.encodeBitString(byArray, byteArrayOutputStream);
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence((byte[])object, (OutputStream)byteArrayOutputStream);
        byte[] byArray8 = byteArrayOutputStream.toByteArray();
        return byArray8;
    }

    public static byte[] makePKCS10Request(KeyPair p2, X509Name name) throws IOException {
        byte[] byArray;
        Object object;
        String string;
        byte[] byArray2;
        PrivateKey privateKey = p2.getPrivate();
        PublicKey publicKey = p2.getPublic();
        String string2 = privateKey.getAlgorithm();
        byte[] byArray3 = new byte[]{48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0};
        byte[] byArray4 = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0};
        if (string2.equals("DSA")) {
            byArray2 = byArray3;
            string = "DSA";
            publicKey = new X509DSAPublicKey((DSAPublicKey)publicKey);
        } else if (string2.equals("RSA")) {
            byArray2 = byArray4;
            string = "SHA-1/RSA/PKCS#1";
            publicKey = new e((CryptixRSAPublicKey)publicKey);
        } else {
            throw new InternalError("Unknown algorithm " + string2);
        }
        byte[] byArray5 = publicKey.getEncoded();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERUtils.encodeInteger(new BigInteger("0"), byteArrayOutputStream);
        byteArrayOutputStream.write(name.getNameDER());
        byteArrayOutputStream.write(byArray5);
        byte[] byArray6 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray6, (OutputStream)byteArrayOutputStream);
        byte[] byArray7 = byteArrayOutputStream.toByteArray();
        try {
            object = Signature.getInstance(string, "CryptixEDT");
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray7);
            byArray = ((Signature)object).sign();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray7);
        byteArrayOutputStream.write(byArray2);
        if (string2.equals("RSA")) {
            byArray = CertRequest.fitSignature(byArray, publicKey);
        }
        DERUtils.encodeBitString(byArray, byteArrayOutputStream);
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence((byte[])object, (OutputStream)byteArrayOutputStream);
        byte[] byArray8 = byteArrayOutputStream.toByteArray();
        return byArray8;
    }

    public static byte[] makeSelfSignedCert(KeyPair p2, X509Name name, int lifetime) throws IOException {
        byte[] byArray;
        Object object;
        String string;
        byte[] byArray2;
        PrivateKey privateKey = p2.getPrivate();
        PublicKey publicKey = p2.getPublic();
        String string2 = privateKey.getAlgorithm();
        byte[] byArray3 = new byte[]{48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0};
        byte[] byArray4 = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0};
        if (string2.equals("DSA")) {
            byArray2 = byArray3;
            string = "DSA";
            publicKey = new X509DSAPublicKey((DSAPublicKey)publicKey);
        } else if (string2.equals("RSA")) {
            byArray2 = byArray4;
            string = "SHA-1/RSA/PKCS#1";
            publicKey = new e((CryptixRSAPublicKey)publicKey);
        } else {
            throw new InternalError("Unknown algorithm " + string2);
        }
        byte[] byArray5 = publicKey.getEncoded();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERUtils.encodeInteger(new BigInteger("0"), byteArrayOutputStream);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(name.getNameDER());
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        long l2 = System.currentTimeMillis();
        long l3 = lifetime;
        long l4 = l2 + l3 * 1000L;
        DERUtils.encodeUTCTime(l2, byteArrayOutputStream2);
        DERUtils.encodeUTCTime(l4, byteArrayOutputStream2);
        DERUtils.encodeSequence(byteArrayOutputStream2, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.write(name.getNameDER());
        byteArrayOutputStream.write(byArray5);
        byte[] byArray6 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray6, (OutputStream)byteArrayOutputStream);
        byte[] byArray7 = byteArrayOutputStream.toByteArray();
        try {
            object = Signature.getInstance(string, "CryptixEDT");
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray7);
            byArray = ((Signature)object).sign();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray7);
        byteArrayOutputStream.write(byArray2);
        if (string2.equals("RSA")) {
            byArray = CertRequest.fitSignature(byArray, publicKey);
        }
        DERUtils.encodeBitString(byArray, byteArrayOutputStream);
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence((byte[])object, (OutputStream)byteArrayOutputStream);
        byte[] byArray8 = byteArrayOutputStream.toByteArray();
        return byArray8;
    }

    public static X509Name makeSimpleDN(Vector rdns) {
        Vector vector = new Vector();
        for (int i2 = 0; i2 < rdns.size(); ++i2) {
            String[] stringArray = (String[])rdns.elementAt(i2);
            Vector<String[]> vector2 = new Vector<String[]>();
            String[] stringArray2 = new String[]{new String(stringArray[0]), new String(stringArray[1])};
            vector2.addElement(stringArray2);
            vector.addElement(vector2);
        }
        return new X509Name(vector);
    }

    protected static byte[] fitSignature(byte[] tmp, PublicKey pub) {
        CryptixRSAPublicKey cryptixRSAPublicKey = (CryptixRSAPublicKey)pub;
        int n2 = cryptixRSAPublicKey.getModulus().bitLength();
        int n3 = n2 / 8;
        if (tmp.length == (n3 += n2 % 8 > 0 ? 1 : 0)) {
            return tmp;
        }
        byte[] byArray = new byte[n3];
        if (tmp.length < n3) {
            int n4;
            for (n4 = 0; n4 < n3 - tmp.length; ++n4) {
                byArray[n4] = 0;
            }
            System.arraycopy(tmp, 0, byArray, n4, tmp.length);
        } else {
            int n5;
            for (n5 = 0; n5 < tmp.length - n3; ++n5) {
                if (tmp[n5] == 0) continue;
                throw new InternalError("RSA signature error");
            }
            System.arraycopy(tmp, n5, byArray, 0, n3);
        }
        return byArray;
    }

    private static X509Name a(String string) {
        Vector<String[]> vector = new Vector<String[]>();
        String[] stringArray = new String[2];
        String[] stringArray2 = new String[2];
        String[] stringArray3 = new String[2];
        String[] stringArray4 = new String[2];
        stringArray[0] = "C";
        stringArray[1] = "US";
        stringArray2[0] = "O";
        stringArray2[1] = "Snake Oil, Inc.";
        stringArray3[0] = "OU";
        stringArray3[1] = "Test";
        stringArray4[0] = "CN";
        stringArray4[1] = string;
        vector.addElement(stringArray);
        vector.addElement(stringArray2);
        vector.addElement(stringArray3);
        vector.addElement(stringArray4);
        return CertRequest.makeSimpleDN(vector);
    }

    public static void main(String[] args) throws IOException, Exception {
        String string;
        byte[] byArray;
        String string2 = args[0];
        String string3 = null;
        int n2 = 0;
        String string4 = args.length >= 2 ? args[1] : "DSA";
        if (args.length >= 3) {
            if (args[2].equals("SPKAC")) {
                n2 = 0;
            } else if (args[2].equals("PKCS10")) {
                n2 = 1;
            } else if (args[2].equals("X509")) {
                n2 = 2;
            } else {
                throw new InternalError("Unknown type " + args[2]);
            }
        }
        if (n2 == 1 || n2 == 2) {
            if (args.length != 4) {
                throw new InternalError("Must supply common name for type" + n2);
            }
            string3 = args[3];
        }
        int n3 = 1024;
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string5 = bufferedReader.readLine();
        FileWriter fileWriter = new FileWriter(string2);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        KeyPair keyPair = CertRequest.generateKey(string4, n3, string5, bufferedWriter, true);
        switch (n2) {
            case 0: {
                byArray = CertRequest.makeSPKACRequest(keyPair);
                break;
            }
            case 1: {
                byArray = CertRequest.makePKCS10Request(keyPair, CertRequest.a(string3));
                break;
            }
            case 2: {
                byArray = CertRequest.makeSelfSignedCert(keyPair, CertRequest.a(string3), 30000000);
                break;
            }
            default: {
                throw new InternalError("Bad type");
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream);
        base64OutputStream.write(byArray);
        base64OutputStream.flush();
        base64OutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        InputStreamReader inputStreamReader2 = new InputStreamReader(byteArrayInputStream);
        BufferedReader bufferedReader2 = new BufferedReader(inputStreamReader2);
        System.out.println(string5);
        switch (n2) {
            case 1: {
                System.out.println("-----BEGIN CERTIFICATE REQUEST-----");
                break;
            }
            case 2: {
                System.out.println("-----BEGIN CERTIFICATE-----");
            }
        }
        while ((string = bufferedReader2.readLine()) != null) {
            System.out.println(string);
        }
        switch (n2) {
            case 1: {
                System.out.println("-----END CERTIFICATE REQUEST-----");
                break;
            }
            case 2: {
                System.out.println("-----END CERTIFICATE-----");
            }
        }
    }

    static {
        LoadProviders.init();
    }
}

