/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls;

import com.enterprisedt.net.puretls.LoadProviders;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.SSLPeerCertVerifier;
import com.enterprisedt.net.puretls.ad;
import com.enterprisedt.net.puretls.cert.CertificateException;
import com.enterprisedt.net.puretls.cert.EAYDHParams;
import com.enterprisedt.net.puretls.cert.WrappedObject;
import com.enterprisedt.net.puretls.cert.X509Cert;
import com.enterprisedt.net.puretls.crypto.DHPrivateKey;
import com.enterprisedt.net.puretls.crypto.EAYEncryptedPrivateKey;
import com.enterprisedt.net.puretls.crypto.RandomStore;
import com.enterprisedt.net.puretls.sslg.SSLContextInt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;

public class SSLContext
extends SSLContextInt {
    private Hashtable i = new Hashtable();
    Vector a = new Vector();
    Vector b = null;
    PrivateKey c = null;
    PublicKey d = null;
    private int j = 1024;
    DHPrivateKey e = null;
    EAYDHParams f = null;
    KeyPair g = null;
    SecureRandom h = null;
    private boolean k = false;
    private SSLPeerCertVerifier l = null;

    public SSLContext() {
        LoadProviders.init();
    }

    public void seedRNG(byte[] seed) {
        if (seed == null) {
            seed = new byte[]{};
        }
        if (this.h == null) {
            this.h = new SecureRandom(seed);
        } else {
            this.h.setSeed(seed);
        }
        this.h.setSeed(System.currentTimeMillis());
    }

    public void useRandomnessFile(String file, String passphrase) throws IOException, FileNotFoundException {
        this.h = null;
        try {
            this.h = RandomStore.readRandomStore(file, passphrase.getBytes());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (this.h == null) {
            this.h = new SecureRandom();
            RandomStore.writeRandomStore(file, passphrase.getBytes(), this.h);
        }
    }

    public void setPrivateKey(PrivateKey key) {
        this.c = key;
    }

    public void setPublicKey(PublicKey key) {
        this.d = key;
    }

    public void setPublicKeyFromCert(byte[] certData) throws IOException {
        X509Cert x509Cert = new X509Cert(certData);
        this.d = x509Cert.getPublicKey();
    }

    public void setCertificateChain(Vector chain) {
        this.b = chain;
    }

    public void loadPKCS12File(String path, String passphrase) {
        throw new InternalError("Not implemented");
    }

    public void loadEAYKeyFile(String path, String passphrase) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(path);
        this.loadEAYKeyFile(fileInputStream, passphrase);
    }

    public void loadEAYKeyFile(InputStream is, String passphrase) throws IOException {
        Object object;
        PrivateKey privateKey;
        int n2;
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = is.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        StringBuffer stringBuffer = new StringBuffer();
        SSLDebug.debug(16, "Loading key file");
        if (!WrappedObject.findObject(bufferedReader, "PRIVATE KEY", stringBuffer)) {
            throw new IOException("Couldn't find private key in this file");
        }
        try {
            privateKey = EAYEncryptedPrivateKey.createPrivateKey(bufferedReader, stringBuffer.toString(), passphrase.getBytes());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
        byteArrayInputStream = new ByteArrayInputStream(byArray2);
        bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        Vector<byte[]> vector = new Vector<byte[]>();
        while ((object = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
            SSLDebug.debug(16, "Loading certificate", (byte[])object);
            vector.insertElementAt((byte[])object, 0);
        }
        if (vector.size() == 0) {
            throw new IOException("Need at least one certificate");
        }
        object = new X509Cert((byte[])vector.elementAt(0));
        this.d = ((X509Cert)object).getPublicKey();
        this.c = privateKey;
        this.b = vector;
    }

    public void saveEAYKeyFile(String path, String passphrase) throws IOException, FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(path);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        EAYEncryptedPrivateKey.writePrivateKey(this.c, passphrase.getBytes(), bufferedWriter);
        for (int i2 = 1; i2 <= this.b.size(); ++i2) {
            byte[] byArray = (byte[])this.b.elementAt(this.b.size() - i2);
            WrappedObject.writeHeader("CERTIFICATE", bufferedWriter);
            WrappedObject.writeObject(byArray, "CERTIFICATE", bufferedWriter);
        }
        bufferedWriter.flush();
        fileOutputStream.close();
    }

    public void setClientCertPrivKey(Certificate[] javaCertChain, PrivateKey javaPrivateKey) throws CertificateException {
        try {
            this.b = new Vector();
            for (int i2 = 0; i2 < javaCertChain.length; ++i2) {
                X509Cert x509Cert = new X509Cert(javaCertChain[i2].getEncoded());
                this.b.insertElementAt(x509Cert.getDER(), 0);
            }
            X509Cert x509Cert = new X509Cert((byte[])this.b.get(0));
            this.d = x509Cert.getPublicKey();
            this.c = EAYEncryptedPrivateKey.createPrivateKey(javaPrivateKey, javaPrivateKey.getAlgorithm());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CertificateException(certificateEncodingException.getMessage());
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    public void loadRootCertificates(String path) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(path);
        this.loadRootCertificates(fileInputStream);
        fileInputStream.close();
    }

    public void loadRootCertificates(InputStream is) throws IOException {
        byte[] byArray;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
        while ((byArray = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
            SSLDebug.debug(16, "Loading root", byArray);
            this.a.addElement(byArray);
        }
    }

    public void setRootCertificates(Vector certs) {
        this.a = certs;
    }

    public void loadDHParams(String path) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(path);
        this.loadDHParams(fileInputStream);
        fileInputStream.close();
    }

    public void loadDHParams(InputStream is) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
        byte[] byArray = WrappedObject.loadObject(bufferedReader, "DH PARAMETERS", null);
        if (byArray == null) {
            return;
        }
        SSLDebug.debug(16, "Loading DH params", byArray);
        this.f = new EAYDHParams(byArray);
    }

    public void saveDHParams(String path, int size, boolean sophieGermainPrimes) throws IOException, FileNotFoundException {
        DHPrivateKey dHPrivateKey = this.a(size, sophieGermainPrimes, true);
        EAYDHParams eAYDHParams = new EAYDHParams(dHPrivateKey.getg(), dHPrivateKey.getp());
        byte[] byArray = eAYDHParams.getEncoded();
        FileOutputStream fileOutputStream = new FileOutputStream(path);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        WrappedObject.writeHeader("DH PARAMETERS", bufferedWriter);
        WrappedObject.writeObject(byArray, "DH PARAMETERS", bufferedWriter);
        bufferedWriter.flush();
        outputStreamWriter.flush();
        fileOutputStream.close();
    }

    Vector a() {
        return this.a;
    }

    Vector b() {
        return this.b;
    }

    PrivateKey c() {
        return this.c;
    }

    PublicKey d() {
        return this.d;
    }

    DHPrivateKey a(boolean bl) throws IOException {
        if (this.f == null) {
            throw new IOException("Must install DH parameters");
        }
        return this.a(this.j, this.k, bl);
    }

    private synchronized DHPrivateKey a(int n2, boolean bl, boolean bl2) {
        this.i();
        if (this.e == null || bl2) {
            this.e = DHPrivateKey.getInstance();
            if (this.f == null) {
                throw new InternalError("Can't generate ephemeral key without setting DH params");
            }
            this.e.initPrivateKey(this.f.getG(), this.f.getP(), this.h);
        }
        return this.e;
    }

    private synchronized KeyPair h() {
        this.i();
        if (this.g == null) {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "CryptixEDT");
                keyPairGenerator.initialize(512, this.h);
                this.g = keyPairGenerator.generateKeyPair();
            }
            catch (Exception exception) {
                throw new InternalError(exception.toString());
            }
        }
        return this.g;
    }

    synchronized CryptixRSAPrivateKey e() {
        return (CryptixRSAPrivateKey)this.h().getPrivate();
    }

    synchronized CryptixRSAPublicKey f() {
        return (CryptixRSAPublicKey)this.h().getPublic();
    }

    synchronized byte[] g() {
        byte[] byArray = new byte[128];
        this.i();
        this.h.nextBytes(byArray);
        return byArray;
    }

    protected synchronized void storeSession(String key, ad sd) {
        SSLDebug.debug(4, "Storing session under key " + key);
        this.i.put(key, sd);
    }

    protected synchronized ad findSession(String key) {
        Object v2 = this.i.get(key);
        if (v2 == null) {
            SSLDebug.debug(4, "Could not recover cached session using key " + key);
            return null;
        }
        SSLDebug.debug(4, "Recovered cached session using key " + key);
        return (ad)v2;
    }

    protected synchronized void destroySession(String sessionLookupKey) {
        SSLDebug.debug(4, "Destroying session" + sessionLookupKey);
        this.i.remove(sessionLookupKey);
    }

    private void i() {
        if (this.h != null) {
            return;
        }
        this.h = new SecureRandom();
    }

    public SSLPeerCertVerifier getVerifier() {
        return this.l;
    }

    public void setVerifier(SSLPeerCertVerifier verifier) {
        this.l = verifier;
    }
}

