/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.util;

import com.enterprisedt.net.j2ssh.util.InvalidStateException;
import java.io.Serializable;

public abstract class State
implements Serializable {
    protected int state;

    public State(int initialState) {
        this.state = initialState;
    }

    public abstract boolean isValidState(int var1);

    public synchronized void setValue(int state) throws InvalidStateException {
        if (!this.isValidState(state)) {
            throw new InvalidStateException("The state is invalid");
        }
        this.state = state;
        this.notifyAll();
    }

    public synchronized int getValue() {
        return this.state;
    }

    public synchronized void breakWaiting() {
        this.notifyAll();
    }

    public synchronized boolean waitForState(int state) throws InvalidStateException, InterruptedException {
        return this.waitForState(state, 0L);
    }

    public synchronized boolean waitForState(int state, long timeout) throws InvalidStateException, InterruptedException {
        if (!this.isValidState(state)) {
            throw new InvalidStateException("The state is invalid");
        }
        if (timeout < 0L) {
            timeout = 0L;
        }
        while (this.state != state) {
            this.wait(timeout);
            if (timeout == 0L) continue;
        }
        return this.state == state;
    }

    public synchronized boolean waitForStateUpdate(long timeout) throws InterruptedException {
        int n2 = this.state;
        this.wait(timeout);
        return n2 != this.state;
    }
}

