/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.rsa;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;

public class SshRsaPublicKey
extends SshPublicKey {
    private static Logger b = Logger.getLogger("SshRsaPublicKey");
    RSAPublicKey a;

    public SshRsaPublicKey(RSAPublicKey key) {
        this.a = key;
    }

    public SshRsaPublicKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(encoded);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                String string2 = "Header '" + string + "' does not match algorithm '" + this.getAlgorithmName() + "'";
                b.error(string2);
                throw new InvalidSshKeyException(string2);
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger2, bigInteger);
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                this.a = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                b.error("SshRsaPublicKey()", noSuchAlgorithmException);
                throw new InvalidSshKeyException(noSuchAlgorithmException);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                b.error("SshRsaPublicKey()", invalidKeySpecException);
                throw new InvalidSshKeyException(invalidKeySpecException);
            }
        }
        catch (IOException iOException) {
            b.error("SshRsaPublicKey()", iOException);
            throw new InvalidSshKeyException(iOException);
        }
    }

    public String getAlgorithmName() {
        return "ssh-rsa";
    }

    public int getBitLength() {
        return this.a.getModulus().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithmName());
            byteArrayWriter.writeBigInteger(this.a.getPublicExponent());
            byteArrayWriter.writeBigInteger(this.a.getModulus());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean verifySignature(byte[] signature, byte[] data) throws InvalidSshKeySignatureException {
        try {
            Object object;
            if (signature.length != 128) {
                b.debug("Signature length=" + signature.length);
                object = new ByteArrayReader(signature);
                byte[] byArray = ((ByteArrayReader)object).readBinaryString();
                String string = new String(byArray);
                if (!string.equals(this.getAlgorithmName())) {
                    b.error("Header (" + string + ") does not match algorithm (" + this.getAlgorithmName() + ")");
                    throw new InvalidSshKeySignatureException();
                }
                signature = ((ByteArrayReader)object).readBinaryString();
            }
            object = Signature.getInstance("SHA1withRSA", "CryptixEDT");
            ((Signature)object).initVerify(this.a);
            ((Signature)object).update(data);
            b.debug("Verifying signature (" + object.getClass().getName() + ")");
            return ((Signature)object).verify(signature);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            String string = "No such provider found: CryptixEDT";
            b.error(string, noSuchProviderException);
            throw new InvalidSshKeySignatureException(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string = "No such algorithm found: SHA1withRSA";
            b.error(string, noSuchAlgorithmException);
            throw new InvalidSshKeySignatureException(noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            String string = "Failed to read signature";
            b.error(string, iOException);
            throw new InvalidSshKeySignatureException(string);
        }
        catch (InvalidKeyException invalidKeyException) {
            b.error("Invalid key signature", invalidKeyException);
            throw new InvalidSshKeySignatureException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            b.error("Signature exception", signatureException);
            throw new InvalidSshKeySignatureException(signatureException);
        }
    }
}

