/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.rsa;

import com.enterprisedt.net.j2ssh.configuration.ConfigurationLoader;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaPublicKey;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class SshRsaKeyPair
extends SshKeyPair {
    public SshPrivateKey decodePrivateKey(byte[] encoded) throws InvalidSshKeyException {
        return new SshRsaPrivateKey(encoded);
    }

    public SshPublicKey decodePublicKey(byte[] encoded) throws InvalidSshKeyException {
        return new SshRsaPublicKey(encoded);
    }

    public void generate(int bits) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "CryptixEDT");
            keyPairGenerator.initialize(bits, ConfigurationLoader.getRND());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.setPrivateKey(new SshRsaPrivateKey((RSAPrivateKey)keyPair.getPrivate(), (RSAPublicKey)keyPair.getPublic()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
    }
}

