/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.dsa;

import com.enterprisedt.cryptix.util.core.Hex;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.util.SimpleASNWriter;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;

public class SshDssPublicKey
extends SshPublicKey {
    private static Logger b = Logger.getLogger(a == null ? (a = SshDssPublicKey.class$("com.enterprisedt.net.j2ssh.transport.publickey.dsa.SshDssPublicKey")) : a);
    private DSAPublicKey c;
    static Class a;

    public SshDssPublicKey(DSAPublicKey key) {
        this.c = key;
    }

    public SshDssPublicKey(byte[] key) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(key);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException(string);
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            BigInteger bigInteger4 = byteArrayReader.readBigInteger();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            this.c = (DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec);
        }
        catch (Exception exception) {
            b.error("SshDssPublicKey", exception);
            throw new InvalidSshKeyException(exception);
        }
    }

    public String getAlgorithmName() {
        return "ssh-dss";
    }

    public int getBitLength() {
        return this.c.getY().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithmName());
            byteArrayWriter.writeBigInteger(this.c.getParams().getP());
            byteArrayWriter.writeBigInteger(this.c.getParams().getQ());
            byteArrayWriter.writeBigInteger(this.c.getParams().getG());
            byteArrayWriter.writeBigInteger(this.c.getY());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean verifySignature(byte[] signature, byte[] data) throws InvalidSshKeySignatureException {
        try {
            Object object;
            Object object2;
            Object object3;
            Closeable closeable;
            if (signature.length != 40) {
                b.debug("Signature length=" + signature.length);
                closeable = new ByteArrayReader(signature);
                object3 = ((ByteArrayReader)closeable).readBinaryString();
                object2 = new String((byte[])object3);
                b.debug("Header is " + (String)object2);
                if (!((String)object2).equals("ssh-dss")) {
                    b.error("Header (" + (String)object2 + ") does not match algorithm (ssh-dss)");
                    throw new InvalidSshKeySignatureException((String)object2);
                }
                signature = ((ByteArrayReader)closeable).readBinaryString();
            }
            closeable = new ByteArrayOutputStream();
            object3 = new ByteArrayOutputStream();
            object2 = new SimpleASNWriter();
            ((SimpleASNWriter)object2).writeByte(2);
            if ((signature[0] & 0x80) == 128 && signature[0] != 0) {
                ((ByteArrayOutputStream)closeable).write(0);
                ((ByteArrayOutputStream)closeable).write(signature, 0, 20);
            } else {
                ((ByteArrayOutputStream)closeable).write(signature, 0, 20);
            }
            ((SimpleASNWriter)object2).writeData(((ByteArrayOutputStream)closeable).toByteArray());
            ((SimpleASNWriter)object2).writeByte(2);
            if ((signature[20] & 0x80) == 128 && signature[20] != 0) {
                ((ByteArrayOutputStream)object3).write(0);
                ((ByteArrayOutputStream)object3).write(signature, 20, 20);
            } else {
                ((ByteArrayOutputStream)object3).write(signature, 20, 20);
            }
            ((SimpleASNWriter)object2).writeData(((ByteArrayOutputStream)object3).toByteArray());
            SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
            simpleASNWriter.writeByte(48);
            simpleASNWriter.writeData(((SimpleASNWriter)object2).toByteArray());
            byte[] byArray = simpleASNWriter.toByteArray();
            if (b.isDebugEnabled()) {
                b.debug("Verifying host key signature");
                b.debug("Signature length is " + String.valueOf(signature.length));
                object = Hex.toString(signature);
                b.debug("Signature: " + (String)object);
                object = Hex.toString(byArray);
                b.debug("Encoded: " + (String)object);
            }
            object = Signature.getInstance("SHA1withDSA", "CryptixEDT");
            ((Signature)object).initVerify(this.c);
            ((Signature)object).update(data);
            return ((Signature)object).verify(byArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            b.error("verifySignature", noSuchProviderException);
            throw new InvalidSshKeySignatureException();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            b.error("verifySignature", noSuchAlgorithmException);
            throw new InvalidSshKeySignatureException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            b.error("verifySignature", invalidKeyException);
            throw new InvalidSshKeySignatureException(invalidKeyException);
        }
        catch (IOException iOException) {
            b.error("verifySignature", iOException);
            throw new InvalidSshKeySignatureException(iOException);
        }
        catch (SignatureException signatureException) {
            b.error("verifySignature", signatureException);
            throw new InvalidSshKeySignatureException(signatureException);
        }
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

