/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.enterprisedt.net.j2ssh.util.Hash;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public abstract class SshPublicKey {
    public abstract String getAlgorithmName();

    public abstract int getBitLength();

    public abstract byte[] getEncoded();

    public String getFingerprint() {
        try {
            Hash hash = new Hash("MD5");
            hash.putBytes(this.getEncoded());
            byte[] byArray = hash.doFinal();
            int n2 = this.getBitLength();
            n2 = n2 % 8 != 0 ? (n2 = n2 + n2 % 8) : n2;
            String string = String.valueOf(n2);
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                string = string + (i2 == 0 ? ":" : "") + " " + Integer.toHexString(byArray[i2] & 0xFF);
            }
            return string;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshPublicKey) {
            return this.getFingerprint().compareTo(((SshPublicKey)obj).getFingerprint()) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.getFingerprint().hashCode();
    }

    public abstract boolean verifySignature(byte[] var1, byte[] var2) throws InvalidSshKeySignatureException;
}

