/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SshKeyPairFactory {
    private static String c = "ssh-dss";
    private static String d = "ssh-rsa";
    private static Map e;
    private static String f;
    private static Logger g;
    private ArrayList h = new ArrayList(e.keySet());
    static Class a;
    static Class b;

    public static void initialize() {
    }

    public static String getDefaultPublicKey() {
        return f;
    }

    public List getEnabledKeyPairs() {
        return this.h;
    }

    public void disableAllKeys() {
        this.h.clear();
    }

    public void setPreferredKeyPair(String keyPair) {
        g.debug("Setting preferred keypair = " + keyPair);
        if (!e.containsKey(keyPair)) {
            g.warn(keyPair + " not set to preferred as not supported");
        } else {
            if (this.h.contains(keyPair)) {
                this.h.remove(keyPair);
            }
            this.h.add(0, keyPair);
        }
    }

    public void setKeyEnabled(String algorithmName, boolean enable) throws AlgorithmNotSupportedException {
        if (!e.containsKey(algorithmName)) {
            throw new AlgorithmNotSupportedException(algorithmName + " is not supported!");
        }
        if (enable) {
            if (!this.h.contains(algorithmName)) {
                this.h.add(algorithmName);
            }
        } else {
            this.h.remove(algorithmName);
        }
    }

    public boolean isKeyEnabled(String algorithmName) {
        return this.h.contains(algorithmName);
    }

    public static SshKeyPair newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyPair)((Class)e.get(methodName)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(methodName + " is not supported!", exception);
        }
    }

    public static boolean supportsKey(String algorithm) {
        return e.containsKey(algorithm);
    }

    public static SshPrivateKey decodePrivateKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(encoded);
            String string = byteArrayReader.readString();
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                return sshKeyPair.decodePrivateKey(encoded);
            }
            throw new AlgorithmNotSupportedException(string + " is not supported");
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException);
        }
    }

    public static SshPublicKey decodePublicKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(encoded);
            String string = byteArrayReader.readString();
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                return sshKeyPair.decodePublicKey(encoded);
            }
            throw new AlgorithmNotSupportedException(string + " is not supported");
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException);
        }
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        g = Logger.getLogger("SshKeyPairFactory");
        e = new LinkedHashMap();
        g.debug("Loading public key algorithms");
        e.put(c, a == null ? (a = SshKeyPairFactory.class$("com.enterprisedt.net.j2ssh.transport.publickey.dsa.SshDssKeyPair")) : a);
        e.put(d, b == null ? (b = SshKeyPairFactory.class$("com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaKeyPair")) : b);
        f = c;
    }
}

