/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.kex;

import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.transport.kex.AbstractDhGroupSha1;
import com.enterprisedt.net.j2ssh.transport.kex.KeyExchangeException;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhInit;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhReply;
import com.enterprisedt.net.j2ssh.util.Hash;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import xjava.security.interfaces.ElGamalKeyPairGenerator;
import xjava.security.interfaces.ElGamalPrivateKey;
import xjava.security.interfaces.ElGamalPublicKey;

public class DhGroup1Sha1
extends AbstractDhGroupSha1 {
    private static Logger c = Logger.getLogger("DhGroup1Sha1");
    public static String KEY_EXCHANGE_NAME = "diffie-hellman-group1-sha1";
    private static final BigInteger d = new BigInteger("2");
    private static final BigInteger g = new BigInteger(new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -55, 15, -38, -94, 33, 104, -62, 52, -60, -58, 98, -117, -128, -36, 28, -47, 41, 2, 78, 8, -118, 103, -52, 116, 2, 11, -66, -90, 59, 19, -101, 34, 81, 74, 8, 121, -114, 52, 4, -35, -17, -107, 25, -77, -51, 58, 67, 27, 48, 43, 10, 109, -14, 95, 20, 55, 79, -31, 53, 109, 109, 81, -62, 69, -28, -123, -75, 118, 98, 94, 126, -58, -12, 76, 66, -23, -90, 55, -19, 107, 11, -1, 92, -74, -12, 6, -73, -19, -18, 56, 107, -5, 90, -119, -97, -91, -82, -97, 36, 17, 124, 75, 31, -26, 73, 40, 102, 81, -20, -26, 83, -127, -1, -1, -1, -1, -1, -1, -1, -1});
    private BigInteger h = null;
    static Class a;
    static Class b;

    public void performClientExchange(String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit) throws IOException {
        c.info("Starting client side key exchange.");
        this.clientId = clientId;
        this.serverId = serverId;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        this.messageStore.registerMessage(30, a == null ? (a = DhGroup1Sha1.class$("com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhInit")) : a);
        this.messageStore.registerMessage(31, b == null ? (b = DhGroup1Sha1.class$("com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhReply")) : b);
        this.transport.addMessageStore(this.messageStore);
        ((ElGamalKeyPairGenerator)((Object)this.dhKeyPairGen)).initialize(g, d, new SecureRandom());
        KeyPair keyPair = this.dhKeyPairGen.generateKeyPair();
        this.h = ((ElGamalPrivateKey)keyPair.getPrivate()).getX();
        this.e = ((ElGamalPublicKey)keyPair.getPublic()).getY();
        SshMsgKexDhInit sshMsgKexDhInit = new SshMsgKexDhInit(this.e);
        try {
            this.transport.sendMessage(sshMsgKexDhInit, this);
        }
        catch (SshException sshException) {
            throw new KeyExchangeException("Failed to send key exchange initialization message");
        }
        int[] nArray = new int[]{31};
        SshMsgKexDhReply sshMsgKexDhReply = (SshMsgKexDhReply)this.transport.readMessage(nArray);
        this.hostKey = sshMsgKexDhReply.getHostKey();
        this.signature = sshMsgKexDhReply.getSignature();
        this.f = sshMsgKexDhReply.getF();
        if (c.isEnabledFor(Level.ALL)) {
            c.log(Level.ALL, sshMsgKexDhReply.toString(), null);
        }
        this.secret = this.f.modPow(this.h, g);
        this.calculateExchangeHash();
    }

    protected void calculateExchangeHash() throws KeyExchangeException {
        try {
            c.debug("calculateExchangeHash()");
            Hash hash = new Hash("SHA");
            hash.putString(this.clientId);
            hash.putString(this.serverId);
            hash.putInt(this.clientKexInit.length);
            hash.putBytes(this.clientKexInit);
            hash.putInt(this.serverKexInit.length);
            hash.putBytes(this.serverKexInit);
            hash.putInt(this.hostKey.length);
            hash.putBytes(this.hostKey);
            hash.putBigInteger(this.e);
            hash.putBigInteger(this.f);
            hash.putBigInteger(this.secret);
            this.exchangeHash = hash.doFinal();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

