/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.ftp.VersionDetails;
import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.SshThread;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthBanner;
import com.enterprisedt.net.j2ssh.configuration.ConfigurationLoader;
import com.enterprisedt.net.j2ssh.configuration.SshConnectionProperties;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.AlgorithmInitializationException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotAgreedException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmOperationException;
import com.enterprisedt.net.j2ssh.transport.HostKeyVerification;
import com.enterprisedt.net.j2ssh.transport.MessageAlreadyRegisteredException;
import com.enterprisedt.net.j2ssh.transport.MessageNotRegisteredException;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.net.j2ssh.transport.SshMessageStore;
import com.enterprisedt.net.j2ssh.transport.SshMsgDebug;
import com.enterprisedt.net.j2ssh.transport.SshMsgDisconnect;
import com.enterprisedt.net.j2ssh.transport.SshMsgIgnore;
import com.enterprisedt.net.j2ssh.transport.SshMsgKexInit;
import com.enterprisedt.net.j2ssh.transport.SshMsgNewKeys;
import com.enterprisedt.net.j2ssh.transport.SshMsgUnimplemented;
import com.enterprisedt.net.j2ssh.transport.TransportProtocol;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolAlgorithmSync;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolEventHandler;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolException;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolState;
import com.enterprisedt.net.j2ssh.transport.a;
import com.enterprisedt.net.j2ssh.transport.b;
import com.enterprisedt.net.j2ssh.transport.kex.KeyExchangeException;
import com.enterprisedt.net.j2ssh.transport.kex.SshKeyExchange;
import com.enterprisedt.net.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.enterprisedt.net.j2ssh.util.Hash;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.StreamSocket;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class TransportProtocolCommon
implements TransportProtocol,
Runnable {
    protected static Logger log = Logger.getLogger("TransportProtocolCommon");
    private static int a = 1;
    public static final int EOL_CRLF = 1;
    public static final int EOL_LF = 2;
    public static final String PROTOCOL_VERSION = "2.0";
    public static final int DEFAULT_PORT = 22;
    public static String SOFTWARE_VERSION_COMMENTS = "edtFTPjPRO-" + VersionDetails.getVersionString();
    private static String i = "SSH-";
    private int j = a++;
    protected BigInteger k = null;
    protected Boolean completeOnNewKeys = new Boolean(false);
    protected HostKeyVerification hosts;
    protected Map kexs = new HashMap();
    private boolean l = false;
    protected SshConnectionProperties properties;
    protected SshMessageStore messageStore = new SshMessageStore();
    protected SshMsgKexInit clientKexInit = null;
    protected SshMsgKexInit serverKexInit = null;
    protected String clientIdent = null;
    protected String serverIdent = null;
    protected TransportProtocolAlgorithmSync algorithmsIn;
    protected TransportProtocolAlgorithmSync algorithmsOut;
    protected TransportProtocolState state = new TransportProtocolState();
    private byte[] m = null;
    protected byte[] sessionIdentifier = null;
    protected byte[] hostKey = null;
    protected byte[] signature = null;
    private Vector n = new Vector();
    private List o = new ArrayList();
    private Map p = new HashMap();
    private Object q = new Object();
    private StreamSocket r;
    private SshThread s;
    private long t = 3540000L;
    private long u = 996147200L;
    private long v = System.currentTimeMillis();
    private long w = 0L;
    private boolean x = true;
    protected a sshIn;
    protected b sshOut;
    private int y = 1;
    private Vector z = new Vector();
    private String A;
    static Class b;
    static Class c;
    static Class d;
    static Class e;
    static Class f;
    static Class g;
    static Class h;

    public TransportProtocolCommon(boolean enableRekey) {
        this.x = enableRekey;
    }

    public TransportProtocolCommon() {
        this(false);
    }

    public int getConnectionId() {
        return this.j;
    }

    public int getRemoteEOL() {
        return this.y;
    }

    public String getUserAuthBanner() {
        return this.A;
    }

    public TransportProtocolState getState() {
        return this.state;
    }

    public SshConnectionProperties getProperties() {
        return this.properties;
    }

    protected abstract void onDisconnect();

    public void disconnect(String description) {
        log.debug("Disconnect: " + description);
        try {
            this.state.setValue(5);
            this.state.setDisconnectReason(description);
            this.sendDisconnect(11, description);
        }
        catch (Exception exception) {
            log.warn("Failed to send disconnect", exception);
        }
    }

    public void disconnectImmediately(String description) {
        log.debug("DisconnectImmediately: " + description);
        this.state.setValue(5);
        this.state.setDisconnectReason(description);
    }

    public void setSendIgnore(boolean sendIgnore) {
        this.l = sendIgnore;
    }

    public void sendIgnore() throws TransportProtocolException {
        byte[] byArray = new byte[1];
        ConfigurationLoader.getRND().nextBytes(byArray);
        byte[] byArray2 = new byte[(byArray[0] & 0xFF) + 1];
        ConfigurationLoader.getRND().nextBytes(byArray2);
        SshMsgIgnore sshMsgIgnore = new SshMsgIgnore(new String(byArray2));
        if (log.isDebugEnabled()) {
            log.debug("Sending " + sshMsgIgnore.getMessageName());
        }
        this.sshOut.a(sshMsgIgnore);
    }

    public void setKexTimeout(long seconds) throws TransportProtocolException {
        if (seconds < 60L) {
            throw new TransportProtocolException("Keys can only be re-exchanged every minute or more");
        }
        this.t = seconds * 1000L;
    }

    public void setKexTransferLimit(long kilobytes) throws TransportProtocolException {
        if (kilobytes < 10L) {
            throw new TransportProtocolException("Keys can only be re-exchanged after every 10k of data, or more");
        }
        this.u = kilobytes * 1024L;
    }

    public long getOutgoingByteCount() {
        return this.sshOut.a();
    }

    public long getIncomingByteCount() {
        return this.sshIn.b();
    }

    public void addEventHandler(TransportProtocolEventHandler eventHandler) {
        if (eventHandler != null) {
            this.n.add(eventHandler);
        }
    }

    public abstract void registerTransportMessages() throws MessageAlreadyRegisteredException;

    public byte[] getSessionIdentifier() {
        return (byte[])this.sessionIdentifier.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                this.state.setValue(2);
                log.debug("Registering transport protocol messages with inputstream");
                this.algorithmsOut = new TransportProtocolAlgorithmSync();
                this.algorithmsIn = new TransportProtocolAlgorithmSync();
                this.sshIn = new a(this, this.r.getInputStream(), this.algorithmsIn);
                this.sshOut = new b(this.r.getOutputStream(), this, this.algorithmsOut);
                this.messageStore.registerMessage(1, b == null ? (b = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.transport.SshMsgDisconnect")) : b);
                this.messageStore.registerMessage(2, c == null ? (c = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.transport.SshMsgIgnore")) : c);
                this.messageStore.registerMessage(3, d == null ? (d = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.transport.SshMsgUnimplemented")) : d);
                this.messageStore.registerMessage(4, e == null ? (e = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.transport.SshMsgDebug")) : e);
                this.messageStore.registerMessage(20, f == null ? (f = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.transport.SshMsgKexInit")) : f);
                this.messageStore.registerMessage(21, g == null ? (g = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.transport.SshMsgNewKeys")) : g);
                this.messageStore.registerMessage(53, h == null ? (h = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthBanner")) : h);
                this.registerTransportMessages();
                List list = SshKeyExchangeFactory.getSupportedKeyExchanges();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    SshKeyExchange sshKeyExchange = SshKeyExchangeFactory.newInstance(string);
                    sshKeyExchange.init(this);
                    this.kexs.put(string, sshKeyExchange);
                }
                this.setLocalIdent();
                this.a();
                this.startBinaryPacketProtocol();
            }
            catch (Throwable throwable) {
                if (throwable instanceof IOException) {
                    this.state.setLastError((IOException)throwable);
                }
                if (this.state.getValue() != 5) {
                    log.warn("The Transport Protocol thread failed: " + throwable.getMessage());
                    this.stop();
                    this.state.setValue(5);
                }
                Object var6_7 = null;
                this.s = null;
            }
            Object var6_6 = null;
            this.s = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.s = null;
            throw throwable;
        }
        log.info("The Transport Protocol has been stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendMessage(SshMessage msg, Object sender) throws IOException {
        if (log.isEnabledFor(Level.ALL)) {
            log.log(Level.ALL, msg.toString(), null);
        } else if (log.isDebugEnabled()) {
            log.debug("Sending " + msg.getMessageName());
        }
        int n2 = this.state.getValue();
        if (sender instanceof SshKeyExchange || sender instanceof TransportProtocolCommon || n2 == 4) {
            this.sshOut.a(msg);
            if (n2 == 4 && this.l) {
                this.sendIgnore();
            }
        } else if (n2 == 3) {
            log.debug("Adding to message queue whilst in key exchange");
            List list = this.o;
            synchronized (list) {
                this.o.add(msg);
            }
        } else {
            throw new TransportProtocolException("The transport protocol is disconnected");
        }
    }

    protected abstract void onStartTransportProtocol() throws IOException;

    public void startTransportProtocol(StreamSocket provider) throws IOException {
        this.r = provider;
        log.debug("Starting transport protocol");
        this.s = new SshThread(this, "Transport protocol", true);
        this.s.start();
        this.onStartTransportProtocol();
    }

    public String getUnderlyingProviderDetail() {
        return this.r.getDetail();
    }

    public void unregisterMessage(Integer messageId, SshMessageStore store) throws MessageNotRegisteredException {
        if (log.isDebugEnabled()) {
            log.debug("Unregistering message Id " + messageId.toString());
        }
        if (!this.p.containsKey(messageId)) {
            throw new MessageNotRegisteredException(messageId);
        }
        SshMessageStore sshMessageStore = (SshMessageStore)this.p.get(messageId);
        if (!store.equals(sshMessageStore)) {
            throw new MessageNotRegisteredException(messageId, store);
        }
        this.p.remove(messageId);
    }

    protected abstract String getDecryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getEncryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamCompAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setLocalIdent();

    public abstract String getLocalId();

    protected abstract void setLocalKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getLocalKexInit();

    protected abstract String getOutputStreamCompAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getOutputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setRemoteIdent(String var1);

    public abstract String getRemoteId();

    protected abstract void setRemoteKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getRemoteKexInit();

    protected abstract void performKeyExchange(SshKeyExchange var1) throws IOException, KeyExchangeException;

    protected String getKexAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedKex(), this.serverKexInit.getSupportedKex());
    }

    public boolean isConnected() {
        return this.state.getValue() == 4 || this.state.getValue() == 3;
    }

    protected void beginKeyExchange() throws IOException, KeyExchangeException {
        log.debug("Starting key exchange");
        String string = "";
        try {
            string = this.getKexAlgorithm();
            if (log.isDebugEnabled()) {
                log.debug("Key exchange algorithm: " + string);
            }
            SshKeyExchange sshKeyExchange = (SshKeyExchange)this.kexs.get(string);
            this.performKeyExchange(sshKeyExchange);
            this.m = sshKeyExchange.getExchangeHash();
            if (this.sessionIdentifier == null) {
                this.sessionIdentifier = new byte[this.m.length];
                System.arraycopy(this.m, 0, this.sessionIdentifier, 0, this.sessionIdentifier.length);
                this.s.setSessionId(this.sessionIdentifier);
            }
            this.hostKey = sshKeyExchange.getHostKey();
            this.signature = sshKeyExchange.getSignature();
            this.k = sshKeyExchange.getSecret();
            this.sendNewKeys();
            sshKeyExchange.reset();
        }
        catch (AlgorithmNotAgreedException algorithmNotAgreedException) {
            log.debug("beginKeyExchange()", algorithmNotAgreedException);
            this.sendDisconnect(3, "No suitable key exchange algorithm was agreed");
            throw new KeyExchangeException("No suitable key exchange algorithm could be agreed.", algorithmNotAgreedException);
        }
    }

    protected SshMsgKexInit createLocalKexInit() throws IOException {
        return new SshMsgKexInit(this.properties);
    }

    protected void onCorruptMac() {
        log.fatal("Corrupt Mac on Input");
        this.sendDisconnect(5, "Corrupt Mac on input", new SshException("Corrupt Mac on Imput"));
    }

    protected abstract void onMessageReceived(SshMessage var1) throws IOException;

    protected void sendDisconnect(int reason, String description) {
        SshMsgDisconnect sshMsgDisconnect = new SshMsgDisconnect(reason, description, "");
        if (log.isDebugEnabled()) {
            log.debug("sendDisconnect(" + reason + ",'" + description + "')");
        }
        try {
            this.sendMessage(sshMsgDisconnect, this);
            this.stop();
        }
        catch (Exception exception) {
            log.warn("Failed to send disconnect", exception);
        }
    }

    protected void sendDisconnect(int reason, String description, IOException error) {
        this.state.setLastError(error);
        this.sendDisconnect(reason, description);
    }

    protected void sendKeyExchangeInit() throws IOException {
        this.setLocalKexInit(this.createLocalKexInit());
        SshMsgKexInit sshMsgKexInit = this.getLocalKexInit();
        log.debug(sshMsgKexInit.toString());
        this.sendMessage(sshMsgKexInit, this);
        this.state.setValue(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendNewKeys() throws IOException {
        SshMsgNewKeys sshMsgNewKeys = new SshMsgNewKeys();
        this.sendMessage(sshMsgNewKeys, this);
        this.algorithmsOut.lock();
        int[] nArray = new int[]{21};
        sshMsgNewKeys = (SshMsgNewKeys)this.readMessage(nArray);
        try {
            this.completeKeyExchange();
            Object var4_3 = null;
            this.algorithmsIn.release();
            this.algorithmsOut.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.algorithmsIn.release();
            this.algorithmsOut.release();
            throw throwable;
        }
        this.sendOutstandingMessages();
    }

    protected abstract void setupNewKeys(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6) throws AlgorithmNotAgreedException, AlgorithmOperationException, AlgorithmNotSupportedException, AlgorithmInitializationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendOutstandingMessages() throws IOException {
        List list = this.o;
        synchronized (list) {
            Iterator iterator = this.o.iterator();
            log.debug("Sending queued messages");
            while (iterator.hasNext()) {
                SshMessage sshMessage = (SshMessage)iterator.next();
                this.sendMessage(sshMessage, this);
            }
            this.o.clear();
        }
    }

    protected void completeKeyExchange() throws IOException {
        log.debug("Completing key exchange");
        try {
            log.debug("Making keys from key exchange output");
            byte[] byArray = this.a('C');
            byte[] byArray2 = this.a('A');
            byte[] byArray3 = this.a('D');
            byte[] byArray4 = this.a('B');
            byte[] byArray5 = this.a('E');
            byte[] byArray6 = this.a('F');
            log.debug("Creating algorithm objects");
            this.setupNewKeys(byArray, byArray2, byArray3, byArray4, byArray5, byArray6);
            this.state.setValue(4);
        }
        catch (AlgorithmNotAgreedException algorithmNotAgreedException) {
            this.sendDisconnect(3, "Algorithm not agreed");
            throw new TransportProtocolException("The connection was disconnected because an algorithm could not be agreed", algorithmNotAgreedException);
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("The connection was disconnected because an algorithm class could not be loaded", algorithmNotSupportedException);
        }
        catch (AlgorithmOperationException algorithmOperationException) {
            this.sendDisconnect(3, "Algorithm operation error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm operation error", algorithmOperationException);
        }
        catch (AlgorithmInitializationException algorithmInitializationException) {
            this.sendDisconnect(3, "Algorithm initialization error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm initialization error", algorithmInitializationException);
        }
    }

    protected List getEventHandlers() {
        return this.n;
    }

    protected String determineAlgorithm(List clientAlgorithms, List serverAlgorithms, String preferredAlgorithm) throws AlgorithmNotAgreedException {
        if (preferredAlgorithm != null && clientAlgorithms.contains(preferredAlgorithm) && serverAlgorithms.contains(preferredAlgorithm)) {
            return preferredAlgorithm;
        }
        return this.determineAlgorithm(clientAlgorithms, serverAlgorithms);
    }

    protected String determineAlgorithm(List clientAlgorithms, List serverAlgorithms) throws AlgorithmNotAgreedException {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug("Determine Algorithm");
            log.debug("Client Algorithms: " + clientAlgorithms.toString());
            log.debug("Server Algorithms: " + serverAlgorithms.toString());
        }
        Iterator iterator = clientAlgorithms.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = serverAlgorithms.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (!string.equals(string2)) continue;
                log.debug("Returning " + string);
                return string;
            }
        }
        object = "Could not agree algorithm";
        log.error((String)object);
        throw new AlgorithmNotAgreedException((String)object);
    }

    protected void startBinaryPacketProtocol() throws IOException {
        this.sendKeyExchangeInit();
        block8: while (this.state.getValue() != 5) {
            SshMessage sshMessage = this.processMessages();
            switch (sshMessage.getMessageId()) {
                case 20: {
                    this.a((SshMsgKexInit)sshMessage);
                    continue block8;
                }
                case 1: {
                    this.a((SshMsgDisconnect)sshMessage);
                    continue block8;
                }
                case 2: {
                    this.a((SshMsgIgnore)sshMessage);
                    continue block8;
                }
                case 53: {
                    this.a((SshMsgUserAuthBanner)sshMessage);
                    continue block8;
                }
                case 3: {
                    this.a((SshMsgUnimplemented)sshMessage);
                    continue block8;
                }
                case 4: {
                    this.a((SshMsgDebug)sshMessage);
                    continue block8;
                }
            }
            this.onMessageReceived(sshMessage);
        }
    }

    public final void stop() {
        log.debug("stop() called");
        this.onDisconnect();
        Iterator iterator = this.n.iterator();
        while (iterator.hasNext()) {
            TransportProtocolEventHandler transportProtocolEventHandler = (TransportProtocolEventHandler)iterator.next();
            transportProtocolEventHandler.onDisconnect(this);
        }
        if (this.messageStore != null) {
            this.messageStore.close();
        }
        iterator = this.z.iterator();
        while (iterator != null && iterator.hasNext()) {
            SshMessageStore sshMessageStore = (SshMessageStore)iterator.next();
            try {
                sshMessageStore.close();
            }
            catch (Exception exception) {}
        }
        this.z.clear();
        this.messageStore = null;
        try {
            this.r.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] a(char c2) throws IOException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byte[] byArray = null;
            Hash hash = new Hash("SHA");
            hash.putBigInteger(this.k);
            hash.putBytes(this.m);
            hash.putByte((byte)c2);
            hash.putBytes(this.sessionIdentifier);
            byArray = hash.doFinal();
            byteArrayWriter.write(byArray);
            hash.reset();
            hash.putBigInteger(this.k);
            hash.putBytes(this.m);
            hash.putBytes(byArray);
            byArray = hash.doFinal();
            byteArrayWriter.write(byArray);
            return byteArrayWriter.toByteArray();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            log.debug("makeSshKey()", noSuchProviderException);
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("Unknown provider", noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.debug("makeSshKey()", noSuchAlgorithmException);
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("SHA algorithm not supported", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            log.debug("makeSshKey()", iOException);
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("Error writing key data", iOException);
        }
    }

    private void a() throws IOException {
        String string;
        String string2 = "";
        log.debug("Negotiating protocol version");
        log.debug("Local identification: " + this.getLocalId());
        String string3 = this.getLocalId() + "\r\n";
        this.r.getOutputStream().write(string3.getBytes());
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 255;
        while (!string2.startsWith(i) && stringBuffer.length() < n3 && n2 != -1) {
            while ((n2 = this.r.getInputStream().read()) != -1 && stringBuffer.length() < n3 && n2 != 10) {
                stringBuffer.append((char)n2);
            }
            string2 = stringBuffer.toString();
            stringBuffer = new StringBuffer();
            log.debug("Read: '" + string2 + "'");
            if (!string2.startsWith(i)) continue;
            if (string2.endsWith("\r")) {
                this.y = 1;
                string2 = string2.substring(0, string2.length() - 1);
            } else {
                this.y = 2;
            }
            log.debug("EOL is guessed at " + (this.y == 1 ? "CR+LF" : "LF"));
        }
        if (!string2.startsWith(i)) {
            log.fatal("The remote computer does not appear to support the SSH protocol: '" + string2 + "'");
            throw new TransportProtocolException("The remote computer does not appear to support the SSH protocol");
        }
        int n4 = string2.indexOf("-");
        int n5 = string2.indexOf("-", n4 + 1);
        this.setRemoteIdent(string2);
        if (log.isDebugEnabled()) {
            log.debug("Remote identification: '" + this.getRemoteId() + "'");
        }
        if (!(string = string2.substring(n4 + 1, n5)).equals(PROTOCOL_VERSION) && !string.equals("1.99")) {
            log.fatal("The remote computer does not support protocol version 2.0");
            throw new TransportProtocolException("The protocol version of the remote computer is not supported!");
        }
        log.debug("Protocol negotiation complete");
    }

    private void a(SshMsgDebug sshMsgDebug) {
        log.debug(sshMsgDebug.getMessage());
    }

    private void a(SshMsgDisconnect sshMsgDisconnect) throws IOException {
        log.debug("The remote computer disconnected: " + sshMsgDisconnect.getDescription());
        this.state.setValue(5);
        this.state.setDisconnectReason(sshMsgDisconnect.getDescription());
        this.stop();
    }

    private void a(SshMsgIgnore sshMsgIgnore) {
    }

    private void a(SshMsgUserAuthBanner sshMsgUserAuthBanner) {
        this.A = sshMsgUserAuthBanner.getBanner();
        log.debug("Received auth banner '" + this.A + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(SshMsgKexInit sshMsgKexInit) throws IOException {
        log.debug("Received " + sshMsgKexInit.toString());
        Object object = this.q;
        synchronized (object) {
            this.setRemoteKexInit(sshMsgKexInit);
            if (this.state.getValue() != 3) {
                this.sendKeyExchangeInit();
            }
            this.beginKeyExchange();
        }
    }

    private void a(SshMsgUnimplemented sshMsgUnimplemented) {
        if (log.isDebugEnabled()) {
            log.debug("The message with sequence no " + sshMsgUnimplemented.getSequenceNo() + " was reported as unimplemented by the remote end.");
        }
    }

    public SshMessage readMessage(int[] filter) throws IOException {
        byte[] byArray = null;
        block6: while (this.state.getValue() != 5) {
            SshMessage sshMessage;
            boolean bl = false;
            while (!bl) {
                byArray = this.sshIn.c();
                bl = true;
            }
            Integer n2 = SshMessage.getMessageId(byArray);
            for (int i2 = 0; i2 < filter.length; ++i2) {
                if (filter[i2] != n2) continue;
                if (this.messageStore.isRegisteredMessage(n2)) {
                    sshMessage = this.messageStore.createMessage(byArray);
                    if (log.isEnabledFor(Level.ALL)) {
                        log.log(Level.ALL, "Received registered message: " + sshMessage.toString(), null);
                    } else if (log.isDebugEnabled()) {
                        log.debug("Received registered message: " + sshMessage.getMessageName());
                    }
                    return sshMessage;
                }
                SshMessageStore sshMessageStore = this.a(n2);
                sshMessage = sshMessageStore.createMessage(byArray);
                if (log.isEnabledFor(Level.ALL)) {
                    log.log(Level.ALL, "Received unregistered message: " + sshMessage.toString(), null);
                } else if (log.isDebugEnabled()) {
                    log.debug("Received unregistered message: " + sshMessage.getMessageName());
                }
                return sshMessage;
            }
            if (this.messageStore.isRegisteredMessage(n2)) {
                sshMessage = this.messageStore.createMessage(byArray);
                if (log.isEnabledFor(Level.ALL)) {
                    log.log(Level.ALL, "Received registered message: " + sshMessage.toString(), null);
                } else if (log.isDebugEnabled()) {
                    log.debug("Received registered message: " + sshMessage.getMessageName());
                }
                switch (n2) {
                    case 1: {
                        this.a((SshMsgDisconnect)sshMessage);
                        continue block6;
                    }
                    case 2: {
                        this.a((SshMsgIgnore)sshMessage);
                        continue block6;
                    }
                    case 3: {
                        this.a((SshMsgUnimplemented)sshMessage);
                        continue block6;
                    }
                    case 4: {
                        this.a((SshMsgDebug)sshMessage);
                        continue block6;
                    }
                }
                throw new IOException("Unexpected transport protocol message");
            }
            throw new IOException("Unexpected message received");
        }
        return null;
    }

    protected SshMessage processMessages() throws IOException {
        byte[] byArray = null;
        while (this.state.getValue() != 5) {
            SshMessage sshMessage;
            long l2 = System.currentTimeMillis();
            long l3 = this.sshIn.b() + this.sshOut.a();
            long l4 = l3 - this.w;
            long l5 = l2 - this.v;
            if (l5 > this.t || l4 > this.u) {
                if (this.x) {
                    this.v = l2;
                    this.w = l3;
                    if (log.isInfoEnabled()) {
                        log.info("rekeying after " + l3 + " bytes");
                    }
                    this.sendKeyExchangeInit();
                } else {
                    log.info("rekeying disabled");
                }
            }
            boolean bl = false;
            while (!bl) {
                try {
                    byArray = this.sshIn.c();
                    bl = true;
                }
                catch (InterruptedIOException interruptedIOException) {
                    log.debug("Timeout on transport inputstream");
                    Iterator iterator = this.n.iterator();
                    while (iterator.hasNext()) {
                        TransportProtocolEventHandler transportProtocolEventHandler = (TransportProtocolEventHandler)iterator.next();
                        transportProtocolEventHandler.onSocketTimeout(this);
                    }
                    throw interruptedIOException;
                }
            }
            Integer n2 = SshMessage.getMessageId(byArray);
            if (!this.messageStore.isRegisteredMessage(n2)) {
                try {
                    SshMessageStore sshMessageStore = this.a(n2);
                    sshMessage = sshMessageStore.createMessage(byArray);
                    if (log.isEnabledFor(Level.ALL)) {
                        log.log(Level.ALL, "Received unregistered message: " + sshMessage.toString(), null);
                    } else if (log.isDebugEnabled()) {
                        log.debug("Received unregistered message: " + sshMessage.getMessageName());
                    }
                    sshMessageStore.addMessage(sshMessage);
                }
                catch (MessageNotRegisteredException messageNotRegisteredException) {
                    log.debug("Unimplemented message received " + String.valueOf(n2));
                    sshMessage = new SshMsgUnimplemented(this.sshIn.a());
                    this.sendMessage(sshMessage, this);
                }
                continue;
            }
            sshMessage = this.messageStore.createMessage(byArray);
            if (log.isEnabledFor(Level.ALL)) {
                log.log(Level.ALL, "Received registered message: " + sshMessage.toString(), null);
            } else if (log.isDebugEnabled()) {
                log.debug("Received registered message: " + sshMessage.getMessageName());
            }
            return sshMessage;
        }
        throw new IOException("The transport protocol has disconnected");
    }

    public void addMessageStore(SshMessageStore store) throws MessageAlreadyRegisteredException {
        this.z.add(store);
    }

    private SshMessageStore a(Integer n2) throws MessageNotRegisteredException {
        Iterator iterator = this.z.iterator();
        while (iterator != null && iterator.hasNext()) {
            SshMessageStore sshMessageStore = (SshMessageStore)iterator.next();
            if (!sshMessageStore.isRegisteredMessage(n2)) continue;
            return sshMessageStore;
        }
        throw new MessageNotRegisteredException(n2);
    }

    public void removeMessageStore(SshMessageStore ms) {
        this.z.remove(ms);
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

