/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.j2ssh.configuration.ConfigurationLoader;
import com.enterprisedt.net.j2ssh.configuration.SshConnectionProperties;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;

public class SshMsgKexInit
extends SshMessage {
    private static Logger a = Logger.getLogger("SshMsgKexInit");
    protected static final int SSH_MSG_KEX_INIT = 20;
    private String b;
    private String c;
    private String d;
    private String e;
    private String f;
    private String g;
    private String h;
    private String i;
    private String j;
    private String k;
    private byte[] l;
    private boolean m;
    private byte[] n;

    public SshMsgKexInit() {
        super(20);
    }

    public SshMsgKexInit(SshConnectionProperties props) {
        super(20);
        this.l = new byte[16];
        SecureRandom secureRandom = ConfigurationLoader.getRND();
        ((Random)secureRandom).nextBytes(this.l);
        this.f = this.createDelimString(props.getKeyExchangeFactory().getEnabledKeyExchanges());
        this.k = this.createDelimString(props.getKeyPairFactory().getEnabledKeyPairs());
        this.d = this.createDelimString(props.getCipherFactory().getEnabledCiphers());
        this.e = this.createDelimString(props.getCipherFactory().getEnabledCiphers());
        this.i = this.createDelimString(props.getHmacFactory().getEnabledMacs());
        this.j = this.createDelimString(props.getHmacFactory().getEnabledMacs());
        this.b = this.createDelimString(props.getCompressionFactory().getEnabledCompressions());
        this.c = this.createDelimString(props.getCompressionFactory().getEnabledCompressions());
        this.g = "";
        this.h = "";
        this.m = false;
    }

    public String getMessageName() {
        return "SSH_MSG_KEX_INIT";
    }

    public List getSupportedCSComp() {
        return this.a(this.b);
    }

    public List getSupportedCSEncryption() {
        return this.a(this.d);
    }

    public List getSupportedCSMac() {
        return this.a(this.i);
    }

    public List getSupportedKex() {
        return this.a(this.f);
    }

    public void setSupportedPK(List pks) {
        this.k = this.createDelimString(pks);
    }

    public List getSupportedPublicKeys() {
        return this.a(this.k);
    }

    public List getSupportedSCComp() {
        return this.a(this.c);
    }

    public List getSupportedSCEncryption() {
        return this.a(this.e);
    }

    public List getSupportedSCMac() {
        return this.a(this.j);
    }

    public String createDelimString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append((String)iterator.next());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = super.toString() + "\n";
        string = string + "Supported Kex " + this.f.toString() + "\n";
        string = string + "Supported Public Keys " + this.k.toString() + "\n";
        string = string + "Supported Encryption Client->Server " + this.d.toString() + "\n";
        string = string + "Supported Encryption Server->Client " + this.e.toString() + "\n";
        string = string + "Supported Mac Client->Server " + this.i.toString() + "\n";
        string = string + "Supported Mac Server->Client " + this.j.toString() + "\n";
        string = string + "Supported Compression Client->Server " + this.b.toString() + "\n";
        string = string + "Supported Compression Server->Client " + this.c.toString() + "\n";
        string = string + "Supported Languages Client->Server " + this.g.toString() + "\n";
        string = string + "Supported Languages Server->Client " + this.h.toString() + "\n";
        string = string + "First Kex Packet Follows [" + (this.m ? "TRUE]" : "FALSE]");
        return string;
    }

    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.write(this.l);
            baw.writeString(this.f);
            baw.writeString(this.k);
            baw.writeString(this.d);
            baw.writeString(this.e);
            baw.writeString(this.i);
            baw.writeString(this.j);
            baw.writeString(this.b);
            baw.writeString(this.c);
            baw.writeString(this.g);
            baw.writeString(this.h);
            baw.write(this.m ? 1 : 0);
            baw.writeInt(0);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Error writing message data", iOException);
        }
    }

    public void fromByteArray(ByteArrayReader data) throws InvalidMessageException {
        int n2;
        try {
            int n3 = (int)data.readInt();
            n2 = data.read();
            if (a.isDebugEnabled()) {
                a.debug("Packetlength=" + n3 + ", Paddinglength=" + n2);
            }
            this.n = new byte[n3 - n2 - 1];
            data.read(this.n);
        }
        catch (IOException iOException) {
            a.error("Failed to read payload", iOException);
            throw new InvalidMessageException("Failed to read payload: " + iOException.getMessage());
        }
        ByteArrayReader byteArrayReader = new ByteArrayReader(this.n);
        n2 = byteArrayReader.read();
        if (n2 != this.messageId) {
            throw new InvalidMessageException("The message id " + String.valueOf(n2) + " is not the same as the message implementation id " + String.valueOf(this.messageId));
        }
        this.constructMessage(byteArrayReader);
    }

    public byte[] getPayload() {
        return this.n;
    }

    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.l = new byte[16];
            bar.read(this.l);
            this.f = bar.readString();
            this.k = bar.readString();
            this.d = bar.readString();
            this.e = bar.readString();
            this.i = bar.readString();
            this.j = bar.readString();
            this.b = bar.readString();
            this.c = bar.readString();
            this.g = bar.readString();
            this.h = bar.readString();
            this.m = bar.read() != 0;
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Error reading message data", iOException);
        }
    }

    private List a(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(stringTokenizer.nextElement());
        }
        if (string.endsWith(",")) {
            arrayList.add("");
        }
        return arrayList;
    }
}

