/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.sftp;

import com.enterprisedt.net.ftp.DirectoryListArgument;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger32;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger64;
import com.enterprisedt.net.j2ssh.sftp.DirectoryListCallback;
import com.enterprisedt.net.j2ssh.sftp.FileAttributes;
import com.enterprisedt.net.j2ssh.sftp.SftpFile;
import com.enterprisedt.net.j2ssh.sftp.SshFxpAttrs;
import com.enterprisedt.net.j2ssh.sftp.SshFxpClose;
import com.enterprisedt.net.j2ssh.sftp.SshFxpData;
import com.enterprisedt.net.j2ssh.sftp.SshFxpFSetStat;
import com.enterprisedt.net.j2ssh.sftp.SshFxpFStat;
import com.enterprisedt.net.j2ssh.sftp.SshFxpHandle;
import com.enterprisedt.net.j2ssh.sftp.SshFxpInit;
import com.enterprisedt.net.j2ssh.sftp.SshFxpMkdir;
import com.enterprisedt.net.j2ssh.sftp.SshFxpName;
import com.enterprisedt.net.j2ssh.sftp.SshFxpOpen;
import com.enterprisedt.net.j2ssh.sftp.SshFxpOpenDir;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRead;
import com.enterprisedt.net.j2ssh.sftp.SshFxpReadDir;
import com.enterprisedt.net.j2ssh.sftp.SshFxpReadlink;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRealPath;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRemove;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRename;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRmdir;
import com.enterprisedt.net.j2ssh.sftp.SshFxpSetStat;
import com.enterprisedt.net.j2ssh.sftp.SshFxpStat;
import com.enterprisedt.net.j2ssh.sftp.SshFxpStatus;
import com.enterprisedt.net.j2ssh.sftp.SshFxpSymlink;
import com.enterprisedt.net.j2ssh.sftp.SshFxpVersion;
import com.enterprisedt.net.j2ssh.sftp.SshFxpWrite;
import com.enterprisedt.net.j2ssh.sftp.b;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemChannel;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemMessage;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.transport.MessageNotAvailableException;
import com.enterprisedt.net.j2ssh.transport.MessageStoreEOFException;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class SftpSubsystemClient
extends SubsystemChannel {
    public static final int OPEN_READ = 1;
    public static final int OPEN_WRITE = 2;
    public static final int OPEN_APPEND = 4;
    public static final int OPEN_CREATE = 8;
    public static final int OPEN_TRUNCATE = 16;
    public static final int OPEN_EXCLUSIVE = 32;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static Logger k = Logger.getLogger("SftpSubsystemClient");
    private List l = new Vector();
    private UnsignedInteger32 m = new UnsignedInteger32(1L);
    private int n = 3;
    private b o = (b)this.messageStore;
    private String p = "UTF-8";
    private String q = "test -x /usr/lib/sftp-server && exec /usr/lib/sftp-server\ntest -x /usr/local/lib/sftp-server && exec /usr/local/lib/sftp-server\nexec sftp-server";
    private boolean r = true;
    static Class a;
    static Class b;
    static Class c;
    static Class d;
    static Class e;
    static Class f;

    public SftpSubsystemClient() {
        super("sftp", new b());
        this.b();
    }

    public void setControlEncoding(String controlEncoding) {
        this.o.a(controlEncoding);
        this.p = controlEncoding;
        k.info("Using control encoding: " + controlEncoding);
    }

    public void setServerResponseTimeout(long serverResponseTimeout) {
        this.o.a(serverResponseTimeout);
    }

    protected byte[] toByteArray(SubsystemMessage msg) throws InvalidMessageException {
        return msg.toByteArray(this.p);
    }

    public String getName() {
        return "sftp";
    }

    protected long availableRemoteWindowSpace() {
        return this.getRemoteWindow().getWindowSpace();
    }

    protected void waitForRemoteWindowSpace(int count) throws IOException {
        this.getRemoteWindow().waitForWindowSpace(count);
    }

    protected long maximumRemotePacketSize() {
        return this.getRemotePacketSize();
    }

    public synchronized void closeHandle(byte[] handle) throws IOException {
        if (!this.isValidHandle(handle)) {
            throw new IOException("The handle is invalid!");
        }
        this.l.remove(handle);
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpClose sshFxpClose = new SshFxpClose(unsignedInteger32, handle);
        this.sendMessage(sshFxpClose);
        try {
            this.getOKRequestStatus(unsignedInteger32);
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
    }

    public void closeFile(SftpFile file) throws IOException {
        k.debug("Closing file " + file.getAbsolutePath());
        this.closeHandle(file.getHandle());
    }

    protected boolean isValidHandle(byte[] handle) {
        return this.l.contains(handle);
    }

    public synchronized int listChildren(String path, byte[] handle, List children) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpReadDir sshFxpReadDir = new SshFxpReadDir(unsignedInteger32, handle);
        this.sendMessage(sshFxpReadDir);
        try {
            SubsystemMessage subsystemMessage = this.o.b(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpName) {
                SshFxpName sshFxpName = (SshFxpName)subsystemMessage;
                SftpFile[] sftpFileArray = sshFxpName.getFiles();
                for (int i2 = 0; i2 < sftpFileArray.length; ++i2) {
                    SftpFile sftpFile = new SftpFile(path + "/" + sftpFileArray[i2].getFilename(), sftpFileArray[i2].getAttributes());
                    sftpFile.setSFTPSubsystem(this);
                    children.add(sftpFile);
                }
                return sftpFileArray.length;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                if (sshFxpStatus.getErrorCode().intValue() == 1) {
                    return -1;
                }
                throw new FTPException(sshFxpStatus.getErrorMessage(), sshFxpStatus.getErrorCode().toString());
            }
            this.a(subsystemMessage);
            return -1;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    private void a(SubsystemMessage subsystemMessage) throws IOException {
        String string = "Unexpected server response " + (subsystemMessage != null ? subsystemMessage.getMessageName() : "null");
        k.error(string);
        throw new IOException(string);
    }

    public synchronized int listChildren(SftpFile file, List children, FileFilter filter, DirectoryListCallback lister) throws IOException, FTPException {
        if (!this.isValidHandle(file.getHandle())) {
            k.debug("Invalid handle - reopening directory " + file.getAbsolutePath());
            this.openDirectory(file);
            if (!this.isValidHandle(file.getHandle())) {
                throw new IOException("Failed to open directory");
            }
        }
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpReadDir sshFxpReadDir = new SshFxpReadDir(unsignedInteger32, file.getHandle());
        this.sendMessage(sshFxpReadDir);
        try {
            SubsystemMessage subsystemMessage = this.o.b(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpName) {
                SshFxpName sshFxpName = (SshFxpName)subsystemMessage;
                SftpFile[] sftpFileArray = sshFxpName.getFiles();
                for (int i2 = 0; i2 < sftpFileArray.length; ++i2) {
                    DirectoryListArgument directoryListArgument;
                    k.debug("File: '" + sftpFileArray[i2].getFilename() + "'");
                    if (filter != null && !filter.accept(new File(sftpFileArray[i2].getFilename()))) continue;
                    SftpFile sftpFile = new SftpFile(file.getAbsolutePath() + "/" + sftpFileArray[i2].getFilename(), sftpFileArray[i2].getAttributes());
                    sftpFile.setSFTPSubsystem(this);
                    if (lister != null && (directoryListArgument = lister.listDirectoryEntry(sftpFile)) != null && directoryListArgument.isListingAborted()) {
                        k.warn("Aborting listing");
                        return -1;
                    }
                    if (children == null) continue;
                    children.add(sftpFile);
                }
                return sftpFileArray.length;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                if (sshFxpStatus.getErrorCode().intValue() == 1) {
                    return -1;
                }
                throw new FTPException(sshFxpStatus.getErrorMessage(), sshFxpStatus.getErrorCode().toString());
            }
            this.a(subsystemMessage);
            return -1;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized void makeDirectory(String path) throws IOException, FTPException {
        String string = this.getAbsolutePath(path);
        k.debug("Make directory: " + string);
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpMkdir sshFxpMkdir = new SshFxpMkdir(unsignedInteger32, string, new FileAttributes());
        this.sendMessage(sshFxpMkdir);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public void recurseMakeDirectory(String path) throws IOException, FTPException {
        if (path.trim().length() > 0) {
            try {
                SftpFile sftpFile = this.openDirectory(path);
                sftpFile.close();
            }
            catch (FTPException fTPException) {
                StringTokenizer stringTokenizer = new StringTokenizer(path, "/", true);
                String string = "";
                while (stringTokenizer.hasMoreElements()) {
                    string = string + stringTokenizer.nextElement();
                    try {
                        SftpFile sftpFile = this.openDirectory(string);
                        sftpFile.close();
                    }
                    catch (FTPException fTPException2) {
                        k.debug("Creating " + string);
                        this.makeDirectory(string);
                    }
                }
            }
        }
    }

    protected void onChannelClose() throws IOException {
        this.o.close();
    }

    public synchronized SftpFile openDirectory(String path) throws IOException, FTPException {
        String string = this.getAbsolutePath(path);
        k.debug("Opening directory " + string);
        UnsignedInteger32 unsignedInteger32 = this.a();
        SubsystemMessage subsystemMessage = new SshFxpOpenDir(unsignedInteger32, string);
        this.sendMessage(subsystemMessage);
        byte[] byArray = this.a(unsignedInteger32);
        unsignedInteger32 = this.a();
        subsystemMessage = new SshFxpStat(unsignedInteger32, string);
        this.sendMessage(subsystemMessage);
        try {
            SubsystemMessage subsystemMessage2 = this.o.b(unsignedInteger32);
            if (subsystemMessage2 instanceof SshFxpAttrs) {
                SftpFile sftpFile = new SftpFile(string, ((SshFxpAttrs)subsystemMessage2).getAttributes());
                sftpFile.setHandle(byArray);
                sftpFile.setSFTPSubsystem(this);
                return sftpFile;
            }
            if (subsystemMessage2 instanceof SshFxpStatus) {
                throw new FTPException(((SshFxpStatus)subsystemMessage2).getErrorMessage(), ((SshFxpStatus)subsystemMessage2).getErrorCode().toString());
            }
            this.a(subsystemMessage2);
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized void openDirectory(SftpFile dir) throws IOException, FTPException {
        k.debug("Opening directory " + dir.getAbsolutePath());
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpOpenDir sshFxpOpenDir = new SshFxpOpenDir(unsignedInteger32, dir.getAbsolutePath());
        this.sendMessage(sshFxpOpenDir);
        byte[] byArray = this.a(unsignedInteger32);
        dir.setHandle(byArray);
    }

    public String getDefaultDirectory() throws IOException, FTPException {
        return this.getAbsolutePath("");
    }

    public synchronized String getAbsolutePath(String path) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpRealPath sshFxpRealPath = new SshFxpRealPath(unsignedInteger32, path);
        this.sendMessage(sshFxpRealPath);
        try {
            SubsystemMessage subsystemMessage = this.o.b(unsignedInteger32);
            if (subsystemMessage == null) {
                throw new IOException("Null response to FXP_REAL_PATH");
            }
            if (subsystemMessage instanceof SshFxpName) {
                SftpFile[] sftpFileArray = ((SshFxpName)subsystemMessage).getFiles();
                String string = "Server responded to SSH_FXP_REALPATH with too many files";
                if (sftpFileArray.length != 1) {
                    k.warn(string);
                    return path;
                }
                return sftpFileArray[0].getAbsolutePath();
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                k.warn("getAbsolutePath: " + sshFxpStatus.getErrorMessage());
                return path;
            }
            this.a(subsystemMessage);
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public String getAbsolutePath(SftpFile file) throws IOException, FTPException {
        return this.getAbsolutePath(file.getFilename());
    }

    public SftpFile openFile(String filename, int flags) throws IOException, FTPException {
        return this.openFile(filename, flags, null);
    }

    public synchronized SftpFile openFile(String absolutePath, int flags, FileAttributes attrs) throws IOException, FTPException {
        if (attrs == null) {
            attrs = new FileAttributes();
        }
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpOpen sshFxpOpen = new SshFxpOpen(unsignedInteger32, absolutePath, new UnsignedInteger32(flags), attrs);
        this.sendMessage(sshFxpOpen);
        byte[] byArray = this.a(unsignedInteger32);
        SftpFile sftpFile = new SftpFile(absolutePath, null);
        sftpFile.setHandle(byArray);
        sftpFile.setSFTPSubsystem(this);
        return sftpFile;
    }

    public synchronized FileAttributes getAttributes(String path) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpStat sshFxpStat = new SshFxpStat(unsignedInteger32, path);
        this.sendMessage(sshFxpStat);
        try {
            SubsystemMessage subsystemMessage = this.o.b(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpAttrs) {
                return ((SshFxpAttrs)subsystemMessage).getAttributes();
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                throw new FTPException(sshFxpStatus.getErrorMessage() + " : " + path, sshFxpStatus.getErrorCode().toString());
            }
            if (this.getState().getValue() != 1) {
                throw new IOException("Connection closed unexpectedly.");
            }
            this.a(subsystemMessage);
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    public synchronized FileAttributes getAttributes(SftpFile file) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SubsystemMessage subsystemMessage = !this.isValidHandle(file.getHandle()) ? new SshFxpStat(unsignedInteger32, file.getAbsolutePath()) : new SshFxpFStat(unsignedInteger32, file.getHandle());
        this.sendMessage(subsystemMessage);
        try {
            SubsystemMessage subsystemMessage2 = this.o.b(unsignedInteger32);
            if (subsystemMessage2 instanceof SshFxpAttrs) {
                return ((SshFxpAttrs)subsystemMessage2).getAttributes();
            }
            if (subsystemMessage2 instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage2;
                throw new FTPException(sshFxpStatus.getErrorMessage() + " : " + file.getAbsolutePath(), sshFxpStatus.getErrorCode().toString());
            }
            this.a(subsystemMessage2);
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    protected synchronized int readFile(byte[] handle, UnsignedInteger64 offset, byte[] output, int off, int len) throws IOException {
        if (!this.l.contains(handle)) {
            throw new IOException("The file handle is invalid!");
        }
        if (output.length - off < len) {
            throw new IOException("Output array size is smaller than read length!");
        }
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpRead sshFxpRead = new SshFxpRead(unsignedInteger32, handle, offset, new UnsignedInteger32(len));
        this.sendMessage(sshFxpRead);
        try {
            SubsystemMessage subsystemMessage = this.o.b(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpData) {
                byte[] byArray = ((SshFxpData)subsystemMessage).getData();
                System.arraycopy(byArray, 0, output, off, byArray.length);
                return byArray.length;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                if (sshFxpStatus.getErrorCode().intValue() == 1) {
                    return -1;
                }
                k.error("readFile failed: " + sshFxpStatus.getErrorMessage());
                throw new IOException(sshFxpStatus.getErrorMessage());
            }
            this.a(subsystemMessage);
            return -1;
        }
        catch (InterruptedException interruptedException) {
            String string = "readFile: interrupted";
            k.error(string);
            throw new IOException(string);
        }
    }

    public synchronized void removeDirectory(String path) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpRmdir sshFxpRmdir = new SshFxpRmdir(unsignedInteger32, path);
        this.sendMessage(sshFxpRmdir);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public synchronized void removeFile(String filename) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpRemove sshFxpRemove = new SshFxpRemove(unsignedInteger32, filename);
        this.sendMessage(sshFxpRemove);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public synchronized void renameFile(String oldpath, String newpath) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpRename sshFxpRename = new SshFxpRename(unsignedInteger32, oldpath, newpath);
        this.sendMessage(sshFxpRename);
        this.getOKRequestStatus(unsignedInteger32);
    }

    protected synchronized void writeFile(byte[] handle, UnsignedInteger64 offset, byte[] data, int off, int len) throws IOException {
        if (!this.l.contains(handle)) {
            throw new IOException("The handle is not valid!");
        }
        if (data.length - off < len) {
            throw new IOException("Incorrect data array size!");
        }
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpWrite sshFxpWrite = new SshFxpWrite(unsignedInteger32, handle, offset, data, off, len);
        this.sendMessage(sshFxpWrite);
        try {
            this.getOKRequestStatus(unsignedInteger32);
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
    }

    protected synchronized UnsignedInteger32 writeFileAsync(byte[] handle, UnsignedInteger64 offset, byte[] data, int off, int len) throws IOException {
        if (!this.l.contains(handle)) {
            throw new IOException("The handle is not valid!");
        }
        if (data.length - off < len) {
            throw new IOException("Incorrect data array size!");
        }
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpWrite sshFxpWrite = new SshFxpWrite(unsignedInteger32, handle, offset, data, off, len);
        this.sendMessage(sshFxpWrite);
        return unsignedInteger32;
    }

    public synchronized void createSymbolicLink(String targetpath, String linkpath) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpSymlink sshFxpSymlink = new SshFxpSymlink(unsignedInteger32, targetpath, linkpath);
        this.sendMessage(sshFxpSymlink);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public synchronized String getSymbolicLinkTarget(String linkpath) throws IOException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpReadlink sshFxpReadlink = new SshFxpReadlink(unsignedInteger32, linkpath);
        this.sendMessage(sshFxpReadlink);
        try {
            SubsystemMessage subsystemMessage = this.o.b(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpName) {
                SftpFile[] sftpFileArray = ((SshFxpName)subsystemMessage).getFiles();
                if (sftpFileArray.length != 1) {
                    throw new IOException("Server responded to SSH_FXP_REALLINK with too many files!");
                }
                return sftpFileArray[0].getAbsolutePath();
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                throw new IOException(((SshFxpStatus)subsystemMessage).getErrorMessage());
            }
            this.a(subsystemMessage);
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized void setAttributes(String path, FileAttributes attrs) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpSetStat sshFxpSetStat = new SshFxpSetStat(unsignedInteger32, path, attrs);
        this.sendMessage(sshFxpSetStat);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public synchronized void setAttributes(SftpFile file, FileAttributes attrs) throws IOException, FTPException {
        if (!this.isValidHandle(file.getHandle())) {
            throw new IOException("The handle is not an open file handle!");
        }
        UnsignedInteger32 unsignedInteger32 = this.a();
        SshFxpFSetStat sshFxpFSetStat = new SshFxpFSetStat(unsignedInteger32, file.getHandle(), attrs);
        this.sendMessage(sshFxpFSetStat);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public void changePermissions(SftpFile file, String permissions) throws IOException, FTPException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(permissions);
        this.setAttributes(file, fileAttributes);
    }

    public void changePermissions(SftpFile file, int permissions) throws IOException, FTPException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(new UnsignedInteger32(permissions));
        this.setAttributes(file, fileAttributes);
    }

    public void changePermissions(String filename, int permissions) throws IOException, FTPException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(new UnsignedInteger32(permissions));
        this.setAttributes(filename, fileAttributes);
    }

    public void changePermissions(String filename, String permissions) throws IOException, FTPException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(permissions);
        this.setAttributes(filename, fileAttributes);
    }

    public synchronized boolean initialize(String sftpSubsystemPath) throws IOException {
        Object object;
        k.debug("Initializing SFTP protocol version " + String.valueOf(this.n));
        boolean bl = true;
        if (sftpSubsystemPath == null) {
            bl = this.startSubsystem();
        } else {
            k.debug("SFTP command is " + sftpSubsystemPath);
            object = new ByteArrayWriter();
            ((ByteArrayWriter)object).writeString(sftpSubsystemPath);
            if (!this.connection.sendChannelRequest(this, "exec", true, ((ByteArrayOutputStream)object).toByteArray())) {
                bl = false;
            }
        }
        if (!bl) {
            k.debug("Opening SFTP subsystem failed: trying fallback");
            object = new ByteArrayWriter();
            ((ByteArrayWriter)object).writeString(this.q);
            if (!this.connection.sendChannelRequest(this, "exec", true, ((ByteArrayOutputStream)object).toByteArray())) {
                return false;
            }
        }
        bl = false;
        object = new SshFxpInit(new UnsignedInteger32(this.n), null);
        this.sendMessage((SubsystemMessage)object);
        SubsystemMessage subsystemMessage = null;
        for (int i2 = 0; i2 < 300; ++i2) {
            try {
                subsystemMessage = this.o.nextMessage(100);
                k.debug("Received reply to init msg");
                break;
            }
            catch (MessageNotAvailableException messageNotAvailableException) {
                k.debug("Timed out attempt #" + i2);
            }
            catch (MessageStoreEOFException messageStoreEOFException) {
                k.error("Failed to retrieve reply");
                return false;
            }
            if (this.getState().getValue() == 2) continue;
            k.error("State is not CHANNEL_OPEN - initialize failed");
            return false;
        }
        if (subsystemMessage instanceof SshFxpVersion) {
            bl = true;
            this.n = ((SshFxpVersion)subsystemMessage).getVersion().intValue();
            k.debug("Server responded with version " + String.valueOf(this.n));
        }
        return bl;
    }

    private byte[] a(UnsignedInteger32 unsignedInteger32) throws IOException, FTPException {
        try {
            SubsystemMessage subsystemMessage = this.o.b(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpHandle) {
                byte[] byArray = ((SshFxpHandle)subsystemMessage).getHandle();
                this.l.add(byArray);
                return byArray;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                throw new FTPException(((SshFxpStatus)subsystemMessage).getErrorMessage(), ((SshFxpStatus)subsystemMessage).getErrorCode().toString());
            }
            this.a(subsystemMessage);
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public void getOKRequestStatus(UnsignedInteger32 requestId) throws IOException, FTPException {
        try {
            if (k.isDebugEnabled()) {
                k.debug("Waiting for response");
            }
            SubsystemMessage subsystemMessage = this.o.b(requestId);
            k.debug("Received response");
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                int n2 = sshFxpStatus.getErrorCode().intValue();
                if (n2 != 0) {
                    throw new FTPException(sshFxpStatus.getErrorMessage(), sshFxpStatus.getErrorCode().toString());
                }
            } else {
                this.a(subsystemMessage);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public boolean getOKRequestStatusAsync(UnsignedInteger32 requestId) throws IOException {
        try {
            SubsystemMessage subsystemMessage = this.o.a(requestId);
            if (subsystemMessage == null) {
                return false;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                int n2 = sshFxpStatus.getErrorCode().intValue();
                if (n2 != 0) {
                    throw new IOException(sshFxpStatus.getErrorMessage());
                }
                return true;
            }
            this.a(subsystemMessage);
            return true;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    private UnsignedInteger32 a() {
        this.m = UnsignedInteger32.add(this.m, 1);
        return this.m;
    }

    private void b() {
        this.o.registerMessage(2, a == null ? (a = SftpSubsystemClient.class$("com.enterprisedt.net.j2ssh.sftp.SshFxpVersion")) : a);
        this.o.registerMessage(105, b == null ? (b = SftpSubsystemClient.class$("com.enterprisedt.net.j2ssh.sftp.SshFxpAttrs")) : b);
        this.o.registerMessage(103, c == null ? (c = SftpSubsystemClient.class$("com.enterprisedt.net.j2ssh.sftp.SshFxpData")) : c);
        this.o.registerMessage(102, d == null ? (d = SftpSubsystemClient.class$("com.enterprisedt.net.j2ssh.sftp.SshFxpHandle")) : d);
        this.o.registerMessage(101, e == null ? (e = SftpSubsystemClient.class$("com.enterprisedt.net.j2ssh.sftp.SshFxpStatus")) : e);
        this.o.registerMessage(104, f == null ? (f = SftpSubsystemClient.class$("com.enterprisedt.net.j2ssh.sftp.SshFxpName")) : f);
    }

    protected int getMinimumWindowSpace() {
        return 1024;
    }

    protected int getMaximumWindowSpace() {
        return 131070;
    }

    protected int getMaximumPacketSize() {
        return 65535;
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

