/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.sftp;

import com.enterprisedt.net.j2ssh.io.UnsignedInteger64;
import com.enterprisedt.net.j2ssh.sftp.SftpFile;
import java.io.IOException;
import java.io.InputStream;

public class SftpFileInputStream
extends InputStream {
    SftpFile a;
    UnsignedInteger64 b = new UnsignedInteger64("0");

    public SftpFileInputStream(SftpFile file) throws IOException {
        if (file.getHandle() == null) {
            throw new IOException("The file does not have a valid handle!");
        }
        if (file.getSFTPSubsystem() == null) {
            throw new IOException("The file is not attached to an SFTP subsystem!");
        }
        this.a = file;
    }

    public long skip(long n2) throws IOException {
        if (n2 < 0L) {
            throw new IOException("Invalid skip value (" + n2 + ")");
        }
        this.b = UnsignedInteger64.add(this.b, n2);
        return n2;
    }

    public int read(byte[] buffer, int offset, int len) throws IOException {
        int n2 = this.a.getSFTPSubsystem().readFile(this.a.getHandle(), this.b, buffer, offset, len);
        if (n2 > 0) {
            this.b = UnsignedInteger64.add(this.b, n2);
        }
        return n2;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n2 = this.a.getSFTPSubsystem().readFile(this.a.getHandle(), this.b, byArray, 0, 1);
        this.b = UnsignedInteger64.add(this.b, n2);
        return byArray[0] & 0xFF;
    }

    public void close() throws IOException {
        this.a.close();
    }

    protected void finalize() throws IOException {
        if (this.a.getHandle() != null) {
            this.close();
        }
    }
}

