/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.sftp;

import com.enterprisedt.net.j2ssh.sftp.FileAttributes;
import com.enterprisedt.net.j2ssh.sftp.SftpSubsystemClient;
import java.io.IOException;

public class SftpFile
implements Comparable {
    private String a;
    private byte[] b;
    private FileAttributes c;
    private SftpSubsystemClient d;
    private String e;

    public SftpFile(String absolutePath, FileAttributes attrs, SftpSubsystemClient sftp) {
        this(absolutePath, attrs);
        this.d = sftp;
    }

    public SftpFile(String absolutePath, FileAttributes attrs) {
        this.e = absolutePath;
        int n2 = absolutePath.lastIndexOf("/");
        this.a = n2 > -1 ? absolutePath.substring(n2 + 1) : absolutePath;
        this.c = attrs;
    }

    public SftpFile(String absolutePath) {
        this(absolutePath, new FileAttributes());
    }

    public boolean canWrite() {
        return (this.getAttributes().getPermissions().longValue() & 0x80L) == 128L;
    }

    public boolean canRead() {
        return (this.getAttributes().getPermissions().longValue() & 0x100L) == 256L;
    }

    public boolean isOpen() {
        if (this.d == null) {
            return false;
        }
        return this.d.isValidHandle(this.b);
    }

    protected void setHandle(byte[] handle) {
        this.b = handle;
    }

    public byte[] getHandle() {
        return this.b;
    }

    protected void setSFTPSubsystem(SftpSubsystemClient sftp) {
        this.d = sftp;
    }

    protected SftpSubsystemClient getSFTPSubsystem() {
        return this.d;
    }

    public String getFilename() {
        return this.a;
    }

    private String a(int n2) {
        String string = "";
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                string = string + " ";
            }
        }
        return string;
    }

    public String getLongname() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.a(10 - this.getAttributes().getPermissionsString().length()) + this.getAttributes().getPermissionsString());
        stringBuffer.append("   1 ");
        stringBuffer.append(this.getAttributes().getUID().toString() + this.a(8 - this.getAttributes().getUID().toString().length()));
        stringBuffer.append(" ");
        stringBuffer.append(this.getAttributes().getGID().toString() + this.a(8 - this.getAttributes().getGID().toString().length()));
        stringBuffer.append(" ");
        stringBuffer.append(this.a(8 - this.getAttributes().getSize().toString().length()) + this.getAttributes().getSize().toString());
        stringBuffer.append(" ");
        stringBuffer.append(this.a(12 - this.getAttributes().getModTimeString().length()) + this.getAttributes().getModTimeString());
        stringBuffer.append(" ");
        stringBuffer.append(this.a);
        return stringBuffer.toString();
    }

    public FileAttributes getAttributes() {
        try {
            if (this.c == null) {
                this.c = this.d.getAttributes(this);
            }
        }
        catch (Exception exception) {
            this.c = new FileAttributes();
        }
        return this.c;
    }

    public String getAbsolutePath() {
        return this.e;
    }

    public void close() throws IOException {
        this.d.closeFile(this);
        this.setHandle(null);
        this.d = null;
    }

    public boolean isDirectory() {
        return (this.getAttributes().getPermissions().intValue() & 0x4000) == 16384;
    }

    public boolean isFile() {
        return (this.getAttributes().getPermissions().intValue() & 0x8000) == 32768;
    }

    public boolean isLink() {
        return (this.getAttributes().getPermissions().intValue() & 0xA000) == 40960;
    }

    public boolean isFifo() {
        return (this.getAttributes().getPermissions().intValue() & 0x1000) == 4096;
    }

    public boolean isBlock() {
        return (this.getAttributes().getPermissions().intValue() & 0x6000) == 24576;
    }

    public boolean isCharacter() {
        return (this.getAttributes().getPermissions().intValue() & 0x2000) == 8192;
    }

    public boolean isSocket() {
        return (this.getAttributes().getPermissions().intValue() & 0xC000) == 49152;
    }

    public int compareTo(Object o2) {
        return this.getFilename().compareTo(((SftpFile)o2).getFilename());
    }
}

