/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.sftp;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger32;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger64;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class FileAttributes {
    public static final int SSH_FILEXFER_TYPE_REGULAR = 1;
    public static final int SSH_FILEXFER_TYPE_DIRECTORY = 2;
    public static final int SSH_FILEXFER_TYPE_SYMLINK = 3;
    public static final int SSH_FILEXFER_TYPE_SPECIAL = 4;
    public static final long SSH_FILEXFER_TYPE_UNKNOWN = 5L;
    public static final int S_IFMT = 61440;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    int a = 3;
    long b = 0L;
    UnsignedInteger64 c = null;
    UnsignedInteger32 d = null;
    UnsignedInteger32 e = null;
    String f = null;
    String g = null;
    UnsignedInteger32 h = null;
    UnsignedInteger32 i = null;
    UnsignedInteger32 j = null;
    UnsignedInteger32 k = null;
    List l = new Vector();
    Map m = new HashMap();
    char[] n = new char[]{'p', 'c', 'd', 'b', '-', 'l', 's'};

    public FileAttributes() {
    }

    public FileAttributes(ByteArrayReader bar) throws IOException {
        this.b = bar.readInt();
        if (this.isFlagSet(1L)) {
            this.c = bar.readUINT64();
        }
        if (this.isFlagSet(2L)) {
            this.d = bar.readUINT32();
            this.e = bar.readUINT32();
        }
        if (this.isFlagSet(4L)) {
            this.h = bar.readUINT32();
        }
        if (this.isFlagSet(8L)) {
            this.i = bar.readUINT32();
            this.k = bar.readUINT32();
        }
        if (this.isFlagSet(0x80000000L)) {
            int n2 = (int)bar.readInt();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = bar.readString();
                String string2 = bar.readString();
                this.m.put(string, string2);
            }
        }
    }

    public UnsignedInteger32 getUID() {
        if (this.d != null) {
            return this.d;
        }
        return new UnsignedInteger32(0L);
    }

    public void setUID(UnsignedInteger32 uid) {
        this.b |= 2L;
        this.d = uid;
    }

    public void setGID(UnsignedInteger32 gid) {
        this.b |= 2L;
        this.e = gid;
    }

    public long getFlags() {
        return this.b;
    }

    public UnsignedInteger32 getGID() {
        if (this.e != null) {
            return this.e;
        }
        return new UnsignedInteger32(0L);
    }

    public void setSize(UnsignedInteger64 size) {
        this.c = size;
        this.b = size != null ? (this.b |= 1L) : (this.b &= 0xFFFFFFFFFFFFFFFEL);
    }

    public UnsignedInteger64 getSize() {
        if (this.c != null) {
            return this.c;
        }
        return new UnsignedInteger64("0");
    }

    public void setPermissions(UnsignedInteger32 permissions) {
        this.h = permissions;
        this.b = permissions != null ? (this.b |= 4L) : (this.b &= 0xFFFFFFFFFFFFFFFBL);
    }

    public void setPermissions(String newPermissions) {
        int n2;
        int n3 = 0;
        if (this.h != null) {
            n3 |= (this.h.intValue() & 0xF000) == 61440 ? 61440 : 0;
            n3 |= (this.h.intValue() & 0xC000) == 49152 ? 49152 : 0;
            n3 |= (this.h.intValue() & 0xA000) == 40960 ? 40960 : 0;
            n3 |= (this.h.intValue() & 0x8000) == 32768 ? 32768 : 0;
            n3 |= (this.h.intValue() & 0x6000) == 24576 ? 24576 : 0;
            n3 |= (this.h.intValue() & 0x4000) == 16384 ? 16384 : 0;
            n3 |= (this.h.intValue() & 0x2000) == 8192 ? 8192 : 0;
            n3 |= (this.h.intValue() & 0x1000) == 4096 ? 4096 : 0;
            n3 |= (this.h.intValue() & 0x800) == 2048 ? 2048 : 0;
            n3 |= (this.h.intValue() & 0x400) == 1024 ? 1024 : 0;
        }
        if ((n2 = newPermissions.length()) >= 1) {
            n3 |= newPermissions.charAt(0) == 'r' ? 256 : 0;
        }
        if (n2 >= 2) {
            n3 |= newPermissions.charAt(1) == 'w' ? 128 : 0;
        }
        if (n2 >= 3) {
            n3 |= newPermissions.charAt(2) == 'x' ? 64 : 0;
        }
        if (n2 >= 4) {
            n3 |= newPermissions.charAt(3) == 'r' ? 32 : 0;
        }
        if (n2 >= 5) {
            n3 |= newPermissions.charAt(4) == 'w' ? 16 : 0;
        }
        if (n2 >= 6) {
            n3 |= newPermissions.charAt(5) == 'x' ? 8 : 0;
        }
        if (n2 >= 7) {
            n3 |= newPermissions.charAt(6) == 'r' ? 4 : 0;
        }
        if (n2 >= 8) {
            n3 |= newPermissions.charAt(7) == 'w' ? 2 : 0;
        }
        if (n2 >= 9) {
            n3 |= newPermissions.charAt(8) == 'x' ? 1 : 0;
        }
        this.setPermissions(new UnsignedInteger32(n3));
    }

    public UnsignedInteger32 getPermissions() {
        return this.h;
    }

    public void setTimes(UnsignedInteger32 atime, UnsignedInteger32 mtime) {
        this.i = atime;
        this.k = mtime;
        this.b = atime != null ? (this.b |= 8L) : (this.b &= 0xFFFFFFFFFFFFFFF7L);
    }

    public UnsignedInteger32 getAccessedTime() {
        return this.i;
    }

    public UnsignedInteger32 getModifiedTime() {
        if (this.k != null) {
            return this.k;
        }
        return new UnsignedInteger32(0L);
    }

    public Map getExtendedAttributes() {
        return this.m;
    }

    public boolean isFlagSet(long flag) {
        return (this.b & flag) == flag;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        if (this.m.size() > 0) {
            this.b |= 0x80000000L;
        }
        byteArrayWriter.writeInt(this.b);
        if (this.isFlagSet(1L)) {
            byteArrayWriter.writeUINT64(this.c);
        }
        if (this.isFlagSet(2L)) {
            if (this.d != null) {
                byteArrayWriter.writeUINT32(this.d);
            } else {
                byteArrayWriter.writeInt(0);
            }
            if (this.e != null) {
                byteArrayWriter.writeUINT32(this.e);
            } else {
                byteArrayWriter.writeInt(0);
            }
        }
        if (this.isFlagSet(4L)) {
            byteArrayWriter.writeUINT32(this.h);
        }
        if (this.isFlagSet(8L)) {
            byteArrayWriter.writeUINT32(this.i);
            byteArrayWriter.writeUINT32(this.k);
        }
        if (this.isFlagSet(0x80000000L)) {
            byteArrayWriter.writeInt(this.m.size());
            Iterator iterator = this.m.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                byteArrayWriter.writeString((String)entry.getKey());
                byteArrayWriter.writeString((String)entry.getValue());
            }
        }
        return byteArrayWriter.toByteArray();
    }

    private int a(int n2, int n3) {
        return (((n2 >>>= n3) & 4) != 0 ? 4 : 0) + ((n2 & 2) != 0 ? 2 : 0) + ((n2 & 1) != 0 ? 1 : 0);
    }

    private String b(int n2, int n3) {
        String string = (((n2 >>>= n3) & 4) != 0 ? "r" : "-") + ((n2 & 2) != 0 ? "w" : "-");
        string = n3 == 6 && (this.h.intValue() & 0x800) == 2048 || n3 == 3 && (this.h.intValue() & 0x400) == 1024 ? string + ((n2 & 1) != 0 ? "s" : "S") : string + ((n2 & 1) != 0 ? "x" : "-");
        return string;
    }

    public String getPermissionsString() {
        if (this.h != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.n[(this.h.intValue() & 0xF000) >>> 13]);
            stringBuffer.append(this.b(this.h.intValue(), 6));
            stringBuffer.append(this.b(this.h.intValue(), 3));
            stringBuffer.append(this.b(this.h.intValue(), 0));
            return stringBuffer.toString();
        }
        return "";
    }

    public String getMaskString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('0');
        int n2 = this.h.intValue();
        stringBuffer.append(this.a(n2, 6));
        stringBuffer.append(this.a(n2, 3));
        stringBuffer.append(this.a(n2, 0));
        return stringBuffer.toString();
    }

    public String getModTimeString() {
        if (this.k == null) {
            return "";
        }
        long l2 = this.k.longValue() * 1000L;
        long l3 = System.currentTimeMillis();
        SimpleDateFormat simpleDateFormat = l3 - l2 > 15552000000L ? new SimpleDateFormat("MMM dd  yyyy") : new SimpleDateFormat("MMM dd hh:mm");
        return simpleDateFormat.format(new Date(l2));
    }

    public boolean isDirectory() {
        if (this.h == null) {
            return false;
        }
        return (this.h.intValue() & 0x4000) == 16384;
    }

    public boolean isFile() {
        if (this.h == null) {
            return false;
        }
        return (this.h.intValue() & 0x8000) == 32768;
    }

    public boolean isLink() {
        if (this.h == null) {
            return false;
        }
        return (this.h.intValue() & 0xA000) == 40960;
    }

    public boolean isFifo() {
        if (this.h == null) {
            return false;
        }
        return (this.h.intValue() & 0x1000) == 4096;
    }

    public boolean isBlock() {
        if (this.h == null) {
            return false;
        }
        return (this.h.intValue() & 0x6000) == 24576;
    }

    public boolean isCharacter() {
        if (this.h == null) {
            return false;
        }
        return (this.h.intValue() & 0x2000) == 8192;
    }

    public boolean isSocket() {
        if (this.h == null) {
            return false;
        }
        return (this.h.intValue() & 0xC000) == 49152;
    }
}

