/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.session;

import com.enterprisedt.net.j2ssh.connection.ChannelInputStream;
import com.enterprisedt.net.j2ssh.connection.IOChannel;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelExtendedData;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger32;
import com.enterprisedt.net.j2ssh.session.PseudoTerminal;
import com.enterprisedt.net.j2ssh.session.SignalListener;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemClient;
import com.enterprisedt.net.j2ssh.transport.SshMessageStore;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.io.InputStream;

public class SessionChannelClient
extends IOChannel {
    private static Logger a = Logger.getLogger(c == null ? (c = SessionChannelClient.class$("com.enterprisedt.net.j2ssh.session.SessionChannelClient")) : c);
    private Integer b = null;
    private String d = "Uninitialized";
    private SubsystemClient e;
    private boolean f = false;
    private SignalListener g;
    private SshMessageStore h = new SshMessageStore();
    private ChannelInputStream i = new ChannelInputStream(this.h, new Integer(1));
    static Class c;

    public SessionChannelClient() {
        this.setName("session");
    }

    public byte[] getChannelOpenData() {
        return null;
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }

    public String getChannelType() {
        return "session";
    }

    protected int getMinimumWindowSpace() {
        return 1024;
    }

    protected int getMaximumWindowSpace() {
        return 32648;
    }

    protected int getMaximumPacketSize() {
        return 32648;
    }

    public void setSignalListener(SignalListener signalListener) {
        this.g = signalListener;
    }

    public boolean setEnvironmentVariable(String name, String value) throws IOException {
        a.debug("Requesting environment variable to be set [" + name + "=" + value + "]");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(name);
        byteArrayWriter.writeString(value);
        return this.connection.sendChannelRequest(this, "env", true, byteArrayWriter.toByteArray());
    }

    public boolean requestX11Forwarding(int display, String cookie) throws IOException {
        a.debug("Requesting X11 forwarding for display " + display + " using cookie " + cookie);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeBoolean(false);
        byteArrayWriter.writeString("MIT-MAGIC-COOKIE-1");
        byteArrayWriter.writeString(cookie);
        byteArrayWriter.writeUINT32(new UnsignedInteger32(String.valueOf(display)));
        return this.connection.sendChannelRequest(this, "x11-req", true, byteArrayWriter.toByteArray());
    }

    public Integer getExitCode() {
        return this.b;
    }

    public void changeTerminalDimensions(PseudoTerminal term) throws IOException {
        a.debug("Changing terminal dimensions");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeInt(term.getColumns());
        byteArrayWriter.writeInt(term.getRows());
        byteArrayWriter.writeInt(term.getWidth());
        byteArrayWriter.writeInt(term.getHeight());
        this.connection.sendChannelRequest(this, "window-change", false, byteArrayWriter.toByteArray());
    }

    public boolean executeCommand(String command) throws IOException {
        a.debug("Requesting command execution");
        a.debug("Command is " + command);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(command);
        if (this.connection.sendChannelRequest(this, "exec", true, byteArrayWriter.toByteArray())) {
            if (this.d.equals("Uninitialized")) {
                this.d = command;
            }
            return true;
        }
        return false;
    }

    public boolean requestPseudoTerminal(String term, int cols, int rows, int width, int height, String terminalModes) throws IOException {
        a.debug("Requesting pseudo terminal");
        if (a.isDebugEnabled()) {
            a.debug("Terminal Type is " + term);
            a.debug("Columns=" + String.valueOf(cols));
            a.debug("Rows=" + String.valueOf(rows));
            a.debug("Width=" + String.valueOf(width));
            a.debug("Height=" + String.valueOf(height));
        }
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(term);
        byteArrayWriter.writeInt(cols);
        byteArrayWriter.writeInt(rows);
        byteArrayWriter.writeInt(width);
        byteArrayWriter.writeInt(height);
        byteArrayWriter.writeString(terminalModes);
        return this.connection.sendChannelRequest(this, "pty-req", true, byteArrayWriter.toByteArray());
    }

    public boolean requestPseudoTerminal(PseudoTerminal term) throws IOException {
        return this.requestPseudoTerminal(term.getTerm(), term.getColumns(), term.getRows(), term.getWidth(), term.getHeight(), term.getEncodedTerminalModes());
    }

    public boolean startShell() throws IOException {
        a.debug("Requesting users shell");
        if (this.connection.sendChannelRequest(this, "shell", true, null)) {
            if (this.d.equals("Uninitialized")) {
                this.d = "shell";
            }
            return true;
        }
        return false;
    }

    public boolean startSubsystem(String subsystem) throws IOException {
        a.debug("Starting " + subsystem + " subsystem");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(subsystem);
        if (this.connection.sendChannelRequest(this, "subsystem", true, byteArrayWriter.toByteArray())) {
            if (this.d.equals("Uninitialized")) {
                this.d = subsystem;
            }
            return true;
        }
        return false;
    }

    public boolean startSubsystem(SubsystemClient subsystem) throws IOException {
        boolean bl = this.startSubsystem(subsystem.getName());
        if (bl) {
            this.e = subsystem;
            subsystem.setSessionChannel(this);
            subsystem.start();
        }
        return bl;
    }

    public boolean isLocalFlowControlEnabled() {
        return this.f;
    }

    public String getSessionType() {
        return this.d;
    }

    public void setSessionType(String sessionType) {
        this.d = sessionType;
    }

    public SubsystemClient getSubsystem() {
        return this.e;
    }

    protected void onChannelClose() throws IOException {
        super.onChannelClose();
        try {
            this.i.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Integer n2 = this.getExitCode();
        if (n2 != null) {
            a.debug("Exit code " + n2.toString());
        }
    }

    protected void onChannelOpen() throws IOException {
    }

    public InputStream getStderrInputStream() throws IOException {
        return this.i;
    }

    protected void onChannelExtData(SshMsgChannelExtendedData msg) throws IOException {
        this.h.addMessage(msg);
    }

    protected void onChannelRequest(String requestType, boolean wantReply, byte[] requestData) throws IOException {
        a.debug("Channel Request received: " + requestType);
        if (requestType.equals("exit-status")) {
            this.b = new Integer((int)ByteArrayReader.readInt(requestData, 0));
            a.debug("Exit code of " + this.b.toString() + " received");
        } else if (requestType.equals("exit-signal")) {
            ByteArrayReader byteArrayReader = new ByteArrayReader(requestData);
            String string = byteArrayReader.readString();
            boolean bl = byteArrayReader.read() != 0;
            String string2 = byteArrayReader.readString();
            byteArrayReader.readString();
            a.debug("Exit signal " + string + " received");
            a.debug("Signal message: " + string2);
            a.debug("Core dumped: " + String.valueOf(bl));
            if (this.g != null) {
                this.g.onExitSignal(string, bl, string2);
            }
        } else if (requestType.equals("xon-xoff")) {
            if (requestData.length >= 1) {
                this.f = requestData[0] != 0;
            }
        } else if (requestType.equals("signal")) {
            String string = ByteArrayReader.readString(requestData, 0);
            a.debug("Signal " + string + " received");
            if (this.g != null) {
                this.g.onSignal(string);
            }
        } else if (wantReply) {
            this.connection.sendChannelRequestFailure(this);
        }
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

