/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.io;

import com.enterprisedt.net.j2ssh.io.UnsignedInteger32;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class ByteArrayWriter
extends ByteArrayOutputStream {
    private String a = "UTF-8";
    public static final int DEFAULT_BUF_SIZE = 64;

    public ByteArrayWriter() {
        super(64);
    }

    public ByteArrayWriter(int len) {
        super(len);
    }

    public ByteArrayWriter(String encoding) {
        super(64);
        this.a = encoding;
    }

    public void writeBigInteger(BigInteger bi) throws IOException {
        byte[] byArray = bi.toByteArray();
        this.writeInt(byArray.length);
        this.write(byArray);
    }

    public void writeBoolean(boolean b2) throws IOException {
        this.write(b2 ? 1 : 0);
    }

    public void writeBinaryString(byte[] data) throws IOException {
        this.writeInt(data.length);
        this.write(data);
    }

    public void writeInt(long i2) throws IOException {
        byte[] byArray = new byte[]{(byte)(i2 >> 24), (byte)(i2 >> 16), (byte)(i2 >> 8), (byte)i2};
        this.write(byArray);
    }

    public void writeInt(int i2) throws IOException {
        byte[] byArray = new byte[]{(byte)(i2 >> 24), (byte)(i2 >> 16), (byte)(i2 >> 8), (byte)i2};
        this.write(byArray);
    }

    public static byte[] encodeInt(int i2) {
        byte[] byArray = new byte[]{(byte)(i2 >> 24), (byte)(i2 >> 16), (byte)(i2 >> 8), (byte)i2};
        return byArray;
    }

    public void writeUINT32(UnsignedInteger32 value) throws IOException {
        this.writeInt(value.longValue());
    }

    public void writeUINT64(UnsignedInteger64 value) throws IOException {
        byte[] byArray = new byte[8];
        byte[] byArray2 = value.bigIntValue().toByteArray();
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        this.write(byArray);
    }

    public static void writeIntToArray(byte[] array, int pos, int value) throws IOException {
        if (array.length - pos < 4) {
            throw new IOException("Not enough data in array to write integer at position " + String.valueOf(pos));
        }
        array[pos] = (byte)(value >> 24);
        array[pos + 1] = (byte)(value >> 16);
        array[pos + 2] = (byte)(value >> 8);
        array[pos + 3] = (byte)value;
    }

    public void writeString(String str) throws IOException {
        if (this.a == null) {
            this.a = "UTF-8";
        }
        if (str == null) {
            this.writeInt(0);
        } else {
            byte[] byArray = str.getBytes(this.a);
            this.writeBinaryString(byArray);
        }
    }
}

