/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.connection;

import com.enterprisedt.net.j2ssh.connection.Channel;
import com.enterprisedt.net.j2ssh.connection.ChannelInputStream;
import com.enterprisedt.net.j2ssh.connection.ChannelOutputStream;
import com.enterprisedt.net.j2ssh.connection.ConnectionProtocol;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelData;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelExtendedData;
import com.enterprisedt.net.j2ssh.io.IOStreamConnector;
import com.enterprisedt.net.j2ssh.transport.MessageNotAvailableException;
import com.enterprisedt.net.j2ssh.transport.MessageStoreEOFException;
import com.enterprisedt.net.j2ssh.transport.SshMessageStore;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class IOChannel
extends Channel {
    private static Logger a = Logger.getLogger("IOChannel");
    private SshMessageStore b = new SshMessageStore();
    protected ChannelInputStream in;
    protected ChannelOutputStream out;
    protected InputStream boundInputStream = null;
    protected OutputStream boundOutputStream = null;
    protected IOStreamConnector ios = null;

    protected void init(ConnectionProtocol connection, long localChannelId, long senderChannelId, long initialWindowSize, long maximumPacketSize, int timeout) throws IOException {
        this.in = new ChannelInputStream(this.b);
        this.out = new ChannelOutputStream(this);
        super.init(connection, localChannelId, senderChannelId, initialWindowSize, maximumPacketSize, timeout);
    }

    protected void open() throws IOException {
        super.open();
        if (this.boundOutputStream != null) {
            this.a();
        }
        if (this.boundInputStream != null && this.ios == null) {
            this.ios.setCloseInput(false);
            this.ios.setCloseOutput(false);
            this.ios.connect(this.boundInputStream, this.out);
        }
    }

    public ChannelInputStream getInputStream() {
        return this.in;
    }

    public ChannelOutputStream getOutputStream() {
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChannelData(SshMsgChannelData msg) throws IOException {
        SshMessageStore sshMessageStore = this.b;
        synchronized (sshMessageStore) {
            if (this.boundOutputStream != null) {
                try {
                    this.boundOutputStream.write(msg.getChannelData());
                }
                catch (IOException iOException) {
                    a.debug("Could not route data to the bound OutputStream; Closing channel.");
                    a.debug(iOException.getMessage());
                    this.close();
                }
            } else {
                this.b.addMessage(msg);
            }
        }
    }

    public void setLocalEOF() throws IOException {
        super.setLocalEOF();
        if (!this.out.isClosed()) {
            this.out.close();
        }
    }

    protected void onChannelEOF() throws IOException {
        if (!this.in.isClosed()) {
            this.in.close();
        }
    }

    protected void onChannelClose() throws IOException {
        if (!this.in.isClosed()) {
            this.in.close();
        }
        if (!this.out.isClosed()) {
            this.out.close();
        }
        if (this.ios != null) {
            this.ios.close();
        }
    }

    protected void onChannelExtData(SshMsgChannelExtendedData msg) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindOutputStream(OutputStream boundOutputStream) throws IOException {
        SshMessageStore sshMessageStore = this.b;
        synchronized (sshMessageStore) {
            this.boundOutputStream = boundOutputStream;
            if (this.state.getValue() == 2) {
                this.a();
            }
        }
    }

    public void bindInputStream(InputStream boundInputStream) throws IOException {
        this.boundInputStream = boundInputStream;
        this.ios = new IOStreamConnector();
        if (this.state.getValue() == 2) {
            this.ios.setCloseInput(false);
            this.ios.setCloseOutput(false);
            this.ios.connect(boundInputStream, this.out);
        }
    }

    private void a() throws IOException {
        if (this.boundInputStream != null && this.boundOutputStream != null && this.b.hasMessages()) {
            block6: while (true) {
                try {
                    while (true) {
                        SshMsgChannelData sshMsgChannelData = (SshMsgChannelData)this.b.peekMessage(94);
                        this.b.removeMessage(sshMsgChannelData);
                        try {
                            this.boundOutputStream.write(sshMsgChannelData.getChannelData());
                            continue block6;
                        }
                        catch (IOException iOException) {
                            this.close();
                            continue;
                        }
                        break;
                    }
                }
                catch (MessageStoreEOFException messageStoreEOFException) {
                    break;
                }
                catch (MessageNotAvailableException messageNotAvailableException) {
                    break;
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("The thread was interrupted");
                }
            }
        }
    }
}

