/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.connection;

import com.enterprisedt.net.j2ssh.connection.ChannelDataWindow;
import com.enterprisedt.net.j2ssh.connection.ChannelEventListener;
import com.enterprisedt.net.j2ssh.connection.ChannelState;
import com.enterprisedt.net.j2ssh.connection.ConnectionProtocol;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelData;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelExtendedData;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public abstract class Channel {
    private static Logger a = Logger.getLogger("Channel");
    protected ChannelDataWindow localWindow = new ChannelDataWindow("local");
    protected ChannelDataWindow remoteWindow = new ChannelDataWindow("remote");
    protected ConnectionProtocol connection;
    protected long localChannelId;
    protected long localPacketSize;
    protected long remoteChannelId;
    protected long remotePacketSize;
    protected ChannelState state = new ChannelState();
    private boolean b = false;
    private boolean c = false;
    private boolean d = false;
    private boolean e = false;
    private String f = "Unnamed Channel";
    private Vector g = new Vector();
    private int h;

    public Channel() {
        this.localPacketSize = this.getMaximumPacketSize();
        this.localWindow.increaseWindowSpace(this.getMaximumWindowSpace());
    }

    public abstract byte[] getChannelOpenData();

    public abstract byte[] getChannelConfirmationData();

    public abstract String getChannelType();

    protected abstract int getMinimumWindowSpace();

    protected abstract int getMaximumWindowSpace();

    protected abstract int getMaximumPacketSize();

    protected abstract void onChannelData(SshMsgChannelData var1) throws IOException;

    protected void processChannelData(SshMsgChannelData msg) throws IOException {
        if (!this.isClosed()) {
            if (msg.getChannelDataLength() > this.localWindow.getWindowSpace()) {
                throw new IOException("More data received than is allowed by the channel data window [" + this.f + "]");
            }
            long l2 = this.localWindow.consumeWindowSpace(msg.getChannelData().length);
            if (l2 < (long)this.getMinimumWindowSpace()) {
                if (a.isDebugEnabled()) {
                    a.debug("Channel " + String.valueOf(this.localChannelId) + " requires more window space [" + this.f + "]");
                }
                l2 = (long)this.getMaximumWindowSpace() - l2;
                a.debug("Requesting connection protocol increase window");
                this.connection.sendChannelWindowAdjust(this, l2);
                this.localWindow.increaseWindowSpace(l2);
            }
            this.onChannelData(msg);
            Iterator iterator = this.g.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onDataReceived(this, msg.getChannelData());
            }
        } else {
            throw new IOException("Channel data received but channel is closed [" + this.f + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            return this.state.getValue() == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            return this.state.getValue() == 2;
        }
    }

    protected void sendChannelData(byte[] data) throws IOException {
        if (!this.connection.isConnected()) {
            throw new IOException("The connection has been closed [" + this.f + "]");
        }
        if (!this.isClosed()) {
            this.connection.sendChannelData(this, data);
            Iterator iterator = this.g.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onDataSent(this, data);
            }
        } else {
            throw new IOException("The channel is closed [" + this.f + "]");
        }
    }

    protected void sendChannelExtData(int type, byte[] data) throws IOException {
        if (!this.connection.isConnected()) {
            throw new IOException("The connection has been closed [" + this.f + "]");
        }
        if (!this.isClosed()) {
            this.connection.sendChannelExtData(this, type, data);
            Iterator iterator = this.g.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onDataSent(this, data);
            }
        } else {
            throw new IOException("The channel is closed [" + this.f + "]");
        }
    }

    protected abstract void onChannelExtData(SshMsgChannelExtendedData var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processChannelData(SshMsgChannelExtendedData msg) throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            if ((long)msg.getChannelData().length > this.localWindow.getWindowSpace()) {
                a.error("Window space=" + this.localWindow.getWindowSpace() + ", data length=" + msg.getChannelData().length);
                throw new IOException("More data received than is allowed by the channel data window [" + this.f + "]");
            }
            long l2 = this.localWindow.consumeWindowSpace(msg.getChannelData().length);
            if (l2 < (long)this.getMinimumWindowSpace()) {
                if (a.isDebugEnabled()) {
                    a.debug("Channel " + String.valueOf(this.localChannelId) + " requires more window space [" + this.f + "]");
                }
                l2 = (long)this.getMaximumWindowSpace() - l2;
                this.connection.sendChannelWindowAdjust(this, l2);
                this.localWindow.increaseWindowSpace(l2);
            }
            this.onChannelExtData(msg);
            Iterator iterator = this.g.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onDataReceived(this, msg.getChannelData());
            }
        }
    }

    public long getLocalChannelId() {
        return this.localChannelId;
    }

    public long getLocalPacketSize() {
        return this.localPacketSize;
    }

    public void setLocalPacketSize(long size) {
        this.localPacketSize = size;
    }

    public ChannelDataWindow getLocalWindow() {
        return this.localWindow;
    }

    public long getRemoteChannelId() {
        return this.remoteChannelId;
    }

    public long getRemotePacketSize() {
        return this.remotePacketSize;
    }

    public ChannelDataWindow getRemoteWindow() {
        return this.remoteWindow;
    }

    public ChannelState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        a.debug("close() called");
        ChannelState channelState = this.state;
        synchronized (channelState) {
            if (this.isOpen()) {
                if (this.connection != null && !this.d && this.connection.isConnected()) {
                    this.connection.closeChannel(this);
                }
                this.d = true;
                if (a.isDebugEnabled()) {
                    a.debug("Connection is " + (this.connection == null ? "null" : (this.connection.isConnected() ? "connected" : "not connected")));
                }
                if (this.e || this.connection == null || !this.connection.isConnected()) {
                    a.debug("Finalizing channel close");
                    this.finalizeClose();
                }
            }
        }
        this.getLocalWindow().stop();
        this.getRemoteWindow().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteClose() throws IOException {
        a.debug("Remote side is closing channel");
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.e = true;
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizeClose() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.state.setValue(3);
            this.onChannelClose();
            Iterator iterator = this.g.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onChannelClose(this);
            }
            if (this.connection != null) {
                this.connection.freeChannel(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalEOF() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.b = true;
            this.connection.sendChannelEOF(this);
        }
    }

    public boolean isLocalEOF() {
        return this.b;
    }

    public boolean isRemoteEOF() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRemoteEOF() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.c = true;
            this.onChannelEOF();
            Iterator iterator = this.g.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onChannelEOF(this);
            }
        }
    }

    public void addEventListener(ChannelEventListener eventListener) {
        this.g.add(eventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(ConnectionProtocol connection, long localChannelId, long senderChannelId, long initialWindowSize, long maximumPacketSize, int timeout) throws IOException {
        this.localChannelId = localChannelId;
        this.remoteChannelId = senderChannelId;
        this.remotePacketSize = maximumPacketSize;
        this.remoteWindow.increaseWindowSpace(initialWindowSize);
        this.connection = connection;
        this.h = timeout;
        this.localWindow.setTimeout(timeout);
        this.remoteWindow.setTimeout(timeout);
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.state.setValue(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.state.setValue(2);
            this.onChannelOpen();
            Iterator iterator = this.g.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onChannelOpen(this);
            }
        }
    }

    protected void init(ConnectionProtocol connection, long localChannelId, long senderChannelId, long initialWindowSize, long maximumPacketSize, int timeout, ChannelEventListener eventListener) throws IOException {
        if (eventListener != null) {
            this.addEventListener(eventListener);
        }
        this.init(connection, localChannelId, senderChannelId, initialWindowSize, maximumPacketSize, timeout);
    }

    protected abstract void onChannelClose() throws IOException;

    protected abstract void onChannelEOF() throws IOException;

    protected abstract void onChannelOpen() throws IOException;

    protected abstract void onChannelRequest(String var1, boolean var2, byte[] var3) throws IOException;

    public void setName(String name) {
        this.f = name;
    }

    public String getName() {
        return this.f;
    }
}

