/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.configuration;

import com.enterprisedt.cryptix.provider.Cryptix;
import com.enterprisedt.net.j2ssh.configuration.ConfigurationContext;
import com.enterprisedt.net.j2ssh.configuration.ConfigurationException;
import com.enterprisedt.net.j2ssh.util.ExtensionClassLoader;
import com.enterprisedt.util.debug.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Vector;

public class ConfigurationLoader {
    private static Vector a = new Vector();
    private static SecureRandom b;
    private static ExtensionClassLoader c;
    private static ClassLoader d;
    private static Logger e;
    private static String f;
    private static boolean g;
    private static Object h;
    private static boolean i;

    public static SecureRandom getRND() {
        return b;
    }

    public static String getVersionString(String projectname, String versionFile) {
        Properties properties = new Properties();
        String string = projectname;
        try {
            properties.load(ConfigurationLoader.loadFile(versionFile));
            String string2 = projectname.toLowerCase();
            String string3 = properties.getProperty(string2 + ".version.major");
            String string4 = properties.getProperty(string2 + ".version.minor");
            String string5 = properties.getProperty(string2 + ".version.build");
            String string6 = properties.getProperty(string2 + ".project.type");
            if (string3 != null && string4 != null && string5 != null) {
                string = string + " " + string3 + "." + string4 + "." + string5;
            }
            if (string6 != null) {
                string = string + " " + string6;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String checkAndGetProperty(String property, String defaultValue) {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new PropertyPermission(property, "read"));
            }
            return System.getProperty(property, defaultValue);
        }
        catch (AccessControlException accessControlException) {
            return defaultValue;
        }
    }

    public static void initialize(boolean force) throws ConfigurationException {
        ConfigurationLoader.initialize(force, new a());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(boolean force, ConfigurationContext context) throws ConfigurationException {
        if (!i) {
            Cryptix cryptix = new Cryptix();
            Security.removeProvider(cryptix.getName());
            Security.addProvider(cryptix);
            i = true;
        }
        try {
            for (int i2 = 0; i2 < Security.getProviders().length; ++i2) {
                e.debug("Security provider " + i2 + ": " + Security.getProviders()[i2].getName());
            }
        }
        catch (Throwable throwable) {
            e.error("Error listing providers: ", throwable);
        }
        Object object = h;
        synchronized (object) {
            if (g && !force) {
                return;
            }
            context.initialize();
            a.add(context);
            g = true;
        }
    }

    public static boolean isConfigurationAvailable(Class cls) throws ConfigurationException {
        if (!g) {
            ConfigurationLoader.initialize(false);
        }
        if (a.size() > 0) {
            Iterator iterator = a.iterator();
            while (iterator.hasNext()) {
                ConfigurationContext configurationContext = (ConfigurationContext)iterator.next();
                if (!configurationContext.isConfigurationAvailable(cls)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static Object getConfiguration(Class cls) throws ConfigurationException {
        if (a.size() > 0) {
            Iterator iterator = a.iterator();
            while (iterator.hasNext()) {
                ConfigurationContext configurationContext = (ConfigurationContext)iterator.next();
                if (!configurationContext.isConfigurationAvailable(cls)) continue;
                return configurationContext.getConfiguration(cls);
            }
        }
        throw new ConfigurationException("No " + cls.getName() + " configuration is available in this context");
    }

    public static String getConfigurationDirectory() {
        return f + "conf/";
    }

    public static Class getExtensionClass(String name) throws ClassNotFoundException, ConfigurationException {
        if (!g) {
            ConfigurationLoader.initialize(false);
        }
        if (c == null) {
            throw new ClassNotFoundException("Configuration not initialized");
        }
        return c.loadClass(name);
    }

    public static String getHomeDirectory() {
        return f;
    }

    public static void setContextClassLoader(ClassLoader clsLoader) {
        d = clsLoader;
    }

    public static ExtensionClassLoader getExtensionClassLoader() {
        return c;
    }

    public static String getExtensionPath() {
        return f + "/lib/ext";
    }

    public static ClassLoader getContextClassLoader() {
        return d;
    }

    public static boolean isContextClassLoader() {
        return d != null;
    }

    public static void setHomeDirectory(String homedir) {
        f = homedir.replace('\\', '/');
        if (!f.endsWith("/")) {
            f = f + "/";
        }
    }

    public static InputStream loadFile(String filename) throws FileNotFoundException {
        try {
            FileInputStream fileInputStream = new FileInputStream(ConfigurationLoader.getConfigurationDirectory() + filename);
            return fileInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                FileInputStream fileInputStream = new FileInputStream(f + filename);
                return fileInputStream;
            }
            catch (FileNotFoundException fileNotFoundException2) {
                FileInputStream fileInputStream = new FileInputStream(filename);
                return fileInputStream;
            }
        }
    }

    public static OutputStream saveFile(String filename) throws FileNotFoundException {
        File file = new File(ConfigurationLoader.getConfigurationDirectory() + filename);
        if (file.exists()) {
            return new FileOutputStream(file);
        }
        file = new File(filename);
        if (file.exists()) {
            return new FileOutputStream(filename);
        }
        return new FileOutputStream(filename.indexOf(File.pathSeparator) >= 0 ? filename : ConfigurationLoader.getConfigurationDirectory() + filename);
    }

    static {
        c = null;
        d = null;
        e = Logger.getLogger("ConfigurationLoader");
        g = false;
        h = new Object();
        i = false;
        f = ConfigurationLoader.checkAndGetProperty("sshtools.home", System.getProperty("java.home"));
        if (f != null && !f.endsWith(File.separator)) {
            f = f + File.separator;
        }
        b = new SecureRandom();
        b.nextInt();
    }

    static class a
    implements ConfigurationContext {
        a() {
        }

        public void initialize() throws ConfigurationException {
        }

        public boolean isConfigurationAvailable(Class cls) {
            return false;
        }

        public Object getConfiguration(Class cls) throws ConfigurationException {
            throw new ConfigurationException("Default configuration does not contain " + cls.getName());
        }
    }
}

